/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl.live;

import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.adl.live.AdlStorageConfiguration;
import org.apache.hadoop.fs.contract.AbstractFSContract;

class AdlStorageContract
extends AbstractFSContract {
    private FileSystem fs;

    protected AdlStorageContract(Configuration conf) {
        super(conf);
        try {
            this.fs = AdlStorageConfiguration.createStorageConnector();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Can not initialize ADL FileSystem. Please check test.fs.adl.name property.", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not initialize ADL FileSystem.", e);
        }
        this.setConf(AdlStorageConfiguration.getConfiguration());
    }

    public String getScheme() {
        return "adl";
    }

    public FileSystem getTestFileSystem() throws IOException {
        return this.fs;
    }

    public Path getTestPath() {
        return new Path("/test");
    }

    public boolean isEnabled() {
        return AdlStorageConfiguration.isContractTestEnabled();
    }
}

