/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.adl.AdlFileSystem;
import org.apache.hadoop.fs.adl.TokenProviderType;
import org.junit.Assert;
import org.junit.Test;

public class TestRelativePathFormation {
    @Test
    public void testToRelativePath() throws URISyntaxException, IOException {
        AdlFileSystem fs = new AdlFileSystem();
        Configuration configuration = new Configuration();
        configuration.setEnum("fs.adl.oauth2.access.token.provider.type", (Enum)TokenProviderType.Custom);
        configuration.set("fs.adl.oauth2.access.token.provider", "org.apache.hadoop.fs.adl.common.CustomMockTokenProvider");
        fs.initialize(new URI("adl://temp.account.net"), configuration);
        Assert.assertEquals((Object)"/usr", (Object)fs.toRelativeFilePath(new Path("/usr")));
        Assert.assertEquals((Object)"/usr", (Object)fs.toRelativeFilePath(new Path("adl://temp.account.net/usr")));
        fs.setWorkingDirectory(new Path("/a/b/"));
        Assert.assertEquals((Object)"/usr", (Object)fs.toRelativeFilePath(new Path("/usr")));
        Assert.assertEquals((Object)"/a/b/usr", (Object)fs.toRelativeFilePath(new Path("usr")));
        Assert.assertEquals((Object)"/usr", (Object)fs.toRelativeFilePath(new Path("adl://temp.account.net/usr")));
        Assert.assertEquals((Object)"/usr", (Object)fs.toRelativeFilePath(new Path("wasb://temp.account.net/usr")));
    }
}

