/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.security.authentication.util.SignerSecretProvider;

@InterfaceStability.Unstable
@VisibleForTesting
class StringSignerSecretProvider
extends SignerSecretProvider {
    private byte[] secret;
    private byte[][] secrets;

    public void init(Properties config, ServletContext servletContext, long tokenValidity) throws Exception {
        String signatureSecret = config.getProperty("signature.secret", null);
        this.secret = signatureSecret.getBytes(StandardCharsets.UTF_8);
        this.secrets = new byte[][]{this.secret};
    }

    public byte[] getCurrentSecret() {
        return this.secret;
    }

    public byte[][] getAllSecrets() {
        return this.secrets;
    }
}

