/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.hadoop.security.authentication.util.JaasConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TestJaasConfiguration {
    @Test
    public void test() throws Exception {
        String krb5LoginModuleName = System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
        JaasConfiguration jConf = new JaasConfiguration("foo", "foo/localhost", "/some/location/foo.keytab");
        AppConfigurationEntry[] entries = jConf.getAppConfigurationEntry("bar");
        Assert.assertNull((Object)entries);
        entries = jConf.getAppConfigurationEntry("foo");
        Assert.assertEquals((long)1L, (long)entries.length);
        AppConfigurationEntry entry = entries[0];
        Assert.assertEquals((Object)AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, (Object)entry.getControlFlag());
        Assert.assertEquals((Object)krb5LoginModuleName, (Object)entry.getLoginModuleName());
        Map<String, ?> options = entry.getOptions();
        Assert.assertEquals((Object)"/some/location/foo.keytab", options.get("keyTab"));
        Assert.assertEquals((Object)"foo/localhost", options.get("principal"));
        Assert.assertEquals((Object)"true", options.get("useKeyTab"));
        Assert.assertEquals((Object)"true", options.get("storeKey"));
        Assert.assertEquals((Object)"false", options.get("useTicketCache"));
        Assert.assertEquals((Object)"true", options.get("refreshKrb5Config"));
        Assert.assertEquals((long)6L, (long)options.size());
    }
}

