/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.LdapAuthenticationHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", address="localhost")})
@CreateDS(allowAnonAccess=true, partitions={@CreatePartition(name="Test_Partition", suffix="dc=example,dc=com", contextEntry=@ContextEntry(entryLdif="dn: dc=example,dc=com \ndc: example\nobjectClass: top\nobjectClass: domain\n\n"))})
@ApplyLdifs(value={"dn: uid=bjones,dc=example,dc=com", "cn: Bob Jones", "sn: Jones", "objectClass: inetOrgPerson", "uid: bjones", "userPassword: p@ssw0rd"})
public class TestLdapAuthenticationHandler
extends AbstractLdapTestUnit {
    private LdapAuthenticationHandler handler;

    @Before
    public void setup() throws Exception {
        this.handler = new LdapAuthenticationHandler();
        try {
            this.handler.init(this.getDefaultProperties());
        }
        catch (Exception e) {
            this.handler = null;
            throw e;
        }
    }

    protected Properties getDefaultProperties() {
        Properties p = new Properties();
        p.setProperty("ldap.basedn", "dc=example,dc=com");
        p.setProperty("ldap.providerurl", String.format("ldap://%s:%s", "localhost", TestLdapAuthenticationHandler.getLdapServer().getPort()));
        return p;
    }

    @Test(timeout=60000L)
    public void testRequestWithoutAuthorization() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Assert.assertNull((Object)this.handler.authenticate(request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).setHeader("WWW-Authenticate", "Basic");
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(401);
    }

    @Test(timeout=60000L)
    public void testRequestWithInvalidAuthorization() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Base64 base64 = new Base64(0);
        String credentials = "bjones:invalidpassword";
        Mockito.when((Object)request.getHeader("Authorization")).thenReturn((Object)base64.encodeToString(credentials.getBytes()));
        Assert.assertNull((Object)this.handler.authenticate(request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).setHeader("WWW-Authenticate", "Basic");
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(401);
    }

    @Test(timeout=60000L)
    public void testRequestWithIncompleteAuthorization() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getHeader("Authorization")).thenReturn((Object)"Basic");
        Assert.assertNull((Object)this.handler.authenticate(request, response));
    }

    @Test(timeout=60000L)
    public void testRequestWithAuthorization() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Base64 base64 = new Base64(0);
        String credentials = base64.encodeToString("bjones:p@ssw0rd".getBytes());
        String authHeader = "Basic " + credentials;
        Mockito.when((Object)request.getHeader("Authorization")).thenReturn((Object)authHeader);
        AuthenticationToken token = this.handler.authenticate(request, response);
        Assert.assertNotNull((Object)token);
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(200);
        Assert.assertEquals((Object)"ldap", (Object)token.getType());
        Assert.assertEquals((Object)"bjones", (Object)token.getUserName());
        Assert.assertEquals((Object)"bjones", (Object)token.getName());
    }

    @Test(timeout=60000L)
    public void testRequestWithWrongCredentials() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Base64 base64 = new Base64(0);
        String credentials = base64.encodeToString("bjones:foo123".getBytes());
        String authHeader = "Basic " + credentials;
        Mockito.when((Object)request.getHeader("Authorization")).thenReturn((Object)authHeader);
        try {
            this.handler.authenticate(request, response);
            Assert.fail();
        }
        catch (AuthenticationException authenticationException) {
        }
        catch (Exception ex) {
            Assert.fail();
        }
    }
}

