/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.Serializable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionMetadata;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.api.TopicMetadata;
import kafka.client.ClientUtils$;
import kafka.cluster.BrokerEndPoint;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.ToolsUtils$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class GetOffsetShell$ {
    public static GetOffsetShell$ MODULE$;

    static {
        new GetOffsetShell$();
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec topicOpt = parser.accepts("topic", "REQUIRED: The topic to get offset from.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec partitionOpt = parser.accepts("partitions", "comma separated list of partition ids. If not specified, it will find offsets for all partitions").withRequiredArg().describedAs("partition ids").ofType(String.class).defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec timeOpt = parser.accepts("time", "timestamp of the offsets before that").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(-1L), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec nOffsetsOpt = parser.accepts("offsets", "number of offsets returned").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec maxWaitMsOpt = parser.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1000), (Object[])new Integer[0]);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "An interactive shell for getting consumer offsets.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerListOpt, topicOpt}));
        String clientId = "GetOffsetShell";
        String brokerList = (String)options.valueOf((OptionSpec)brokerListOpt);
        ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
        Seq<BrokerEndPoint> metadataTargetBrokers = ClientUtils$.MODULE$.parseBrokerList(brokerList);
        String topic = (String)options.valueOf((OptionSpec)topicOpt);
        String partitionList = (String)options.valueOf((OptionSpec)partitionOpt);
        long time = (Long)options.valueOf((OptionSpec)timeOpt);
        int nOffsets = (Integer)options.valueOf((OptionSpec)nOffsetsOpt);
        int maxWaitMs = (Integer)options.valueOf((OptionSpec)maxWaitMsOpt);
        Seq<TopicMetadata> topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), metadataTargetBrokers, clientId, maxWaitMs, ClientUtils$.MODULE$.fetchTopicMetadata$default$5()).topicsMetadata();
        if (topicsMetadata.size() != 1 || !((TopicMetadata)topicsMetadata.head()).topic().equals(topic)) {
            System.err.println(new StringOps(Predef$.MODULE$.augmentString("Error: no valid topic metadata for topic: %s,  probably the topic does not exist, run ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})) + "kafka-list-topic.sh to verify");
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        String string = partitionList;
        String string2 = "";
        Seq partitions = !(string != null ? !string.equals(string2) : string2 != null) ? (Seq)((TopicMetadata)topicsMetadata.head()).partitionsMetadata().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.partitionId()), Seq$.MODULE$.canBuildFrom()) : new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionList.split(","))).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)GetOffsetShell$.$anonfun$main$2(x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).toSeq();
        partitions.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> {
            Option partitionMetadataOpt = ((TopicMetadata)topicsMetadata.head()).partitionsMetadata().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)GetOffsetShell$.$anonfun$main$4(partitionId, x$3)));
            Option option = partitionMetadataOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                PartitionMetadata metadata = (PartitionMetadata)some.value();
                Option<BrokerEndPoint> option2 = metadata.leader();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    BrokerEndPoint leader = (BrokerEndPoint)some2.value();
                    SimpleConsumer consumer = new SimpleConsumer(leader.host(), leader.port(), 10000, 100000, clientId);
                    TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionId);
                    OffsetRequest request = new OffsetRequest((Map<TopicAndPartition, PartitionOffsetRequestInfo>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(time, nOffsets))}))), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
                    Seq<Object> offsets = ((PartitionOffsetsResponse)consumer.getOffsetsBefore(request).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets();
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%s:%d:%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionId), offsets.mkString(",")})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option2)) {
                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("Error: partition %d does not have a leader. Skip getting offsets")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionId)})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(option2);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                System.err.println(new StringOps(Predef$.MODULE$.augmentString("Error: partition %d does not exist")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionId)})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        });
    }

    public static final /* synthetic */ int $anonfun$main$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$main$4(int partitionId$1, PartitionMetadata x$3) {
        return x$3.partitionId() == partitionId$1;
    }

    private GetOffsetShell$() {
        MODULE$ = this;
    }
}

