/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.api.KAFKA_0_10_0_IV0$;
import kafka.api.KAFKA_0_10_1_IV1$;
import kafka.api.KAFKA_0_10_1_IV2$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_11_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_1_IV0$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.LogConfig$;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaFetcherBlockingSend;
import kafka.server.ReplicaFetcherThread$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManager;
import kafka.server.epoch.LeaderEpochCache;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\r\u0015e\u0001B\u0001\u0003\u0001\u001d\u0011ACU3qY&\u001c\u0017MR3uG\",'\u000f\u00165sK\u0006$'BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012D\u0011\"\u0004\u0001\u0003\u0002\u0003\u0006IAD\u000e\u0002\t9\fW.\u001a\t\u0003\u001faq!\u0001\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0005M1\u0011A\u0002\u001fs_>$hHC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9B#\u0001\u0004Qe\u0016$WMZ\u0005\u00033i\u0011aa\u0015;sS:<'BA\f\u0015\u0013\tiA$\u0003\u0002\u001e=\t\u00112\u000b[;uI><h.\u00192mKRC'/Z1e\u0015\tyB!A\u0003vi&d7\u000f\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0003%1W\r^2iKJLE\r\u0005\u0002$I5\tA#\u0003\u0002&)\t\u0019\u0011J\u001c;\t\u0013\u001d\u0002!\u0011!Q\u0001\n!r\u0013\u0001D:pkJ\u001cWM\u0011:pW\u0016\u0014\bCA\u0015-\u001b\u0005Q#BA\u0016\u0005\u0003\u001d\u0019G.^:uKJL!!\f\u0016\u0003\u001d\t\u0013xn[3s\u000b:$\u0007k\\5oi&\u0011qE\u0003\u0005\ta\u0001\u0011\t\u0011)A\u0005c\u0005a!M]8lKJ\u001cuN\u001c4jOB\u0011\u0011BM\u0005\u0003g\t\u00111bS1gW\u0006\u001cuN\u001c4jO\"AQ\u0007\u0001B\u0001B\u0003%a'\u0001\u0006sKBd\u0017nY1NOJ\u0004\"!C\u001c\n\u0005a\u0012!A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\tu\u0001\u0011\t\u0011)A\u0005w\u00059Q.\u001a;sS\u000e\u001c\bC\u0001\u001fF\u001b\u0005i$B\u0001\u001e?\u0015\ty\u0004)\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\u0005S!AQ\"\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0015aA8sO&\u0011a)\u0010\u0002\b\u001b\u0016$(/[2t\u0011!A\u0005A!A!\u0002\u0013I\u0015\u0001\u0002;j[\u0016\u0004\"A\u0013'\u000e\u0003-S!a\b \n\u00055[%\u0001\u0002+j[\u0016D\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001U\u0001\u0006cV|G/\u0019\t\u0003\u0013EK!A\u0015\u0002\u0003/I+\u0007\u000f\\5dCRLwN\\)v_R\fW*\u00198bO\u0016\u0014\b\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B+\u000251,\u0017\rZ3s\u000b:$\u0007o\\5oi\ncwnY6j]\u001e\u001cVM\u001c3\u0011\u0007\r2\u0006,\u0003\u0002X)\t1q\n\u001d;j_:\u0004\"!C-\n\u0005i\u0013!\u0001\u0004\"m_\u000e\\\u0017N\\4TK:$\u0007\"\u0002/\u0001\t\u0003i\u0016A\u0002\u001fj]&$h\b\u0006\u0006_?\u0002\f'm\u00193fM\u001e\u0004\"!\u0003\u0001\t\u000b5Y\u0006\u0019\u0001\b\t\u000b\u0005Z\u0006\u0019\u0001\u0012\t\u000b\u001dZ\u0006\u0019\u0001\u0015\t\u000bAZ\u0006\u0019A\u0019\t\u000bUZ\u0006\u0019\u0001\u001c\t\u000biZ\u0006\u0019A\u001e\t\u000b![\u0006\u0019A%\t\u000b=[\u0006\u0019\u0001)\t\u000fQ[\u0006\u0013!a\u0001+\u0016!\u0011\u000e\u0001\u0001k\u0005\r\u0011V)\u0015\t\u0003Wjt!\u0001\u001c9\u000f\u00055|gBA\to\u0013\u0005)\u0011BA\u0002\u0005\u000f\u0015\t(\u0001#\u0001s\u0003Q\u0011V\r\u001d7jG\u00064U\r^2iKJ$\u0006N]3bIB\u0011\u0011b\u001d\u0004\u0006\u0003\tA\t\u0001^\n\u0003gV\u0004\"a\t<\n\u0005]$\"AB!osJ+g\rC\u0003]g\u0012\u0005\u0011\u0010F\u0001s\r\u0015Y8\u000f\u0001\u0002}\u000511U\r^2i%\u0016\fX/Z:u'\rQX/ \t\u0004}\u0006\raBA\u0005\u0000\u0013\r\t\tAA\u0001\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0013\rY\u0018Q\u0001\u0006\u0004\u0003\u0003\u0011\u0001BCA\u0005u\n\u0015\r\u0011\"\u0001\u0002\f\u0005a1/Z:tS>t\u0007+\u0019:ugV\u0011\u0011Q\u0002\t\t\u0003\u001f\tI\"!\b\u0002&5\u0011\u0011\u0011\u0003\u0006\u0005\u0003'\t)\"\u0001\u0003vi&d'BAA\f\u0003\u0011Q\u0017M^1\n\t\u0005m\u0011\u0011\u0003\u0002\u0004\u001b\u0006\u0004\b\u0003BA\u0010\u0003Ci\u0011AP\u0005\u0004\u0003Gq$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u0003O\t\u0019D\u0004\u0003\u0002*\u0005=RBAA\u0016\u0015\r\tiCP\u0001\te\u0016\fX/Z:ug&!\u0011\u0011GA\u0016\u000311U\r^2i%\u0016\fX/Z:u\u0013\u0011\t)$a\u000e\u0003\u001bA\u000b'\u000f^5uS>tG)\u0019;b\u0015\u0011\t\t$a\u000b\t\u0015\u0005m\"P!A!\u0002\u0013\ti!A\u0007tKN\u001c\u0018n\u001c8QCJ$8\u000f\t\u0005\u000b\u0003\u007fQ(Q1A\u0005\u0002\u0005\u0005\u0013AC;oI\u0016\u0014H._5oOV\u0011\u00111\t\t\u0005\u0003O\t)%\u0003\u0003\u0002H\u0005]\"a\u0002\"vS2$WM\u001d\u0005\u000b\u0003\u0017R(\u0011!Q\u0001\n\u0005\r\u0013aC;oI\u0016\u0014H._5oO\u0002Ba\u0001\u0018>\u0005\u0002\u0005=CCBA)\u0003+\n9\u0006E\u0002\u0002Til\u0011a\u001d\u0005\t\u0003\u0013\ti\u00051\u0001\u0002\u000e!A\u0011qHA'\u0001\u0004\t\u0019\u0005C\u0004\u0002\\i$\t!!\u0018\u0002\r=4gm]3u)\u0011\ty&!\u001a\u0011\u0007\r\n\t'C\u0002\u0002dQ\u0011A\u0001T8oO\"A\u0011qMA-\u0001\u0004\ti\"\u0001\bu_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005-$\u0010\"\u0011\u0002n\u00059\u0011n]#naRLXCAA8!\r\u0019\u0013\u0011O\u0005\u0004\u0003g\"\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003oRH\u0011IA=\u0003!!xn\u0015;sS:<GCAA>!\u0011\ti(a!\u000e\u0005\u0005}$\u0002BAA\u0003+\tA\u0001\\1oO&\u0019\u0011$a \u0007\u000f\u0005U2\u000f\u0001\u0002\u0002\bN)\u0011QQ;\u0002\nB\u0019a0a#\n\t\u0005U\u0012Q\u0001\u0005\f\u0003\u007f\t)I!b\u0001\n\u0003\ty)\u0006\u0002\u0002\u0012B!\u00111SAM\u001d\u0011\tI#!&\n\t\u0005]\u00151F\u0001\u000e\r\u0016$8\r\u001b*fgB|gn]3\n\t\u0005U\u00121\u0014\u0006\u0005\u0003/\u000bY\u0003C\u0006\u0002L\u0005\u0015%\u0011!Q\u0001\n\u0005E\u0005b\u0002/\u0002\u0006\u0012\u0005\u0011\u0011\u0015\u000b\u0005\u0003G\u000b)\u000b\u0005\u0003\u0002T\u0005\u0015\u0005\u0002CA \u0003?\u0003\r!!%\t\u0011\u0005%\u0016Q\u0011C\u0001\u0003W\u000bQ!\u001a:s_J,\"!!,\u0011\t\u0005=\u0016QW\u0007\u0003\u0003cS1!a-?\u0003!\u0001(o\u001c;pG>d\u0017\u0002BA\\\u0003c\u0013a!\u0012:s_J\u001c\b\u0002CA^\u0003\u000b#\t!!0\u0002\u0013Q|'+Z2pe\u0012\u001cXCAA`!\u0011\t\t-a2\u000e\u0005\u0005\r'bAAc}\u00051!/Z2pe\u0012LA!!3\u0002D\niQ*Z7pef\u0014VmY8sIND\u0001\"!4\u0002\u0006\u0012\u0005\u0011qZ\u0001\u000eQ&<\u0007nV1uKJl\u0017M]6\u0016\u0005\u0005}\u0003\u0002CAj\u0003\u000b#\t!a4\u0002\u001d1|wm\u0015;beR|eMZ:fi\"A\u0011q[AC\t\u0003\tI.A\u0005fq\u000e,\u0007\u000f^5p]V\u0011\u00111\u001c\t\u0005GY\u000bi\u000e\u0005\u0003\u0002`\u0006%h\u0002BAq\u0003Kt1!EAr\u0013\u0005)\u0012bAAt)\u00059\u0001/Y2lC\u001e,\u0017\u0002BAv\u0003[\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005\u001dH\u0003\u0003\u0005\u0002x\u0005\u0015E\u0011IA=\u0011%\t\u0019p]I\u0001\n\u0003\t)0A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%O\u000b\u0003\u0003oT3!VA}W\t\tY\u0010\u0005\u0003\u0002~\n\u001dQBAA\u0000\u0015\u0011\u0011\tAa\u0001\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0003)\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t%\u0011q \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,WA\u0002B\u0007\u0001\u0001\u0011yA\u0001\u0002Q\tB\u00191.!\"\t\u0013\tM\u0001A1A\u0005\n\tU\u0011!\u0003:fa2L7-Y%e+\u0005\u0011\u0003b\u0002B\r\u0001\u0001\u0006IAI\u0001\u000be\u0016\u0004H.[2b\u0013\u0012\u0004\u0003\"\u0003B\u000f\u0001\t\u0007I\u0011\u0002B\u0010\u0003)awnZ\"p]R,\u0007\u0010^\u000b\u0003\u0005C\u00012A\u0013B\u0012\u0013\r\u0011)c\u0013\u0002\u000b\u0019><7i\u001c8uKb$\b\u0002\u0003B\u0015\u0001\u0001\u0006IA!\t\u0002\u00171|wmQ8oi\u0016DH\u000f\t\u0005\n\u0005[\u0001!\u0019!C\u0005\u0005_\ta\u0002\\3bI\u0016\u0014XI\u001c3q_&tG/F\u0001Y\u0011\u001d\u0011\u0019\u0004\u0001Q\u0001\na\u000bq\u0002\\3bI\u0016\u0014XI\u001c3q_&tG\u000f\t\u0005\n\u0005o\u0001!\u0019!C\u0005\u0005s\t1CZ3uG\"\u0014V-];fgR4VM]:j_:,\"Aa\u000f\u0011\u0007\r\u0012i$C\u0002\u0003@Q\u0011Qa\u00155peRD\u0001Ba\u0011\u0001A\u0003%!1H\u0001\u0015M\u0016$8\r\u001b*fcV,7\u000f\u001e,feNLwN\u001c\u0011\t\u0013\t\u001d\u0003A1A\u0005\n\u00055\u0014A\u00064fi\u000eDW*\u001a;bI\u0006$\u0018mU;qa>\u0014H/\u001a3\t\u0011\t-\u0003\u0001)A\u0005\u0003_\nqCZ3uG\"lU\r^1eCR\f7+\u001e9q_J$X\r\u001a\u0011\t\u0013\t=\u0003A1A\u0005\n\tE\u0013aB7bq^\u000b\u0017\u000e^\u000b\u0003\u0005'\u0002B!! \u0003V%!!qKA@\u0005\u001dIe\u000e^3hKJD\u0001Ba\u0017\u0001A\u0003%!1K\u0001\t[\u0006Dx+Y5uA!I!q\f\u0001C\u0002\u0013%!\u0011K\u0001\t[&t')\u001f;fg\"A!1\r\u0001!\u0002\u0013\u0011\u0019&A\u0005nS:\u0014\u0015\u0010^3tA!I!q\r\u0001C\u0002\u0013%!\u0011K\u0001\t[\u0006D()\u001f;fg\"A!1\u000e\u0001!\u0002\u0013\u0011\u0019&A\u0005nCb\u0014\u0015\u0010^3tA!I!q\u000e\u0001C\u0002\u0013%!\u0011K\u0001\nM\u0016$8\r[*ju\u0016D\u0001Ba\u001d\u0001A\u0003%!1K\u0001\u000bM\u0016$8\r[*ju\u0016\u0004\u0003\"\u0003B<\u0001\t\u0007I\u0011BA7\u0003q\u0019\bn\\;mIN+g\u000e\u001a'fC\u0012,'/\u00129pG\"\u0014V-];fgRD\u0001Ba\u001f\u0001A\u0003%\u0011qN\u0001\u001eg\"|W\u000f\u001c3TK:$G*Z1eKJ,\u0005o\\2i%\u0016\fX/Z:uA!I!q\u0010\u0001C\u0002\u0013%!\u0011Q\u0001\u0014M\u0016$8\r[*fgNLwN\u001c%b]\u0012dWM]\u000b\u0003\u0005\u0007\u0003BA!\"\u0003\f6\u0011!q\u0011\u0006\u0004\u0005\u0013\u0003\u0015aB2mS\u0016tGo]\u0005\u0005\u0005\u001b\u00139IA\nGKR\u001c\u0007nU3tg&|g\u000eS1oI2,'\u000f\u0003\u0005\u0003\u0012\u0002\u0001\u000b\u0011\u0002BB\u0003Q1W\r^2i'\u0016\u001c8/[8o\u0011\u0006tG\r\\3sA!9!Q\u0013\u0001\u0005\n\t]\u0015!D3q_\u000eD7)Y2iK>\u0003H\u000f\u0006\u0003\u0003\u001a\n\u001d\u0006\u0003B\u0012W\u00057\u0003BA!(\u0003$6\u0011!q\u0014\u0006\u0004\u0005C\u0013\u0011!B3q_\u000eD\u0017\u0002\u0002BS\u0005?\u0013\u0001\u0003T3bI\u0016\u0014X\t]8dQ\u000e\u000b7\r[3\t\u0011\t%&1\u0013a\u0001\u0003;\t!\u0001\u001e9\t\u000f\t5\u0006\u0001\"\u0011\u00030\u0006\u0001\u0012N\\5uS\u0006$Xm\u00155vi\u0012|wO\u001c\u000b\u0003\u0003_BqAa-\u0001\t\u0003\u0011),\u0001\u000bqe>\u001cWm]:QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u000b\t\u0005o\u0013iLa0\u0003DB\u00191E!/\n\u0007\tmFC\u0001\u0003V]&$\b\u0002CA4\u0005c\u0003\r!!\b\t\u0011\t\u0005'\u0011\u0017a\u0001\u0003?\n1BZ3uG\"|eMZ:fi\"A!Q\u0019BY\u0001\u0004\u0011y!A\u0007qCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0005\b\u0005\u0013\u0004A\u0011\u0001Bf\u0003mi\u0017-\u001f2f/\u0006\u0014h.\u00134Pm\u0016\u00148/\u001b>fIJ+7m\u001c:egR1!q\u0017Bg\u0005#D\u0001Ba4\u0003H\u0002\u0007\u0011qX\u0001\be\u0016\u001cwN\u001d3t\u0011!\t9Ga2A\u0002\u0005u\u0001b\u0002Bk\u0001\u0011\u0005!q[\u0001\u0017Q\u0006tG\r\\3PM\u001a\u001cX\r^(vi>3'+\u00198hKR!\u0011q\fBm\u0011!\t9Ga5A\u0002\u0005u\u0001b\u0002Bo\u0001\u0011\u0005!q\\\u0001\u001bQ\u0006tG\r\\3QCJ$\u0018\u000e^5p]N<\u0016\u000e\u001e5FeJ|'o\u001d\u000b\u0005\u0005o\u0013\t\u000f\u0003\u0005\u0003d\nm\u0007\u0019\u0001Bs\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0007\u0003?\u00149/!\b\n\t\t%\u0018Q\u001e\u0002\t\u0013R,'/\u00192mK\"9!Q\u001e\u0001\u0005\u0012\t=\u0018!\u00024fi\u000eDG\u0003\u0002By\u0005{\u0004b!a8\u0003t\n]\u0018\u0002\u0002B{\u0003[\u00141aU3r!\u001d\u0019#\u0011`A\u000f\u0005\u001fI1Aa?\u0015\u0005\u0019!V\u000f\u001d7fe!9!q Bv\u0001\u0004Q\u0017\u0001\u00044fi\u000eD'+Z9vKN$\bbBB\u0002\u0001\u0011%1QA\u0001\u0017K\u0006\u0014H.[3ti>\u0013H*\u0019;fgR|eMZ:fiR1\u0011qLB\u0004\u0007\u0013A\u0001\"a\u001a\u0004\u0002\u0001\u0007\u0011Q\u0004\u0005\t\u0007\u0017\u0019\t\u00011\u0001\u0002`\u0005\u0001R-\u0019:mS\u0016\u001cHo\u0014:MCR,7\u000f\u001e\u0005\b\u0007\u001f\u0001A\u0011IB\t\u0003E\u0011W/\u001b7e\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u000b\u0005\u0007'\u0019I\u0002\u0005\u0003\u007f\u0007+Q\u0017\u0002BB\f\u0003\u000b\u0011ACU3tk2$x+\u001b;i!\u0006\u0014H/\u001b;j_:\u001c\b\u0002CB\u000e\u0007\u001b\u0001\ra!\b\u0002\u0019A\f'\u000f^5uS>tW*\u00199\u0011\r\u0005}'1_B\u0010!\u001d\u0019#\u0011`A\u000f\u0007C\u00012!CB\u0012\u0013\r\u0019)C\u0001\u0002\u0014!\u0006\u0014H/\u001b;j_:4U\r^2i'R\fG/\u001a\u0005\b\u0007S\u0001A\u0011IB\u0016\u00035i\u0017-\u001f2f)J,hnY1uKR!1QFB\u001d!\u0015q8QCB\u0018!!\u0019\tda\u000e\u0002\u001e\u0005}SBAB\u001a\u0015\r\u0019)\u0004F\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u000e\u0007gA\u0001ba\u000f\u0004(\u0001\u00071QH\u0001\u000eM\u0016$8\r[3e\u000bB|7\r[:\u0011\u0011\rE2qGA\u000f\u0007\u007f\u0001B!!\u000b\u0004B%!11IA\u0016\u00059)\u0005o\\2i\u000b:$wJ\u001a4tKRDqaa\u0012\u0001\t\u0003\u001aI%A\fck&dG\rT3bI\u0016\u0014X\t]8dQJ+\u0017/^3tiR!11JB(!\u0015q8QCB'!\u001d\u0019\tda\u000e\u0002\u001e\tB\u0001b!\u0015\u0004F\u0001\u00071QD\u0001\u000eC2d\u0007+\u0019:uSRLwN\\:\t\u000f\rU\u0003\u0001\"\u0011\u0004X\u0005)b-\u001a;dQ\u0016\u0003xn\u00195t\rJ|W\u000eT3bI\u0016\u0014H\u0003BB\u001f\u00073B\u0001Ba9\u0004T\u0001\u00071Q\n\u0005\b\u0007;\u0002A\u0011BB0\u00031awnZ#oI>3gm]3u)\u0019\tyf!\u0019\u0004l!A11MB.\u0001\u0004\u0019)'A\u0004sKBd\u0017nY1\u0011\u0007%\u001a9'C\u0002\u0004j)\u0012qAU3qY&\u001c\u0017\r\u0003\u0005\u0004n\rm\u0003\u0019AB \u0003-)\u0007o\\2i\u001f\u001a47/\u001a;\t\u000f\rE\u0004\u0001\"\u0003\u0004t\u000512\u000f[8vY\u00124u\u000e\u001c7po\u0016\u0014H\u000b\u001b:piRdW\r\u0006\u0004\u0002p\rU4Q\u0010\u0005\b\u001f\u000e=\u0004\u0019AB<!\rI1\u0011P\u0005\u0004\u0007w\u0012!\u0001\u0004*fa2L7-Y)v_R\f\u0007\u0002CA4\u0007_\u0002\r!!\b\t\u001b\r\u0005\u0005\u0001%A\u0002\u0002\u0003%Iaa!/\u0003I\u0019X\u000f]3sIM|WO]2f\u0005J|7.\u001a:\u0016\u0003!\u0002")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    private final int fetcherId;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaMgr;
    private final Metrics metrics;
    private final Time time;
    private final ReplicationQuotaManager quota;
    private final int replicaId;
    private final LogContext logContext;
    private final BlockingSend leaderEndpoint;
    private final short fetchRequestVersion;
    private final boolean fetchMetadataSupported;
    private final Integer maxWait;
    private final Integer minBytes;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private final boolean shouldSendLeaderEpochRequest;
    private final FetchSessionHandler fetchSessionHandler;

    public static Option<BlockingSend> $lessinit$greater$default$9() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$9();
    }

    private /* synthetic */ BrokerEndPoint super$sourceBroker() {
        return super.sourceBroker();
    }

    private int replicaId() {
        return this.replicaId;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private BlockingSend leaderEndpoint() {
        return this.leaderEndpoint;
    }

    private short fetchRequestVersion() {
        return this.fetchRequestVersion;
    }

    private boolean fetchMetadataSupported() {
        return this.fetchMetadataSupported;
    }

    private Integer maxWait() {
        return this.maxWait;
    }

    private Integer minBytes() {
        return this.minBytes;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private boolean shouldSendLeaderEpochRequest() {
        return this.shouldSendLeaderEpochRequest;
    }

    private FetchSessionHandler fetchSessionHandler() {
        return this.fetchSessionHandler;
    }

    private Option<LeaderEpochCache> epochCacheOpt(TopicPartition tp) {
        return this.replicaMgr.getReplica(tp).map((Function1 & Serializable & scala.Serializable)x$1 -> (LeaderEpochCache)x$1.epochs().get());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean initiateShutdown() {
        void var1_1;
        block0: {
            boolean justShutdown = super.initiateShutdown();
            if (!justShutdown) break block0;
            this.leaderEndpoint().close();
        }
        return (boolean)var1_1;
    }

    public void processPartitionData(TopicPartition topicPartition, long fetchOffset, PartitionData partitionData) {
        Replica replica = this.replicaMgr.getReplicaOrException(topicPartition);
        Partition partition = (Partition)this.replicaMgr.getPartition(topicPartition).get();
        MemoryRecords records = partitionData.toRecords();
        this.maybeWarnIfOversizedRecords(records, topicPartition);
        if (fetchOffset != replica.logEndOffset().messageOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for partition %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)replica.logEndOffset().messageOffset())})));
        }
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Follower has replica log end offset %d for partition %s. Received %d messages and leader hw %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)replica.logEndOffset().messageOffset()), topicPartition, BoxesRunTime.boxToInteger((int)records.sizeInBytes()), BoxesRunTime.boxToLong((long)partitionData.highWatermark())})));
        }
        partition.appendRecordsToFollower(records);
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Follower has replica log end offset %d after appending %d bytes of messages for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)replica.logEndOffset().messageOffset()), BoxesRunTime.boxToInteger((int)records.sizeInBytes()), topicPartition})));
        }
        long followerHighWatermark = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(replica.logEndOffset().messageOffset()), partitionData.highWatermark());
        long leaderLogStartOffset = partitionData.logStartOffset();
        replica.highWatermark_$eq(new LogOffsetMetadata(followerHighWatermark, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        replica.maybeIncrementLogStartOffset(leaderLogStartOffset);
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Follower set replica high watermark for partition ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)followerHighWatermark)})));
        }
        if (this.quota.isThrottled(topicPartition)) {
            this.quota.record(records.sizeInBytes());
        }
        this.replicaMgr.brokerTopicStats().updateReplicationBytesIn(records.sizeInBytes());
    }

    public void maybeWarnIfOversizedRecords(MemoryRecords records, TopicPartition topicPartition) {
        block0: {
            if (this.fetchRequestVersion() > 2 || records.sizeInBytes() <= 0 || records.validBytes() > 0) break block0;
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})) + "This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large " + "message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be " + "equal or larger than your settings for max.message.bytes, both at a broker and topic level.");
        }
    }

    @Override
    public long handleOffsetOutOfRange(TopicPartition topicPartition) {
        long l;
        Replica replica = this.replicaMgr.getReplicaOrException(topicPartition);
        Partition partition = (Partition)this.replicaMgr.getPartition(topicPartition).get();
        long leaderEndOffset = this.earliestOrLatestOffset(topicPartition, -1L);
        if (leaderEndOffset < replica.logEndOffset().messageOffset()) {
            AdminZkClient adminZkClient = new AdminZkClient(this.replicaMgr.zkClient());
            if (!LogConfig$.MODULE$.fromProps(this.brokerConfig.originals(), adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Topic(), topicPartition.topic())).uncleanLeaderElectionEnable()) {
                this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exiting because log truncation is not allowed for partition ", ", current leader's "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"latest offset ", " is less than replica's latest offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)leaderEndOffset), BoxesRunTime.boxToLong((long)replica.logEndOffset().messageOffset())})));
                throw new FatalExitError();
            }
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reset fetch offset for partition ", " from ", " to current "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)replica.logEndOffset().messageOffset())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"leader's latest offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)leaderEndOffset)})));
            partition.truncateTo(leaderEndOffset, false);
            this.replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation(this.brokerConfig.brokerId(), topicPartition, leaderEndOffset);
            l = leaderEndOffset;
        } else {
            long leaderStartOffset = this.earliestOrLatestOffset(topicPartition, -2L);
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reset fetch offset for partition ", " from ", " to current "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)replica.logEndOffset().messageOffset())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"leader's start offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)leaderStartOffset)})));
            long offsetToFetch = Math.max(leaderStartOffset, replica.logEndOffset().messageOffset());
            if (leaderStartOffset > replica.logEndOffset().messageOffset()) {
                partition.truncateFullyAndStartAt(leaderStartOffset, false);
            }
            l = offsetToFetch;
        }
        return l;
    }

    @Override
    public void handlePartitionsWithErrors(Iterable<TopicPartition> partitions) {
        block0: {
            if (!partitions.nonEmpty()) break block0;
            this.delayPartitions(partitions, Predef$.MODULE$.Integer2int(this.brokerConfig.replicaFetchBackoffMs()));
        }
    }

    public Seq<Tuple2<TopicPartition, PartitionData>> fetch(FetchRequest fetchRequest) {
        Object object;
        try {
            ClientResponse clientResponse = this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequest.underlying());
            FetchResponse fetchResponse = (FetchResponse)clientResponse.responseBody();
            object = !this.fetchSessionHandler().handleResponse(fetchResponse) ? Nil$.MODULE$ : (Seq)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse.responseData()).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition key = (TopicPartition)tuple2._1();
                FetchResponse.PartitionData value = (FetchResponse.PartitionData)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new PartitionData(value));
                return tuple22;
            }, Seq$.MODULE$.canBuildFrom());
        }
        catch (Throwable t) {
            this.fetchSessionHandler().handleError(t);
            throw t;
        }
        return object;
    }

    private long earliestOrLatestOffset(TopicPartition topicPartition, long earliestOrLatest) {
        ListOffsetRequest.Builder builder;
        if (this.brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$)) {
            Map partitions = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)Predef$.MODULE$.long2Long(earliestOrLatest))}));
            builder = ListOffsetRequest.Builder.forReplica((short)1, (int)this.replicaId()).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(partitions).asJava());
        } else {
            Map partitions = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ListOffsetRequest.PartitionData(earliestOrLatest, 1))}));
            builder = ListOffsetRequest.Builder.forReplica((short)0, (int)this.replicaId()).setOffsetData((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(partitions).asJava());
        }
        ListOffsetRequest.Builder requestBuilder = builder;
        ClientResponse clientResponse = this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)requestBuilder);
        ListOffsetResponse response = (ListOffsetResponse)clientResponse.responseBody();
        ListOffsetResponse.PartitionData partitionData = (ListOffsetResponse.PartitionData)response.responseData().get(topicPartition);
        Errors errors = partitionData.error;
        if (!Errors.NONE.equals(errors)) {
            throw errors.exception();
        }
        long l = this.brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? Predef$.MODULE$.Long2long(partitionData.offset) : Predef$.MODULE$.Long2long((Long)partitionData.offsets.get(0));
        return l;
    }

    public AbstractFetcherThread.ResultWithPartitions<FetchRequest> buildFetchRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> partitionMap) {
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        FetchSessionHandler.Builder builder = this.fetchSessionHandler().newBuilder();
        partitionMap.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                PartitionFetchState partitionFetchState = (PartitionFetchState)tuple2._2();
                if (partitionFetchState.isReadyForFetch() && !this.shouldFollowerThrottle($this.quota, topicPartition)) {
                    try {
                        long logStartOffset = $this.replicaMgr.getReplicaOrException(topicPartition).logStartOffset();
                        builder.add(topicPartition, new FetchRequest.PartitionData(partitionFetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize())));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (KafkaStorageException kafkaStorageException) {
                        boxedUnit = partitionsWithError.$plus$eq((Object)topicPartition);
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
        FetchSessionHandler.FetchRequestData fetchData = builder.build();
        FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica((short)this.fetchRequestVersion(), (int)this.replicaId(), (int)Predef$.MODULE$.Integer2int(this.maxWait()), (int)Predef$.MODULE$.Integer2int(this.minBytes()), (java.util.Map)fetchData.toSend()).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes())).toForget(fetchData.toForget());
        Object object = this.fetchMetadataSupported() ? requestBuilder.metadata(fetchData.metadata()) : BoxedUnit.UNIT;
        return new AbstractFetcherThread.ResultWithPartitions<FetchRequest>(new FetchRequest(fetchData.sessionPartitions(), requestBuilder), (Set<TopicPartition>)partitionsWithError);
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Map<TopicPartition, Object>> maybeTruncate(Map<TopicPartition, EpochEndOffset> fetchedEpochs) {
        HashMap fetchOffsets = HashMap$.MODULE$.empty();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        fetchedEpochs.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            SetLike setLike;
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                EpochEndOffset epochOffset = (EpochEndOffset)tuple2._2();
                try {
                    Replica replica = $this.replicaMgr.getReplicaOrException(tp);
                    Partition partition = (Partition)$this.replicaMgr.getPartition(tp).get();
                    if (epochOffset.hasError()) {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retrying leaderEpoch request for partition ", " as the leader reported an error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica.topicPartition(), epochOffset.error()})));
                        setLike = partitionsWithError.$plus$eq((Object)tp);
                    } else {
                        long l;
                        if (epochOffset.endOffset() == -1L) {
                            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Based on follower's leader epoch, leader replied with an unknown offset in ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica.topicPartition()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The initial fetch offset ", " will be used for truncation."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)((PartitionFetchState)this.partitionStates().stateValue(tp)).fetchOffset())})));
                            l = ((PartitionFetchState)this.partitionStates().stateValue(tp)).fetchOffset();
                        } else {
                            l = epochOffset.endOffset() >= replica.logEndOffset().messageOffset() ? this.logEndOffset(replica, epochOffset) : epochOffset.endOffset();
                        }
                        long fetchOffset = l;
                        partition.truncateTo(fetchOffset, false);
                        $this.replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation($this.brokerConfig.brokerId(), tp, fetchOffset);
                        setLike = fetchOffsets.put((Object)tp, (Object)BoxesRunTime.boxToLong((long)fetchOffset));
                    }
                }
                catch (KafkaStorageException e) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to truncate ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    setLike = partitionsWithError.$plus$eq((Object)tp);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            SetLike setLike2 = setLike;
            return setLike2;
        });
        return new AbstractFetcherThread.ResultWithPartitions<HashMap>(fetchOffsets, (Set<TopicPartition>)partitionsWithError);
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Map<TopicPartition, Object>> buildLeaderEpochRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> allPartitions) {
        scala.collection.immutable.Map partitionEpochOpts = ((TraversableOnce)((TraversableLike)allPartitions.filter((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)ReplicaFetcherThread.$anonfun$buildLeaderEpochRequest$1(x0$4)))).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), this.epochCacheOpt(tp));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Tuple2 tuple2 = partitionEpochOpts.partition((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)ReplicaFetcherThread.$anonfun$buildLeaderEpochRequest$3(x0$6)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Map partitionsWithEpoch = (scala.collection.immutable.Map)tuple2._1();
        scala.collection.immutable.Map partitionsWithoutEpoch = (scala.collection.immutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionsWithEpoch, (Object)partitionsWithoutEpoch);
        Tuple2 tuple23 = tuple22;
        scala.collection.immutable.Map partitionsWithEpoch2 = (scala.collection.immutable.Map)tuple23._1();
        scala.collection.immutable.Map partitionsWithoutEpoch2 = (scala.collection.immutable.Map)tuple23._2();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Build leaderEpoch request ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionsWithEpoch2})));
        scala.collection.immutable.Map result = (scala.collection.immutable.Map)partitionsWithEpoch2.map((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Tuple2 tuple2 = x0$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Option epochCacheOpt = (Option)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToInteger((int)((LeaderEpochCache)epochCacheOpt.get()).latestEpoch()));
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        return new AbstractFetcherThread.ResultWithPartitions<scala.collection.immutable.Map>(result, (Set<TopicPartition>)partitionsWithoutEpoch2.keys().toSet());
    }

    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochsFromLeader(Map<TopicPartition, Object> partitions) {
        ObjectRef result = ObjectRef.create(null);
        if (this.shouldSendLeaderEpochRequest()) {
            java.util.Map partitionsAsJava = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x0$8 -> {
                Tuple2 tuple2 = x0$8;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                int epoch = tuple2._2$mcI$sp();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToInteger((int)epoch));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
            OffsetsForLeaderEpochRequest.Builder epochRequest = new OffsetsForLeaderEpochRequest.Builder(partitionsAsJava);
            try {
                ClientResponse response = this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)epochRequest);
                result.elem = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(((OffsetsForLeaderEpochResponse)response.responseBody()).responses()).asScala();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Receive leaderEpoch response ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Map)result$1.elem})));
            }
            catch (Throwable t) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error when sending leader epoch request for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitions})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                result.elem = (Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$9 -> {
                    Tuple2 tuple2 = x0$9;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(Errors.forException((Throwable)t), -1L));
                    return tuple22;
                }, Map$.MODULE$.canBuildFrom());
            }
        } else {
            result.elem = (Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$10 -> {
                Tuple2 tuple2 = x0$10;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(Errors.NONE, -1L));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        }
        return (Map)result.elem;
    }

    /*
     * WARNING - void declaration
     */
    private long logEndOffset(Replica replica, EpochEndOffset epochOffset) {
        void var3_3;
        long logEndOffset = replica.logEndOffset().messageOffset();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Based on follower's leader epoch, leader replied with an offset ", " >= the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)epochOffset.endOffset())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"follower's log end offset ", " in ", ". No truncation needed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)logEndOffset), replica.topicPartition()})));
        return (long)var3_3;
    }

    private boolean shouldFollowerThrottle(ReplicaQuota quota, TopicPartition topicPartition) {
        boolean isReplicaInSync = this.fetcherLagStats().isReplicaInSync(topicPartition.topic(), topicPartition.partition());
        return quota.isThrottled(topicPartition) && quota.isQuotaExceeded() && !isReplicaInSync;
    }

    public static final /* synthetic */ boolean $anonfun$buildLeaderEpochRequest$1(Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        PartitionFetchState state = (PartitionFetchState)tuple2._2();
        boolean bl = state.isTruncatingLog();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$buildLeaderEpochRequest$3(Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option epochCacheOpt = (Option)tuple2._2();
        boolean bl = epochCacheOpt.nonEmpty();
        return bl;
    }

    public ReplicaFetcherThread(String name, int fetcherId, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, ReplicaManager replicaMgr, Metrics metrics, Time time, ReplicationQuotaManager quota, Option<BlockingSend> leaderEndpointBlockingSend) {
        this.fetcherId = fetcherId;
        this.brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.metrics = metrics;
        this.time = time;
        this.quota = quota;
        super(name, name, sourceBroker, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false, true);
        this.replicaId = brokerConfig.brokerId();
        this.logContext = new LogContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[ReplicaFetcher replicaId=", ", leaderId=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.replicaId()), BoxesRunTime.boxToInteger((int)super.sourceBroker().id())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fetcherId=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)fetcherId)})));
        this.logIdent_$eq(this.logContext().logPrefix());
        this.leaderEndpoint = (BlockingSend)leaderEndpointBlockingSend.getOrElse((Function0 & Serializable & scala.Serializable)() -> new ReplicaFetcherBlockingSend(this.super$sourceBroker(), $this.brokerConfig, $this.metrics, $this.time, $this.fetcherId, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"broker-", "-fetcher-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.replicaId()), BoxesRunTime.boxToInteger((int)$this.fetcherId)})), this.logContext()));
        this.fetchRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_1_1_IV0$.MODULE$) ? 7 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV1$.MODULE$) ? 5 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 4 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_0_IV0$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_9_0$.MODULE$) ? 1 : 0))))));
        this.fetchMetadataSupported = brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_1_1_IV0$.MODULE$);
        this.maxWait = brokerConfig.replicaFetchWaitMaxMs();
        this.minBytes = brokerConfig.replicaFetchMinBytes();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.shouldSendLeaderEpochRequest = brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV2$.MODULE$);
        this.fetchSessionHandler = new FetchSessionHandler(this.logContext(), super.sourceBroker().id());
    }

    public static class FetchRequest
    implements AbstractFetcherThread.FetchRequest {
        private final java.util.Map<TopicPartition, FetchRequest.PartitionData> sessionParts;
        private final FetchRequest.Builder underlying;

        public java.util.Map<TopicPartition, FetchRequest.PartitionData> sessionParts() {
            return this.sessionParts;
        }

        public FetchRequest.Builder underlying() {
            return this.underlying;
        }

        @Override
        public long offset(TopicPartition topicPartition) {
            return this.sessionParts().get((Object)topicPartition).fetchOffset;
        }

        @Override
        public boolean isEmpty() {
            return this.sessionParts().isEmpty() && this.underlying().toForget().isEmpty();
        }

        public String toString() {
            return this.underlying().toString();
        }

        public FetchRequest(java.util.Map<TopicPartition, FetchRequest.PartitionData> sessionParts, FetchRequest.Builder underlying) {
            this.sessionParts = sessionParts;
            this.underlying = underlying;
        }
    }

    public static class PartitionData
    implements AbstractFetcherThread.PartitionData {
        private final FetchResponse.PartitionData underlying;

        public FetchResponse.PartitionData underlying() {
            return this.underlying;
        }

        @Override
        public Errors error() {
            return this.underlying().error;
        }

        @Override
        public MemoryRecords toRecords() {
            return (MemoryRecords)this.underlying().records;
        }

        @Override
        public long highWatermark() {
            return this.underlying().highWatermark;
        }

        public long logStartOffset() {
            return this.underlying().logStartOffset;
        }

        @Override
        public Option<Throwable> exception() {
            Errors errors = this.error();
            Object object = Errors.NONE.equals(errors) ? None$.MODULE$ : new Some((Object)errors.exception());
            return object;
        }

        public String toString() {
            return this.underlying().toString();
        }

        public PartitionData(FetchResponse.PartitionData underlying) {
            this.underlying = underlying;
        }
    }
}

