/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.controller.Callbacks;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerEventManager;
import kafka.controller.KafkaController;
import kafka.controller.NonExistentPartition$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.requests.AbstractResponse;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u0001\u0003\u0001\u001d\u0011A\u0003V8qS\u000e$U\r\\3uS>tW*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\u0005\t\u0007\u0001\u0011\t\u0011)A\u0005+A\u0011acF\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\"A!\u0004\u0001B\u0001B\u0003%1$\u0001\u0007fm\u0016tG/T1oC\u001e,'\u000f\u0005\u0002\u00179%\u0011QD\u0001\u0002\u0017\u0007>tGO]8mY\u0016\u0014XI^3oi6\u000bg.Y4fe\"Aq\u0004\u0001B\u0001B\u0003%\u0001%\u0001\u0005{W\u000ec\u0017.\u001a8u!\t\tC%D\u0001#\u0015\t\u0019C!\u0001\u0002{W&\u0011QE\t\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\t\u000b\u001d\u0002A\u0011\u0001\u0015\u0002\rqJg.\u001b;?)\u0011I#f\u000b\u0017\u0011\u0005Y\u0001\u0001\"B\u0002'\u0001\u0004)\u0002\"\u0002\u000e'\u0001\u0004Y\u0002\"B\u0010'\u0001\u0004\u0001\u0003b\u0002\u0018\u0001\u0005\u0004%\taL\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$X#\u0001\u0019\u0011\u0005Y\t\u0014B\u0001\u001a\u0003\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0005\u0007i\u0001\u0001\u000b\u0011\u0002\u0019\u0002%\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\t\u0005\bm\u0001\u0011\r\u0011\"\u00018\u0003QI7\u000fR3mKR,Gk\u001c9jG\u0016s\u0017M\u00197fIV\t\u0001\b\u0005\u0002\ns%\u0011!H\u0003\u0002\b\u0005>|G.Z1o\u0011\u0019a\u0004\u0001)A\u0005q\u0005)\u0012n\u001d#fY\u0016$X\rV8qS\u000e,e.\u00192mK\u0012\u0004\u0003b\u0002 \u0001\u0005\u0004%\taP\u0001\u0012i>\u0004\u0018nY:U_\n+G)\u001a7fi\u0016$W#\u0001!\u0011\u0007\u00053\u0005*D\u0001C\u0015\t\u0019E)A\u0004nkR\f'\r\\3\u000b\u0005\u0015S\u0011AC2pY2,7\r^5p]&\u0011qI\u0011\u0002\u0004'\u0016$\bCA%Q\u001d\tQe\n\u0005\u0002L\u00155\tAJ\u0003\u0002N\r\u00051AH]8pizJ!a\u0014\u0006\u0002\rA\u0013X\rZ3g\u0013\t\t&K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001f*Aa\u0001\u0016\u0001!\u0002\u0013\u0001\u0015A\u0005;pa&\u001c7\u000fV8CK\u0012+G.\u001a;fI\u0002BqA\u0016\u0001C\u0002\u0013\u0005q+A\u000bqCJ$\u0018\u000e^5p]N$vNQ3EK2,G/\u001a3\u0016\u0003a\u00032!\u0011$Z!\tQ&-D\u0001\\\u0015\taV,\u0001\u0004d_6lwN\u001c\u0006\u0003\u000byS!a\u00181\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0017aA8sO&\u00111m\u0017\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019)\u0007\u0001)A\u00051\u00061\u0002/\u0019:uSRLwN\\:U_\n+G)\u001a7fi\u0016$\u0007\u0005C\u0004h\u0001\t\u0007I\u0011A \u00027Q|\u0007/[2t\u0013:,G.[4jE2,gi\u001c:EK2,G/[8o\u0011\u0019I\u0007\u0001)A\u0005\u0001\u0006aBo\u001c9jGNLe.\u001a7jO&\u0014G.\u001a$pe\u0012+G.\u001a;j_:\u0004\u0003\"B6\u0001\t\u0003a\u0017\u0001B5oSR$2!\u001c9v!\tIa.\u0003\u0002p\u0015\t!QK\\5u\u0011\u0015\t(\u000e1\u0001s\u0003aIg.\u001b;jC2$v\u000e]5dgR{')\u001a#fY\u0016$X\r\u001a\t\u0004gRDU\"\u0001#\n\u0005\u001d#\u0005\"\u0002<k\u0001\u0004\u0011\u0018AI5oSRL\u0017\r\u001c+pa&\u001c7/\u00138fY&<\u0017N\u00197f\r>\u0014H)\u001a7fi&|g\u000eC\u0003y\u0001\u0011\u0005\u00110\u0001\tuef$v\u000e]5d\t\u0016dW\r^5p]R\tQ\u000eC\u0003|\u0001\u0011\u0005\u00110A\u0003sKN,G\u000fC\u0003~\u0001\u0011\u0005a0\u0001\rf]F,X-^3U_BL7m\u001d$pe\u0012+G.\u001a;j_:$\"!\\@\t\r\u0005\u0005A\u00101\u0001s\u0003\u0019!x\u000e]5dg\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0011a\u0006:fgVlW\rR3mKRLwN\u001c$peR{\u0007/[2t)\ri\u0017\u0011\u0002\u0005\n\u0003\u0003\t\u0019\u0001%AA\u0002IDq!!\u0004\u0001\t\u0003\ty!A\ngC&d'+\u001a9mS\u000e\fG)\u001a7fi&|g\u000eF\u0002n\u0003#A\u0001\"a\u0005\u0002\f\u0001\u0007\u0011QC\u0001\te\u0016\u0004H.[2bgB!1\u000f^A\f!\r1\u0012\u0011D\u0005\u0004\u00037\u0011!a\u0005)beRLG/[8o\u0003:$'+\u001a9mS\u000e\f\u0007bBA\u0010\u0001\u0011\u0005\u0011\u0011E\u0001\u001f[\u0006\u00148\u000eV8qS\u000eLe.\u001a7jO&\u0014G.\u001a$pe\u0012+G.\u001a;j_:$2!\\A\u0012\u0011\u001d\t\t!!\bA\u0002IDq!a\n\u0001\t\u0013\tI#\u0001\u000fjgR{\u0007/[2J]\u0016d\u0017nZ5cY\u00164uN\u001d#fY\u0016$\u0018n\u001c8\u0015\u0007a\nY\u0003C\u0004\u0002.\u0005\u0015\u0002\u0019\u0001%\u0002\u000bQ|\u0007/[2\t\u000f\u0005E\u0002\u0001\"\u0003\u00024\u0005I\u0012n\u001d+pa&\u001cG)\u001a7fi&|g.\u00138Qe><'/Z:t)\rA\u0014Q\u0007\u0005\b\u0003[\ty\u00031\u0001I\u0011\u001d\tI\u0004\u0001C\u0001\u0003w\ta#[:QCJ$\u0018\u000e^5p]R{')\u001a#fY\u0016$X\r\u001a\u000b\u0004q\u0005u\u0002bBA \u0003o\u0001\r!W\u0001\u0012i>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007bBA\"\u0001\u0011\u0005\u0011QI\u0001\u001bSN$v\u000e]5d#V,W/\u001a3Va\u001a{'\u000fR3mKRLwN\u001c\u000b\u0004q\u0005\u001d\u0003bBA\u0017\u0003\u0003\u0002\r\u0001\u0013\u0005\b\u0003\u0017\u0002A\u0011AA'\u0003]\u0019w.\u001c9mKR,'+\u001a9mS\u000e\fG)\u001a7fi&|g\u000eF\u0002n\u0003\u001fB\u0001\"a\u0005\u0002J\u0001\u0007\u0011Q\u0003\u0005\b\u0003'\u0002A\u0011BA+\u0003iI7\u000fV8qS\u000e,E.[4jE2,gi\u001c:EK2,G/[8o)\rA\u0014q\u000b\u0005\b\u0003[\t\t\u00061\u0001I\u0011\u001d\tY\u0006\u0001C\u0005\u0003;\n\u0011$\\1sWR{\u0007/[2G_J$U\r\\3uS>t'+\u001a;ssR\u0019Q.a\u0018\t\u000f\u00055\u0012\u0011\fa\u0001\u0011\"9\u00111\r\u0001\u0005\n\u0005\u0015\u0014aE2p[BdW\r^3EK2,G/\u001a+pa&\u001cGcA7\u0002h!9\u0011QFA1\u0001\u0004A\u0005bBA6\u0001\u0011%\u0011QN\u0001\u0010_:$v\u000e]5d\t\u0016dW\r^5p]R\u0019Q.a\u001c\t\u000f\u0005\u0005\u0011\u0011\u000ea\u0001e\"9\u00111\u000f\u0001\u0005\n\u0005U\u0014\u0001F:uCJ$(+\u001a9mS\u000e\fG)\u001a7fi&|g\u000eF\u0002n\u0003oB\u0001\"!\u001f\u0002r\u0001\u0007\u0011QC\u0001\u001de\u0016\u0004H.[2bg\u001a{'\u000fV8qS\u000e\u001cHk\u001c\"f\t\u0016dW\r^3e\u0011\u001d\ti\b\u0001C\u0005\u0003\u007f\n1c\u001c8QCJ$\u0018\u000e^5p]\u0012+G.\u001a;j_:$2!\\AA\u0011\u001d1\u00161\u0010a\u0001\u0003\u0007\u00032a\u001d;Z\u0011\u0019\t9\t\u0001C\u0005s\u0006y!/Z:v[\u0016$U\r\\3uS>t7\u000fC\u0005\u0002\f\u0002\t\n\u0011\"\u0001\u0002\u000e\u0006\t#/Z:v[\u0016$U\r\\3uS>tgi\u001c:U_BL7m\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0012\u0016\u0004e\u0006E5FAAJ!\u0011\t)*a(\u000e\u0005\u0005]%\u0002BAM\u00037\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005u%\"\u0001\u0006b]:|G/\u0019;j_:LA!!)\u0002\u0018\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class TopicDeletionManager
implements Logging {
    private final KafkaController controller;
    private final ControllerEventManager eventManager;
    private final KafkaZkClient zkClient;
    private final ControllerContext controllerContext;
    private final boolean isDeleteTopicEnabled;
    private final scala.collection.mutable.Set<String> topicsToBeDeleted;
    private final scala.collection.mutable.Set<TopicPartition> partitionsToBeDeleted;
    private final scala.collection.mutable.Set<String> topicsIneligibleForDeletion;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TopicDeletionManager topicDeletionManager = this;
        synchronized (topicDeletionManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public boolean isDeleteTopicEnabled() {
        return this.isDeleteTopicEnabled;
    }

    public scala.collection.mutable.Set<String> topicsToBeDeleted() {
        return this.topicsToBeDeleted;
    }

    public scala.collection.mutable.Set<TopicPartition> partitionsToBeDeleted() {
        return this.partitionsToBeDeleted;
    }

    public scala.collection.mutable.Set<String> topicsIneligibleForDeletion() {
        return this.topicsIneligibleForDeletion;
    }

    public void init(Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        if (this.isDeleteTopicEnabled()) {
            this.topicsToBeDeleted().$plus$plus$eq(initialTopicsToBeDeleted);
            this.partitionsToBeDeleted().$plus$plus$eq((TraversableOnce)this.topicsToBeDeleted().flatMap((Function1 & Serializable & scala.Serializable)topic -> this.controllerContext().partitionsForTopic((String)topic), scala.collection.mutable.Set$.MODULE$.canBuildFrom()));
            this.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)initialTopicsIneligibleForDeletion.$amp(this.topicsToBeDeleted()));
        } else {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing ", " since delete topic is disabled"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{initialTopicsToBeDeleted})));
            this.zkClient.deleteTopicDeletions((Seq<String>)initialTopicsToBeDeleted.toSeq());
        }
    }

    public void tryTopicDeletion() {
        block0: {
            if (!this.isDeleteTopicEnabled()) break block0;
            this.resumeDeletions();
        }
    }

    public void reset() {
        block0: {
            if (!this.isDeleteTopicEnabled()) break block0;
            this.topicsToBeDeleted().clear();
            this.partitionsToBeDeleted().clear();
            this.topicsIneligibleForDeletion().clear();
        }
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        block0: {
            if (!this.isDeleteTopicEnabled()) break block0;
            this.topicsToBeDeleted().$plus$plus$eq(topics);
            this.partitionsToBeDeleted().$plus$plus$eq((TraversableOnce)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> this.controllerContext().partitionsForTopic((String)topic), Set$.MODULE$.canBuildFrom()));
            this.resumeDeletions();
        }
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        block0: {
            Set topicsToResumeDeletion;
            if (!this.isDeleteTopicEnabled() || !(topicsToResumeDeletion = (Set)topics.$amp(this.topicsToBeDeleted())).nonEmpty()) break block0;
            this.topicsIneligibleForDeletion().$minus$minus$eq((TraversableOnce)topicsToResumeDeletion);
            this.resumeDeletions();
        }
    }

    public Set<String> resumeDeletionForTopics$default$1() {
        return Set$.MODULE$.empty();
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        block0: {
            Set replicasThatFailedToDelete;
            if (!this.isDeleteTopicEnabled() || !(replicasThatFailedToDelete = (Set)replicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.isTopicQueuedUpForDeletion(r.topic())))).nonEmpty()) break block0;
            Set topics = (Set)replicasThatFailedToDelete.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topic(), Set$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion failed for replicas ", ". Halting deletion for topics ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicasThatFailedToDelete.mkString(","), topics})));
            this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)replicasThatFailedToDelete.toSeq(), ReplicaDeletionIneligible$.MODULE$, this.controller.replicaStateMachine().handleStateChanges$default$3());
            this.markTopicIneligibleForDeletion((Set<String>)topics);
            this.resumeDeletions();
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics) {
        block1: {
            if (!this.isDeleteTopicEnabled()) break block1;
            scala.collection.mutable.Set newTopicsToHaltDeletion = (scala.collection.mutable.Set)this.topicsToBeDeleted().$amp(topics);
            this.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)newTopicsToHaltDeletion);
            if (newTopicsToHaltDeletion.nonEmpty()) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Halted deletion of topics ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newTopicsToHaltDeletion.mkString(",")})));
            }
        }
    }

    private boolean isTopicIneligibleForDeletion(String topic) {
        return this.isDeleteTopicEnabled() ? this.topicsIneligibleForDeletion().contains((Object)topic) : true;
    }

    private boolean isTopicDeletionInProgress(String topic) {
        return this.isDeleteTopicEnabled() ? this.controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic) : false;
    }

    public boolean isPartitionToBeDeleted(TopicPartition topicAndPartition) {
        return this.isDeleteTopicEnabled() ? this.partitionsToBeDeleted().contains((Object)topicAndPartition) : false;
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        return this.isDeleteTopicEnabled() ? this.topicsToBeDeleted().contains((Object)topic) : false;
    }

    public void completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas = (Set)replicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.isTopicQueuedUpForDeletion(r.topic())));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion successfully completed for replicas ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{successfullyDeletedReplicas.mkString(",")})));
        this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)successfullyDeletedReplicas.toSeq(), ReplicaDeletionSuccessful$.MODULE$, this.controller.replicaStateMachine().handleStateChanges$default$3());
        this.resumeDeletions();
    }

    private boolean isTopicEligibleForDeletion(String topic) {
        return this.topicsToBeDeleted().contains((Object)topic) && !this.isTopicDeletionInProgress(topic) && !this.isTopicIneligibleForDeletion(topic);
    }

    private void markTopicForDeletionRetry(String topic) {
        scala.collection.immutable.Set<PartitionAndReplica> failedReplicas = this.controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionIneligible$.MODULE$);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retrying delete topic for topic ", " since replicas ", " were not successfully deleted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, failedReplicas.mkString(",")})));
        this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)failedReplicas.toSeq(), OfflineReplica$.MODULE$, this.controller.replicaStateMachine().handleStateChanges$default$3());
    }

    private void completeDeleteTopic(String topic) {
        this.controller.unregisterPartitionModificationsHandlers((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
        scala.collection.immutable.Set<PartitionAndReplica> replicasForDeletedTopic = this.controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletedTopic.toSeq(), NonExistentReplica$.MODULE$, this.controller.replicaStateMachine().handleStateChanges$default$3());
        Set<TopicPartition> partitionsForDeletedTopic = this.controllerContext().partitionsForTopic(topic);
        this.controller.partitionStateMachine().handleStateChanges((Seq<TopicPartition>)partitionsForDeletedTopic.toSeq(), OfflinePartition$.MODULE$, this.controller.partitionStateMachine().handleStateChanges$default$3());
        this.controller.partitionStateMachine().handleStateChanges((Seq<TopicPartition>)partitionsForDeletedTopic.toSeq(), NonExistentPartition$.MODULE$, this.controller.partitionStateMachine().handleStateChanges$default$3());
        this.topicsToBeDeleted().$minus$eq((Object)topic);
        this.partitionsToBeDeleted().retain((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManager.$anonfun$completeDeleteTopic$1(topic, x$2)));
        this.zkClient.deleteTopicZNode(topic);
        this.zkClient.deleteTopicConfigs((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
        this.zkClient.deleteTopicDeletions((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
        this.controllerContext().removeTopic(topic);
    }

    private void onTopicDeletion(Set<String> topics) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic deletion callback for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topics.mkString(",")})));
        Set partitions = (Set)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> this.controllerContext().partitionsForTopic((String)topic), Set$.MODULE$.canBuildFrom());
        this.controller.sendUpdateMetadataRequest((Seq<Object>)this.controllerContext().liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicPartition>)partitions);
        Map partitionReplicaAssignmentByTopic = this.controllerContext().partitionReplicaAssignment().groupBy((Function1 & Serializable & scala.Serializable)p -> ((TopicPartition)p._1()).topic());
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            this.onPartitionDeletion((Set<TopicPartition>)((MapLike)partitionReplicaAssignmentByTopic.apply((Object)topic)).keySet());
            return BoxedUnit.UNIT;
        });
    }

    private void startReplicaDeletion(Set<PartitionAndReplica> replicasForTopicsToBeDeleted) {
        replicasForTopicsToBeDeleted.groupBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.topic()).keys().foreach((Function1 & Serializable & scala.Serializable)topic -> {
            TopicDeletionManager.$anonfun$startReplicaDeletion$2(this, replicasForTopicsToBeDeleted, topic);
            return BoxedUnit.UNIT;
        });
    }

    private void onPartitionDeletion(Set<TopicPartition> partitionsToBeDeleted) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition deletion callback for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionsToBeDeleted.mkString(",")})));
        Set<PartitionAndReplica> replicasPerPartition = this.controllerContext().replicasForPartition(partitionsToBeDeleted);
        this.startReplicaDeletion(replicasPerPartition);
    }

    private void resumeDeletions() {
        Set topicsQueuedForDeletion = Set$.MODULE$.empty().$plus$plus(this.topicsToBeDeleted());
        if (topicsQueuedForDeletion.nonEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Handling deletion for topics ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicsQueuedForDeletion.mkString(",")})));
        }
        topicsQueuedForDeletion.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            TopicDeletionManager.$anonfun$resumeDeletions$2(this, topic);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$completeDeleteTopic$1(String topic$2, TopicPartition x$2) {
        String string = x$2.topic();
        String string2 = topic$2;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$startReplicaDeletion$3(String topic$3, PartitionAndReplica p) {
        String string = p.topic();
        String string2 = topic$3;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$startReplicaDeletion$2(TopicDeletionManager $this, Set replicasForTopicsToBeDeleted$1, String topic) {
        block0: {
            Set aliveReplicasForTopic = (Set)$this.controllerContext().allLiveReplicas().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManager.$anonfun$startReplicaDeletion$3(topic, p)));
            Set deadReplicasForTopic = (Set)replicasForTopicsToBeDeleted$1.$minus$minus((GenTraversableOnce)aliveReplicasForTopic);
            scala.collection.immutable.Set<PartitionAndReplica> successfullyDeletedReplicas = $this.controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
            Set replicasForDeletionRetry = (Set)aliveReplicasForTopic.$minus$minus(successfullyDeletedReplicas);
            $this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)deadReplicasForTopic.toSeq(), ReplicaDeletionIneligible$.MODULE$, $this.controller.replicaStateMachine().handleStateChanges$default$3());
            $this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletionRetry.toSeq(), OfflineReplica$.MODULE$, $this.controller.replicaStateMachine().handleStateChanges$default$3());
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion started for replicas ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicasForDeletionRetry.mkString(",")})));
            $this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletionRetry.toSeq(), ReplicaDeletionStarted$.MODULE$, new Callbacks((Function2<AbstractResponse, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(stopReplicaResponseObj, replicaId) -> {
                $this.eventManager.put(new KafkaController.TopicDeletionStopReplicaResponseReceived($this.controller, stopReplicaResponseObj, BoxesRunTime.unboxToInt((Object)replicaId)));
                return BoxedUnit.UNIT;
            }));
            if (!deadReplicasForTopic.nonEmpty()) break block0;
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dead Replicas (", ") found for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{deadReplicasForTopic.mkString(","), topic})));
            $this.markTopicIneligibleForDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
        }
    }

    public static final /* synthetic */ void $anonfun$resumeDeletions$2(TopicDeletionManager $this, String topic) {
        block6: {
            block5: {
                if ($this.controller.replicaStateMachine().areAllReplicasForTopicDeleted(topic)) {
                    $this.completeDeleteTopic(topic);
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion of topic ", " successfully completed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                } else if ($this.controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic)) {
                    scala.collection.immutable.Set<PartitionAndReplica> replicasInDeletionStartedState = $this.controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionStarted$.MODULE$);
                    scala.collection.immutable.Set replicaIds = (scala.collection.immutable.Set)replicasInDeletionStartedState.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.replica()), scala.collection.immutable.Set$.MODULE$.canBuildFrom());
                    scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)replicasInDeletionStartedState.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.topicPartition(), scala.collection.immutable.Set$.MODULE$.canBuildFrom());
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion for replicas ", " for partition ", " of topic ", " in progress"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicaIds.mkString(","), partitions.mkString(","), topic})));
                } else if ($this.controller.replicaStateMachine().isAnyReplicaInState(topic, ReplicaDeletionIneligible$.MODULE$)) {
                    $this.markTopicForDeletionRetry(topic);
                }
                if (!$this.isTopicEligibleForDeletion(topic)) break block5;
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion of topic ", " (re)started"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                $this.onTopicDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                break block6;
            }
            if (!$this.isTopicIneligibleForDeletion(topic)) break block6;
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not retrying deletion of topic ", " at this time since it is marked ineligible for deletion"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
    }

    public TopicDeletionManager(KafkaController controller, ControllerEventManager eventManager, KafkaZkClient zkClient) {
        this.controller = controller;
        this.eventManager = eventManager;
        this.zkClient = zkClient;
        Logging.$init$(this);
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Topic Deletion Manager ", "], "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)controller.config().brokerId())})));
        this.controllerContext = controller.controllerContext();
        this.isDeleteTopicEnabled = controller.config().deleteTopicEnable();
        this.topicsToBeDeleted = scala.collection.mutable.Set$.MODULE$.empty();
        this.partitionsToBeDeleted = scala.collection.mutable.Set$.MODULE$.empty();
        this.topicsIneligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty();
    }
}

