/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.conf;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogPrivacyUtil {
    private static final Logger logger = LoggerFactory.getLogger(LogPrivacyUtil.class);
    public static final String LOG_RAWDATA_PROP = "org.apache.flume.log.rawdata";
    public static final String LOG_PRINTCONFIG_PROP = "org.apache.flume.log.printconfig";

    public static boolean allowLogRawData() {
        return Boolean.getBoolean(LOG_RAWDATA_PROP);
    }

    public static boolean allowLogPrintConfig() {
        return Boolean.getBoolean(LOG_PRINTCONFIG_PROP);
    }

    static {
        if (LogPrivacyUtil.allowLogPrintConfig()) {
            logger.warn("Logging of configuration details of the agent has been turned on by setting {} to true. Please use this setting with extra caution as it may result in logging of private data. This setting is not recommended in production environments.", (Object)LOG_PRINTCONFIG_PROP);
        } else {
            logger.info("Logging of configuration details is disabled. To see configuration details in the log run the agent with -D{}=true JVM argument. Please note that this is not recommended in production systems as it may leak private information to the logfile.", (Object)LOG_PRINTCONFIG_PROP);
        }
        if (LogPrivacyUtil.allowLogRawData()) {
            logger.warn("Logging raw data has been turned on by setting {} to true. Please use it with extra caution as it may result in logging of potentially sensitive user data. This setting is not recommended in production environments.", (Object)LOG_RAWDATA_PROP);
        }
    }
}

