/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.web.security;

import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.security.ClusterServerTicketGeneration;
import com.mapr.web.security.DummyUserDetailsService;
import com.mapr.web.security.MapRTicketToken;
import com.mapr.web.security.MapRUser;
import com.mapr.web.security.TokenAuthException;
import com.mapr.web.security.TokenUtil;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.kerberos.authentication.KerberosServiceRequestToken;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.session.NullAuthenticatedSessionStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

public class MultiAuthProcessingFilter
extends GenericFilterBean {
    private static final Logger log = LoggerFactory.getLogger(MultiAuthProcessingFilter.class);
    private static final String IMPERSONATED_USER_HEADER = "X-MAPR-IMPERSONATED-USER";
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private AuthenticationManager authenticationManager;
    private AuthenticationFailureHandler failureHandler;
    private AuthenticationSuccessHandler successHandler;
    private SessionAuthenticationStrategy sessionStrategy = new NullAuthenticatedSessionStrategy();
    private boolean skipIfAlreadyAuthenticated = true;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) {
        Authentication header;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (this.skipIfAlreadyAuthenticated && (header = SecurityContextHolder.getContext().getAuthentication()) != null && !(header instanceof AnonymousAuthenticationToken) && header.isAuthenticated()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String header1 = request.getHeader("Authorization");
        String clusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        if (header1 == null || !header1.startsWith("Basic ") && !header1.startsWith("Bearer ")) {
            String headerValue = "Basic realm=" + clusterName + "\"";
            String errorMessage = "Basic or Bearer authorization headers must be passed";
            response.setHeader("WWW-Authenticate", headerValue);
            response.setHeader("WWW-MAPR-Err-Authenticate", errorMessage);
            response.setStatus(401);
            log.warn(errorMessage);
            return;
        }
        if (header1 != null && (header1.startsWith("Negotiate ") || header1.startsWith("Kerberos "))) {
            Authentication authentication;
            if (log.isDebugEnabled()) {
                log.debug("Received Negotiate Header for request " + request.getRequestURL() + ": " + header1);
            }
            byte[] base64Token = header1.substring(header1.indexOf(32) + 1).getBytes("UTF-8");
            byte[] kerberosTicket = Base64.decode((byte[])base64Token);
            KerberosServiceRequestToken authRequest = new KerberosServiceRequestToken(kerberosTicket);
            authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
            try {
                authentication = this.authenticationManager.authenticate((Authentication)authRequest);
            }
            catch (AuthenticationException ex) {
                log.warn("Negotiate Header was invalid: " + header1, (Throwable)ex);
                SecurityContextHolder.clearContext();
                if (this.failureHandler != null) {
                    this.failureHandler.onAuthenticationFailure(request, response, ex);
                } else {
                    response.setStatus(500);
                    response.flushBuffer();
                }
                return;
            }
            this.sessionStrategy.onAuthentication(authentication, request, response);
            SecurityContextHolder.getContext().setAuthentication(authentication);
            if (this.successHandler != null) {
                this.successHandler.onAuthenticationSuccess(request, response, authentication);
            }
        } else if (header1 != null && header1.startsWith("MAPR-Negotiate")) {
            Authentication authentication;
            if (log.isDebugEnabled()) {
                log.debug("Received MAPR-Negotiate Header for request " + request.getRequestURL() + ": " + header1);
            }
            ClusterServerTicketGeneration.getInstance().generateTicketAndSetServerKey();
            String token = header1.substring("MAPR-Negotiate".length()).trim();
            boolean impersonateUser = StringUtils.isNotBlank((CharSequence)request.getHeader(IMPERSONATED_USER_HEADER));
            MapRTicketToken ticketToken = new MapRTicketToken(token.getBytes(), impersonateUser);
            ticketToken.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
            try {
                authentication = this.authenticationManager.authenticate((Authentication)ticketToken);
                MapRTicketToken mapRTicketToken = (MapRTicketToken)authentication;
                response.setHeader("Authorization", "MAPR-Negotiate " + mapRTicketToken.getRespEncrypted());
            }
            catch (AuthenticationException ex) {
                response.setHeader("WWW-MAPR-Err-Authenticate", ex.getMessage());
                response.setStatus(401);
                log.warn("MAPR-Negotiate Header was invalid: " + header1, (Throwable)ex);
                SecurityContextHolder.clearContext();
                if (this.failureHandler != null) {
                    this.failureHandler.onAuthenticationFailure(request, response, ex);
                } else {
                    response.setStatus(500);
                    response.flushBuffer();
                }
                return;
            }
            this.sessionStrategy.onAuthentication(authentication, request, response);
            SecurityContextHolder.getContext().setAuthentication(authentication);
            if (this.successHandler != null) {
                this.successHandler.onAuthenticationSuccess(request, response, authentication);
            }
        } else if (header1 != null && header1.startsWith("Bearer ")) {
            String authToken = header1.substring(7);
            String username = null;
            TokenUtil tokenUtil = new TokenUtil();
            try {
                DummyUserDetailsService userDetailsService;
                MapRUser user;
                username = tokenUtil.getUsernameFromToken(authToken);
                log.debug("checking authentication for user " + username);
                if (username != null && SecurityContextHolder.getContext().getAuthentication() == null && tokenUtil.validateToken(authToken, user = (MapRUser)(userDetailsService = new DummyUserDetailsService()).loadUserByUsername(username)).booleanValue()) {
                    UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)user, null, user.getAuthorities());
                    authentication.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
                    log.debug("authenticated user " + username + ", setting security context");
                    SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
                }
            }
            catch (ExpiredJwtException | MalformedJwtException | SignatureException | IllegalArgumentException ex) {
                if (ex instanceof IllegalArgumentException) {
                    log.error("an error occured during getting username from token", ex);
                } else if (ex instanceof ExpiredJwtException) {
                    log.warn("the token is expired and not valid anymore", ex);
                } else if (ex instanceof MalformedJwtException) {
                    log.warn("the token is malformed", ex);
                } else if (ex instanceof SignatureException) {
                    log.warn("signature exeception", ex);
                }
                String headerValue = "Basic realm=" + clusterName + "\"";
                response.setHeader("WWW-Authenticate", headerValue);
                response.setHeader("WWW-MAPR-Err-Authenticate", ex.getMessage());
                response.setStatus(401);
                log.warn("Bearer Header was invalid: " + header1, ex);
                SecurityContextHolder.clearContext();
                if (this.failureHandler != null) {
                    this.failureHandler.onAuthenticationFailure(request, response, (AuthenticationException)new TokenAuthException("Bearer Header was invalid", ex));
                } else {
                    response.setStatus(401);
                    response.flushBuffer();
                }
                return;
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void afterPropertiesSet() throws ServletException {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.authenticationManager, (String)"authenticationManager required");
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, ?> detailsSource) {
        Assert.notNull(detailsSource, (String)"authenticationDetailsSource required");
        this.authenticationDetailsSource = detailsSource;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public AuthenticationFailureHandler getFailureHandler() {
        return this.failureHandler;
    }

    public void setFailureHandler(AuthenticationFailureHandler failureHandler) {
        this.failureHandler = failureHandler;
    }

    public AuthenticationSuccessHandler getSuccessHandler() {
        return this.successHandler;
    }

    public void setSuccessHandler(AuthenticationSuccessHandler successHandler) {
        this.successHandler = successHandler;
    }

    public boolean isSkipIfAlreadyAuthenticated() {
        return this.skipIfAlreadyAuthenticated;
    }

    public void setSkipIfAlreadyAuthenticated(boolean skipIfAlreadyAuthenticated) {
        this.skipIfAlreadyAuthenticated = skipIfAlreadyAuthenticated;
    }
}

