/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDrivenSource;
import org.apache.flume.SystemClock;
import org.apache.flume.channel.ChannelProcessor;
import org.apache.flume.conf.Configurable;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.instrumentation.SourceCounter;
import org.apache.flume.source.AbstractSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecSource
extends AbstractSource
implements EventDrivenSource,
Configurable {
    private static final Logger logger = LoggerFactory.getLogger(ExecSource.class);
    private String shell;
    private String command;
    private SourceCounter sourceCounter;
    private ExecutorService executor;
    private Future<?> runnerFuture;
    private long restartThrottle;
    private boolean restart;
    private boolean logStderr;
    private Integer bufferCount;
    private long batchTimeout;
    private ExecRunnable runner;
    private Charset charset;

    @Override
    public void start() {
        logger.info("Exec source starting with command: {}", (Object)this.command);
        this.sourceCounter.start();
        this.executor = Executors.newSingleThreadExecutor();
        this.runner = new ExecRunnable(this.shell, this.command, this.getChannelProcessor(), this.sourceCounter, this.restart, this.restartThrottle, this.logStderr, this.bufferCount, this.batchTimeout, this.charset);
        this.runnerFuture = this.executor.submit(this.runner);
        super.start();
        logger.debug("Exec source started");
    }

    @Override
    public void stop() {
        logger.info("Stopping exec source with command: {}", (Object)this.command);
        if (this.runner != null) {
            this.runner.setRestart(false);
            this.runner.kill();
        }
        if (this.runnerFuture != null) {
            logger.debug("Stopping exec runner");
            this.runnerFuture.cancel(true);
            logger.debug("Exec runner stopped");
        }
        this.executor.shutdown();
        while (!this.executor.isTerminated()) {
            logger.debug("Waiting for exec executor service to stop");
            try {
                this.executor.awaitTermination(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.debug("Interrupted while waiting for exec executor service to stop. Just exiting.");
                Thread.currentThread().interrupt();
            }
        }
        this.sourceCounter.stop();
        super.stop();
        logger.debug("Exec source with command:{} stopped. Metrics:{}", (Object)this.command, (Object)this.sourceCounter);
    }

    @Override
    public void configure(Context context) {
        this.command = context.getString("command");
        Preconditions.checkState((this.command != null ? 1 : 0) != 0, (Object)"The parameter command must be specified");
        this.restartThrottle = context.getLong("restartThrottle", Long.valueOf(10000L));
        this.restart = context.getBoolean("restart", Boolean.valueOf(false));
        this.logStderr = context.getBoolean("logStdErr", Boolean.valueOf(false));
        this.bufferCount = context.getInteger("batchSize", Integer.valueOf(20));
        this.batchTimeout = context.getLong("batchTimeout", Long.valueOf(3000L));
        this.charset = Charset.forName(context.getString("charset", "UTF-8"));
        this.shell = context.getString("shell", null);
        if (this.sourceCounter == null) {
            this.sourceCounter = new SourceCounter(this.getName());
        }
    }

    private static class StderrReader
    extends Thread {
        private BufferedReader input;
        private boolean logStderr;

        protected StderrReader(BufferedReader input, boolean logStderr) {
            this.input = input;
            this.logStderr = logStderr;
        }

        @Override
        public void run() {
            try {
                int i = 0;
                String line = null;
                while ((line = this.input.readLine()) != null) {
                    if (!this.logStderr) continue;
                    logger.info("StderrLogger[{}] = '{}'", (Object)(++i), (Object)line);
                }
            }
            catch (IOException e) {
                logger.info("StderrLogger exiting", (Throwable)e);
            }
            finally {
                try {
                    if (this.input != null) {
                        this.input.close();
                    }
                }
                catch (IOException ex) {
                    logger.error("Failed to close stderr reader for exec source", (Throwable)ex);
                }
            }
        }
    }

    private static class ExecRunnable
    implements Runnable {
        private final String shell;
        private final String command;
        private final ChannelProcessor channelProcessor;
        private final SourceCounter sourceCounter;
        private volatile boolean restart;
        private final long restartThrottle;
        private final int bufferCount;
        private long batchTimeout;
        private final boolean logStderr;
        private final Charset charset;
        private Process process = null;
        private SystemClock systemClock = new SystemClock();
        private Long lastPushToChannel = this.systemClock.currentTimeMillis();
        ScheduledExecutorService timedFlushService;
        ScheduledFuture<?> future;

        public ExecRunnable(String shell, String command, ChannelProcessor channelProcessor, SourceCounter sourceCounter, boolean restart, long restartThrottle, boolean logStderr, int bufferCount, long batchTimeout, Charset charset) {
            this.command = command;
            this.channelProcessor = channelProcessor;
            this.sourceCounter = sourceCounter;
            this.restartThrottle = restartThrottle;
            this.bufferCount = bufferCount;
            this.batchTimeout = batchTimeout;
            this.restart = restart;
            this.logStderr = logStderr;
            this.charset = charset;
            this.shell = shell;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            do {
                String exitCode = "unknown";
                BufferedReader reader = null;
                String line = null;
                final ArrayList<Event> eventList = new ArrayList<Event>();
                this.timedFlushService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("timedFlushExecService" + Thread.currentThread().getId() + "-%d").build());
                try {
                    ArrayList<Event> arrayList;
                    String[] commandArgs;
                    if (this.shell != null) {
                        commandArgs = ExecRunnable.formulateShellCommand(this.shell, this.command);
                        this.process = Runtime.getRuntime().exec(commandArgs);
                    } else {
                        commandArgs = this.command.split("\\s+");
                        this.process = new ProcessBuilder(commandArgs).start();
                    }
                    reader = new BufferedReader(new InputStreamReader(this.process.getInputStream(), this.charset));
                    StderrReader stderrReader = new StderrReader(new BufferedReader(new InputStreamReader(this.process.getErrorStream(), this.charset)), this.logStderr);
                    stderrReader.setName("StderrReader-[" + this.command + "]");
                    stderrReader.setDaemon(true);
                    stderrReader.start();
                    this.future = this.timedFlushService.scheduleWithFixedDelay(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            block6: {
                                try {
                                    List list = eventList;
                                    synchronized (list) {
                                        if (!eventList.isEmpty() && this.timeout()) {
                                            this.flushEventBatch(eventList);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    logger.error("Exception occurred when processing event batch", (Throwable)e);
                                    if (!(e instanceof InterruptedException)) break block6;
                                    Thread.currentThread().interrupt();
                                }
                            }
                        }
                    }, this.batchTimeout, this.batchTimeout, TimeUnit.MILLISECONDS);
                    while ((line = reader.readLine()) != null) {
                        this.sourceCounter.incrementEventReceivedCount();
                        arrayList = eventList;
                        synchronized (arrayList) {
                            eventList.add(EventBuilder.withBody((byte[])line.getBytes(this.charset)));
                            if (eventList.size() >= this.bufferCount || this.timeout()) {
                                this.flushEventBatch(eventList);
                            }
                        }
                    }
                    arrayList = eventList;
                    synchronized (arrayList) {
                        if (!eventList.isEmpty()) {
                            this.flushEventBatch(eventList);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Failed while running command: " + this.command, (Throwable)e);
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ex) {
                            logger.error("Failed to close reader for exec source", (Throwable)ex);
                        }
                    }
                    exitCode = String.valueOf(this.kill());
                }
                if (this.restart) {
                    logger.info("Restarting in {}ms, exit code {}", (Object)this.restartThrottle, (Object)exitCode);
                    try {
                        Thread.sleep(this.restartThrottle);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                logger.info("Command [" + this.command + "] exited with " + exitCode);
            } while (this.restart);
        }

        private void flushEventBatch(List<Event> eventList) {
            this.channelProcessor.processEventBatch(eventList);
            this.sourceCounter.addToEventAcceptedCount(eventList.size());
            eventList.clear();
            this.lastPushToChannel = this.systemClock.currentTimeMillis();
        }

        private boolean timeout() {
            return this.systemClock.currentTimeMillis() - this.lastPushToChannel >= this.batchTimeout;
        }

        private static String[] formulateShellCommand(String shell, String command) {
            String[] shellArgs = shell.split("\\s+");
            String[] result = new String[shellArgs.length + 1];
            System.arraycopy(shellArgs, 0, result, 0, shellArgs.length);
            result[shellArgs.length] = command;
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int kill() {
            if (this.process != null) {
                Process process = this.process;
                synchronized (process) {
                    this.process.destroy();
                    try {
                        int exitValue = this.process.waitFor();
                        if (this.future != null) {
                            this.future.cancel(true);
                        }
                        if (this.timedFlushService != null) {
                            this.timedFlushService.shutdown();
                            while (!this.timedFlushService.isTerminated()) {
                                try {
                                    this.timedFlushService.awaitTermination(500L, TimeUnit.MILLISECONDS);
                                }
                                catch (InterruptedException e) {
                                    logger.debug("Interrupted while waiting for exec executor service to stop. Just exiting.");
                                    Thread.currentThread().interrupt();
                                }
                            }
                        }
                        return exitValue;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
                return Integer.MIN_VALUE;
            }
            return -1073741824;
        }

        public void setRestart(boolean restart) {
            this.restart = restart;
        }
    }
}

