/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flume.Channel;
import org.apache.flume.ChannelSelector;
import org.apache.flume.FlumeException;

public abstract class AbstractChannelSelector
implements ChannelSelector {
    private List<Channel> channels;
    private String name;

    @Override
    public List<Channel> getAllChannels() {
        return this.channels;
    }

    @Override
    public void setChannels(List<Channel> channels) {
        this.channels = channels;
    }

    @Override
    public synchronized void setName(String name) {
        this.name = name;
    }

    @Override
    public synchronized String getName() {
        return this.name;
    }

    protected Map<String, Channel> getChannelNameMap() {
        HashMap<String, Channel> channelNameMap = new HashMap<String, Channel>();
        for (Channel ch : this.getAllChannels()) {
            channelNameMap.put(ch.getName(), ch);
        }
        return channelNameMap;
    }

    protected List<Channel> getChannelListFromNames(String channels, Map<String, Channel> channelNameMap) {
        String[] chNames;
        ArrayList<Channel> configuredChannels = new ArrayList<Channel>();
        if (channels == null || channels.isEmpty()) {
            return configuredChannels;
        }
        for (String name : chNames = channels.split(" ")) {
            Channel ch = channelNameMap.get(name);
            if (ch == null) {
                throw new FlumeException("Selector channel not found: " + name);
            }
            configuredChannels.add(ch);
        }
        return configuredChannels;
    }
}

