/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.elasticsearch;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.flume.Event;
import org.apache.flume.event.SimpleEvent;
import org.joda.time.DateTimeUtils;

final class TimestampedEvent
extends SimpleEvent {
    private final long timestamp;

    TimestampedEvent(Event base) {
        this.setBody(base.getBody());
        HashMap headers = Maps.newHashMap((Map)base.getHeaders());
        String timestampString = (String)headers.get("timestamp");
        if (StringUtils.isBlank((String)timestampString)) {
            timestampString = (String)headers.get("@timestamp");
        }
        if (StringUtils.isBlank((String)timestampString)) {
            this.timestamp = DateTimeUtils.currentTimeMillis();
            headers.put("timestamp", String.valueOf(this.timestamp));
        } else {
            this.timestamp = Long.valueOf(timestampString);
        }
        this.setHeaders(headers);
    }

    long getTimestamp() {
        return this.timestamp;
    }
}

