/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.elasticsearch;

import java.io.IOException;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.sink.elasticsearch.AbstractElasticSearchIndexRequestBuilderFactory;
import org.apache.flume.sink.elasticsearch.ElasticSearchEventSerializer;
import org.apache.flume.sink.elasticsearch.ElasticSearchIndexRequestBuilderFactory;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.common.io.BytesStream;

public class EventSerializerIndexRequestBuilderFactory
extends AbstractElasticSearchIndexRequestBuilderFactory {
    protected final ElasticSearchEventSerializer serializer;

    public EventSerializerIndexRequestBuilderFactory(ElasticSearchEventSerializer serializer) {
        this(serializer, ElasticSearchIndexRequestBuilderFactory.df);
    }

    protected EventSerializerIndexRequestBuilderFactory(ElasticSearchEventSerializer serializer, FastDateFormat fdf) {
        super(fdf);
        this.serializer = serializer;
    }

    @Override
    public void configure(Context context) {
        this.serializer.configure(context);
    }

    @Override
    public void configure(ComponentConfiguration config) {
        this.serializer.configure(config);
    }

    @Override
    protected void prepareIndexRequest(IndexRequestBuilder indexRequest, String indexName, String indexType, Event event) throws IOException {
        BytesStream contentBuilder = this.serializer.getContentBuilder(event);
        ((IndexRequestBuilder)indexRequest.setIndex(indexName)).setType(indexType).setSource(contentBuilder.bytes());
    }
}

