/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.elasticsearch;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.formatter.output.BucketPath;
import org.apache.flume.sink.elasticsearch.ElasticSearchIndexRequestBuilderFactory;
import org.apache.flume.sink.elasticsearch.TimestampedEvent;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.Client;

public abstract class AbstractElasticSearchIndexRequestBuilderFactory
implements ElasticSearchIndexRequestBuilderFactory {
    protected final FastDateFormat fastDateFormat;

    protected AbstractElasticSearchIndexRequestBuilderFactory(FastDateFormat fastDateFormat) {
        this.fastDateFormat = fastDateFormat;
    }

    public abstract void configure(Context var1);

    public abstract void configure(ComponentConfiguration var1);

    @Override
    public IndexRequestBuilder createIndexRequest(Client client, String indexPrefix, String indexType, Event event) throws IOException {
        IndexRequestBuilder request = this.prepareIndex(client);
        String realIndexPrefix = BucketPath.escapeString((String)indexPrefix, (Map)event.getHeaders());
        String realIndexType = BucketPath.escapeString((String)indexType, (Map)event.getHeaders());
        TimestampedEvent timestampedEvent = new TimestampedEvent(event);
        long timestamp = timestampedEvent.getTimestamp();
        String indexName = this.getIndexName(realIndexPrefix, timestamp);
        this.prepareIndexRequest(request, indexName, realIndexType, (Event)timestampedEvent);
        return request;
    }

    @VisibleForTesting
    IndexRequestBuilder prepareIndex(Client client) {
        return client.prepareIndex();
    }

    protected String getIndexName(String indexPrefix, long timestamp) {
        return indexPrefix + '-' + this.fastDateFormat.format(timestamp);
    }

    protected abstract void prepareIndexRequest(IndexRequestBuilder var1, String var2, String var3, Event var4) throws IOException;
}

