/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.partition;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.base.Predicate;

@SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="Implement if we intend to use in Serializable objects  (e.g., TreeMaps) and use java serialization.")
@Immutable
public class ProvidedFieldPartitioner<T extends Comparable>
extends FieldPartitioner<T, T> {
    private static final String INT_TYPE = "int";
    private static final String LONG_TYPE = "long";
    private static final String STRING_TYPE = "string";

    public ProvidedFieldPartitioner(String name, Class<T> typeClass) {
        super(null, name, typeClass, typeClass, -1);
    }

    @Override
    public T apply(T value) {
        return value;
    }

    @Override
    public Predicate<T> project(Predicate<T> predicate) {
        return null;
    }

    @Override
    public Predicate<T> projectStrict(Predicate<T> predicate) {
        return null;
    }

    @Override
    @SuppressWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="Default annotation is not correct for equals")
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        ProvidedFieldPartitioner that = (ProvidedFieldPartitioner)o;
        return Objects.equal(this.getName(), that.getName()) && Objects.equal(this.getType(), that.getType());
    }

    public String getTypeAsString() {
        return ProvidedFieldPartitioner.valuesString(this.getType());
    }

    @Override
    public int compare(T o1, T o2) {
        return o1.compareTo(o2);
    }

    public int hashCode() {
        return Objects.hashCode(this.getName());
    }

    public String toString() {
        return Objects.toStringHelper(this).add("name", this.getName()).add("values", this.getTypeAsString()).toString();
    }

    public static Class<? extends Comparable> valuesType(@Nullable String type) {
        if (type == null) {
            return String.class;
        }
        if (STRING_TYPE.equals(type)) {
            return String.class;
        }
        if (INT_TYPE.equals(type)) {
            return Integer.class;
        }
        if (LONG_TYPE.equals(type)) {
            return Long.class;
        }
        throw new ValidationException("Not a valid provided type: " + type);
    }

    private static String valuesString(Class<? extends Comparable> type) {
        if (String.class.isAssignableFrom(type)) {
            return STRING_TYPE;
        }
        if (Integer.class.isAssignableFrom(type)) {
            return INT_TYPE;
        }
        if (Long.class.isAssignableFrom(type)) {
            return LONG_TYPE;
        }
        throw new ValidationException("Not a valid provided type: " + type);
    }
}

