/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.io.IOException;
import javax.annotation.concurrent.Immutable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.spi.TemporaryDatasetRepository;
import org.kitesdk.data.spi.filesystem.FileSystemDatasetRepository;
import org.kitesdk.data.spi.filesystem.FileSystemUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class TemporaryFileSystemDatasetRepository
extends FileSystemDatasetRepository
implements TemporaryDatasetRepository {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemDatasetRepository.class);
    private static final String TEMP_PATH = ".temp";
    private final FileSystem fs;
    private final Path root;
    private final Path storage;

    public TemporaryFileSystemDatasetRepository(Configuration conf, Path root, String namespace, String key) {
        super(conf, TemporaryFileSystemDatasetRepository.temporaryRoot(root, namespace, key));
        try {
            this.fs = root.getFileSystem(conf);
            this.root = this.fs.makeQualified(root);
            this.storage = this.fs.makeQualified(TemporaryFileSystemDatasetRepository.temporaryRoot(root, namespace, key));
        }
        catch (IOException e) {
            throw new DatasetIOException("Cannot setup temporary repository: " + key, e);
        }
        LOG.debug("Created temporary dataset repository with root {} and storage {}.", (Object)root, (Object)this.storage);
    }

    private static Path temporaryRoot(Path root, String namespace, String key) {
        return new Path(root, new Path(namespace, new Path(TEMP_PATH, key)));
    }

    @Override
    public void delete() {
        FileSystemUtil.cleanlyDelete(this.fs, this.root, this.storage);
        LOG.debug("Deleted temporary dataset repository with storage {}.", (Object)this.storage);
    }
}

