/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.spi.AbstractDatasetReader;
import org.kitesdk.data.spi.DataModelUtil;
import org.kitesdk.data.spi.EntityAccessor;
import org.kitesdk.data.spi.JsonUtil;
import org.kitesdk.data.spi.ReaderWriterState;
import org.kitesdk.shaded.com.google.common.base.Function;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.com.google.common.collect.Iterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONFileReader<E>
extends AbstractDatasetReader<E> {
    private static final Logger LOG = LoggerFactory.getLogger(JSONFileReader.class);
    private final FileSystem fs;
    private final Path path;
    private final GenericData model;
    private final Schema schema;
    private long size = 0L;
    private InputStream incoming = null;
    private ReaderWriterState state = ReaderWriterState.NEW;
    private Iterator<E> iterator;

    public JSONFileReader(FileSystem fileSystem, Path path, EntityAccessor<E> accessor) {
        this.fs = fileSystem;
        this.path = path;
        this.schema = accessor.getEntitySchema();
        this.model = DataModelUtil.getDataModelForType(accessor.getType());
        this.state = ReaderWriterState.NEW;
    }

    public JSONFileReader(InputStream incoming, Schema schema, Class<E> type) {
        this.fs = null;
        this.path = null;
        this.incoming = incoming;
        this.schema = schema;
        this.model = DataModelUtil.getDataModelForType(type);
        this.state = ReaderWriterState.NEW;
    }

    @Override
    public void initialize() {
        Preconditions.checkState(this.state.equals((Object)ReaderWriterState.NEW), "A reader may not be opened more than once - current state:%s", new Object[]{this.state});
        Preconditions.checkArgument(Schema.Type.RECORD.equals((Object)this.schema.getType()), "Schemas for JSON files should be record");
        if (this.incoming == null) {
            Preconditions.checkNotNull(this.fs, "FileSystem cannot be null");
            Preconditions.checkNotNull(this.path, "Path cannot be null");
            try {
                this.incoming = this.fs.open(this.path);
                this.size = this.fs.getFileStatus(this.path).getLen();
            }
            catch (IOException ex) {
                throw new DatasetIOException("Cannot open path: " + this.path, ex);
            }
        }
        this.iterator = Iterators.transform(JsonUtil.parser(this.incoming), new Function<JsonNode, E>(){

            @Override
            public E apply(@Nullable JsonNode node) {
                return JsonUtil.convertToAvro(JSONFileReader.this.model, node, JSONFileReader.this.schema);
            }
        });
        this.state = ReaderWriterState.OPEN;
    }

    @Override
    public boolean hasNext() {
        Preconditions.checkState(this.state.equals((Object)ReaderWriterState.OPEN), "Attempt to read from a file in state:%s", new Object[]{this.state});
        return this.iterator.hasNext();
    }

    @Override
    public E next() {
        Preconditions.checkState(this.state.equals((Object)ReaderWriterState.OPEN), "Attempt to read from a file in state:%s", new Object[]{this.state});
        return this.iterator.next();
    }

    @Override
    public void close() {
        if (!this.state.equals((Object)ReaderWriterState.OPEN)) {
            return;
        }
        LOG.debug("Closing reader on path:{}", (Object)this.path);
        this.iterator = null;
        try {
            this.incoming.close();
        }
        catch (IOException e) {
            throw new DatasetIOException("Unable to close reader path:" + this.path, e);
        }
        this.state = ReaderWriterState.CLOSED;
    }

    @Override
    public boolean isOpen() {
        return this.state == ReaderWriterState.OPEN;
    }

    public RecordReader<E, Void> asRecordReader() {
        Preconditions.checkArgument(this.incoming instanceof FSDataInputStream, "Cannot use {} in a record reader", this.incoming.getClass());
        return new JSONRecordReader();
    }

    public class JSONRecordReader
    extends RecordReader<E, Void> {
        private E current;

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            if (JSONFileReader.this.hasNext()) {
                this.current = JSONFileReader.this.next();
                return true;
            }
            return false;
        }

        public E getCurrentKey() throws IOException, InterruptedException {
            return this.current;
        }

        public Void getCurrentValue() throws IOException, InterruptedException {
            return null;
        }

        public float getProgress() throws IOException, InterruptedException {
            if (JSONFileReader.this.size == 0L) {
                return 0.0f;
            }
            return (float)((FSDataInputStream)JSONFileReader.this.incoming).getPos() / (float)JSONFileReader.this.size;
        }

        public void close() throws IOException {
            JSONFileReader.this.close();
        }
    }
}

