/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.spi.AbstractDatasetWriter;
import org.kitesdk.data.spi.AbstractRefinableView;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.InputFormatAccessor;
import org.kitesdk.data.spi.LastModifiedAccessor;
import org.kitesdk.data.spi.Pair;
import org.kitesdk.data.spi.PartitionListener;
import org.kitesdk.data.spi.SizeAccessor;
import org.kitesdk.data.spi.StorageKey;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;
import org.kitesdk.data.spi.filesystem.FileSystemPartitionIterator;
import org.kitesdk.data.spi.filesystem.FileSystemUtil;
import org.kitesdk.data.spi.filesystem.FileSystemViewKeyInputFormat;
import org.kitesdk.data.spi.filesystem.FileSystemWriter;
import org.kitesdk.data.spi.filesystem.MultiFileDatasetReader;
import org.kitesdk.data.spi.filesystem.PartitionedDatasetWriter;
import org.kitesdk.data.spi.filesystem.PathIterator;
import org.kitesdk.shaded.com.google.common.base.Function;
import org.kitesdk.shaded.com.google.common.collect.Iterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
class FileSystemView<E>
extends AbstractRefinableView<E>
implements InputFormatAccessor<E>,
LastModifiedAccessor,
SizeAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemView.class);
    private final FileSystem fs;
    private final Path root;
    private final PartitionListener listener;

    FileSystemView(FileSystemDataset<E> dataset, @Nullable PartitionListener listener, Class<E> type) {
        super(dataset, type);
        this.fs = dataset.getFileSystem();
        this.root = dataset.getDirectory();
        this.listener = listener;
    }

    private FileSystemView(FileSystemView<E> view, Constraints c) {
        super(view, c);
        this.fs = view.fs;
        this.root = view.root;
        this.listener = view.listener;
    }

    @Override
    protected FileSystemView<E> filter(Constraints c) {
        return new FileSystemView<E>(this, c);
    }

    @Override
    public DatasetReader<E> newReader() {
        MultiFileDatasetReader reader = new MultiFileDatasetReader(this.fs, this.pathIterator(), this.dataset.getDescriptor(), this.constraints, this.getAccessor());
        reader.initialize();
        return reader;
    }

    @Override
    public DatasetWriter<E> newWriter() {
        AbstractDatasetWriter writer = this.dataset.getDescriptor().isPartitioned() ? PartitionedDatasetWriter.newWriter(this) : FileSystemWriter.newWriter(this.fs, this.root, this.dataset.getDescriptor());
        writer.initialize();
        return writer;
    }

    @Override
    public boolean deleteAll() {
        if (!this.constraints.alignedWithBoundaries()) {
            throw new UnsupportedOperationException("Cannot cleanly delete view: " + this);
        }
        return this.deleteAllUnsafe();
    }

    @Override
    public InputFormat<E, Void> getInputFormat(Configuration conf) {
        return new FileSystemViewKeyInputFormat(this, conf);
    }

    PathIterator pathIterator() {
        Iterator<Pair<StorageKey, Path>> directories = this.dataset.getDescriptor().isPartitioned() ? this.partitionIterator() : Iterators.singletonIterator(Pair.of(null, this.root));
        return new PathIterator(this.fs, this.root, directories);
    }

    Iterator<Path> dirIterator() {
        if (this.dataset.getDescriptor().isPartitioned()) {
            return Iterators.transform(this.partitionIterator(), new Function<Pair<StorageKey, Path>, Path>(){

                @Override
                @SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="False positive, initialized above as non-null.")
                public Path apply(@Nullable Pair<StorageKey, Path> input) {
                    return new Path(FileSystemView.this.root, input.second());
                }
            });
        }
        return Iterators.singletonIterator(this.root);
    }

    private FileSystemPartitionIterator partitionIterator() {
        DatasetDescriptor descriptor = this.dataset.getDescriptor();
        try {
            return new FileSystemPartitionIterator(this.fs, this.root, descriptor.getPartitionStrategy(), descriptor.getSchema(), this.constraints);
        }
        catch (IOException ex) {
            throw new DatasetException("Cannot list partitions in view:" + this, ex);
        }
    }

    boolean deleteAllUnsafe() {
        boolean deleted = false;
        if (this.dataset.getDescriptor().isPartitioned()) {
            for (Pair<StorageKey, Path> partition : this.partitionIterator()) {
                boolean bl = deleted = FileSystemUtil.cleanlyDelete(this.fs, this.root, partition.second()) || deleted;
                if (this.listener == null) continue;
                this.listener.partitionDeleted(this.dataset.getNamespace(), this.dataset.getName(), partition.second().toString());
            }
        } else {
            for (Path path : this.pathIterator()) {
                deleted = FileSystemUtil.cleanlyDelete(this.fs, this.root, path) || deleted;
            }
        }
        return deleted;
    }

    @Override
    public long getSize() {
        long size = 0L;
        Iterator<Path> i = this.dirIterator();
        while (i.hasNext()) {
            Path dir = i.next();
            try {
                for (FileStatus st : this.fs.listStatus(dir)) {
                    size += st.getLen();
                }
            }
            catch (IOException e) {
                throw new DatasetIOException("Cannot find size of " + dir, e);
            }
        }
        return size;
    }

    @Override
    public long getLastModified() {
        long lastMod = -1L;
        Iterator<Path> i = this.dirIterator();
        while (i.hasNext()) {
            Path dir = i.next();
            try {
                for (FileStatus st : this.fs.listStatus(dir)) {
                    if (lastMod >= st.getModificationTime()) continue;
                    lastMod = st.getModificationTime();
                }
            }
            catch (IOException e) {
                throw new DatasetIOException("Cannot find last modified time of of " + dir, e);
            }
        }
        return lastMod;
    }
}

