/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.auth;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.flume.auth.FlumeAuthenticator;
import org.apache.flume.auth.PrivilegedExecutor;
import org.apache.flume.auth.SecurityException;
import org.apache.flume.auth.UGIExecutor;
import org.apache.hadoop.security.UserGroupInformation;

class SimpleAuthenticator
implements FlumeAuthenticator {
    private Map<String, PrivilegedExecutor> proxyCache = new HashMap<String, PrivilegedExecutor>();

    private SimpleAuthenticator() {
    }

    public static SimpleAuthenticator getSimpleAuthenticator() {
        return SimpleAuthenticatorHolder.authenticator;
    }

    @Override
    public <T> T execute(PrivilegedExceptionAction<T> action) throws Exception {
        return action.run();
    }

    @Override
    public <T> T execute(PrivilegedAction<T> action) {
        return action.run();
    }

    @Override
    public synchronized PrivilegedExecutor proxyAs(String proxyUserName) {
        if (proxyUserName == null || proxyUserName.isEmpty()) {
            return this;
        }
        if (this.proxyCache.get(proxyUserName) == null) {
            UserGroupInformation proxyUgi;
            try {
                proxyUgi = UserGroupInformation.createProxyUser((String)proxyUserName, (UserGroupInformation)UserGroupInformation.getCurrentUser());
            }
            catch (IOException e) {
                throw new SecurityException("Unable to create proxy User", e);
            }
            this.proxyCache.put(proxyUserName, new UGIExecutor(proxyUgi));
        }
        return this.proxyCache.get(proxyUserName);
    }

    @Override
    public boolean isAuthenticated() {
        return false;
    }

    @Override
    public void startCredentialRefresher() {
    }

    private static class SimpleAuthenticatorHolder {
        public static SimpleAuthenticator authenticator = new SimpleAuthenticator();

        private SimpleAuthenticatorHolder() {
        }
    }
}

