/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.login;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.security.User;
import org.apache.hadoop.util.PlatformName;

@InterfaceAudience.Private
public class HadoopLoginModule
implements LoginModule {
    private static final Log LOG = LogFactory.getLog(HadoopLoginModule.class);
    private static final Class<? extends Principal> OS_PRINCIPAL_CLASS = HadoopLoginModule.getOsPrincipalClass();
    List<Class<? extends Principal>> principalPriority = new ArrayList<Class<? extends Principal>>();
    List<Class<? extends Principal>> additionalPrincipals = new ArrayList<Class<? extends Principal>>();
    private Subject subject;

    private static Class<? extends Principal> getOsPrincipalClass() {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        try {
            String principalClass = null;
            principalClass = PlatformName.IBM_JAVA ? (PlatformName.IS_64BIT ? "com.ibm.security.auth.UsernamePrincipal" : (PlatformName.IS_WINDOWS ? "com.ibm.security.auth.NTUserPrincipal" : (PlatformName.IS_AIX ? "com.ibm.security.auth.AIXPrincipal" : "com.ibm.security.auth.LinuxPrincipal"))) : (PlatformName.IS_WINDOWS ? "com.sun.security.auth.NTUserPrincipal" : "com.sun.security.auth.UnixPrincipal");
            return cl.loadClass(principalClass);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Unable to find JAAS classes:" + e.getMessage()));
            return null;
        }
    }

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    private <T extends Principal> T getCanonicalUser(Class<T> cls) {
        for (Principal user : this.subject.getPrincipals(cls)) {
            if (!cls.isInstance(user)) continue;
            return (T)user;
        }
        return null;
    }

    private void warnIfIdentityAmbiguity(User user, Principal p) {
        User tuser = new User(p.getName());
        if (!user.getShortName().equals(tuser.getShortName())) {
            LOG.error((Object)("Possible identity ambiguity. Found these two different names in Subject: " + user + ", " + tuser + ". Two different identities" + " were found by the LoginModules in the JAAS configuration file."));
        }
    }

    @Override
    public boolean commit() throws LoginException {
        Principal p;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"hadoop login commit");
        }
        if (!this.subject.getPrincipals(User.class).isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using existing subject:" + this.subject.getPrincipals()));
            }
            return true;
        }
        User user = null;
        for (Class<? extends Principal> possiblePrincipal : this.principalPriority) {
            p = this.getCanonicalUser(possiblePrincipal);
            if (p == null) continue;
            if (user == null) {
                user = new User(p.getName());
                continue;
            }
            this.warnIfIdentityAmbiguity(user, p);
        }
        if (user == null) {
            for (Class<? extends Principal> possiblePrincipal : this.additionalPrincipals) {
                p = this.getCanonicalUser(possiblePrincipal);
                if (p == null) continue;
                user = new User(p.getName());
                break;
            }
        }
        if (user != null) {
            this.subject.getPrincipals().add(user);
            return true;
        }
        LOG.error((Object)("Can't find expected Hadoop user in " + this.subject));
        throw new LoginException("Can't find user name");
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        try {
            boolean clearSpecified = false;
            String principalString = (String)options.get("principalPriority");
            if (principalString != null) {
                int start;
                String[] classes = (principalString = principalString.trim()).split(",[\\s]*");
                if (classes[0].equalsIgnoreCase("clear")) {
                    clearSpecified = true;
                    start = 1;
                } else {
                    start = 0;
                }
                for (int i = start; i < classes.length; ++i) {
                    this.principalPriority.add(Class.forName(classes[i]));
                }
            }
            if (!clearSpecified) {
                this.principalPriority.add(0, KerberosPrincipal.class);
            }
            if (!clearSpecified) {
                this.additionalPrincipals.add(OS_PRINCIPAL_CLASS);
            }
            if (LOG.isDebugEnabled()) {
                String list = Arrays.toString(this.principalPriority.toArray());
                LOG.debug((Object)("Priority principal search list is " + list));
                list = Arrays.toString(this.additionalPrincipals.toArray());
                LOG.debug((Object)("Additional principal search list is " + list));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failure to initialize Hadoop login module", e);
        }
    }

    @Override
    public boolean login() throws LoginException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"hadoop login");
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"hadoop logout");
        }
        return true;
    }
}

