/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import javax.servlet.Servlet;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.ResponderServlet;
import org.apache.avro.ipc.Server;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

public class HttpServer
implements Server {
    private org.mortbay.jetty.Server server = new org.mortbay.jetty.Server();

    public HttpServer(Responder responder, int port) throws IOException {
        this(new ResponderServlet(responder), null, port);
    }

    public HttpServer(ResponderServlet servlet, int port) throws IOException {
        this(servlet, null, port);
    }

    public HttpServer(Responder responder, String bindAddress, int port) throws IOException {
        this(new ResponderServlet(responder), bindAddress, port);
    }

    public HttpServer(ResponderServlet servlet, String bindAddress, int port) throws IOException {
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setLowResourceMaxIdleTime(10000);
        connector.setAcceptQueueSize(128);
        connector.setResolveNames(false);
        connector.setUseDirectBuffers(false);
        if (bindAddress != null) {
            connector.setHost(bindAddress);
        }
        connector.setPort(port);
        this.server.addConnector(connector);
        new Context(this.server, "/").addServlet(new ServletHolder((Servlet)servlet), "/*");
    }

    public HttpServer(Responder responder, Connector connector) throws IOException {
        this(new ResponderServlet(responder), connector);
    }

    public HttpServer(ResponderServlet servlet, Connector connector) throws IOException {
        this.server.addConnector(connector);
        new Context(this.server, "/").addServlet(new ServletHolder((Servlet)servlet), "/*");
    }

    public void addConnector(Connector connector) {
        this.server.addConnector(connector);
    }

    @Override
    public int getPort() {
        return this.server.getConnectors()[0].getLocalPort();
    }

    @Override
    public void close() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new AvroRuntimeException(e);
        }
    }

    @Override
    public void start() {
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new AvroRuntimeException(e);
        }
    }

    @Override
    public void join() throws InterruptedException {
        this.server.join();
    }
}

