/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import parquet.Log;
import parquet.column.Encoding;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.ColumnPath;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.schema.PrimitiveType;

public class ParquetInputSplit
extends FileSplit
implements Writable {
    private static final Log LOG = Log.getLog(ParquetInputSplit.class);
    private List<BlockMetaData> blocks;
    private String requestedSchema;
    private String fileSchema;
    private Map<String, String> extraMetadata;
    private Map<String, String> readSupportMetadata;

    public ParquetInputSplit() {
        super(null, 0L, 0L, new String[0]);
    }

    public ParquetInputSplit(Path path, long start, long length, String[] hosts, List<BlockMetaData> blocks, String requestedSchema, String fileSchema, Map<String, String> extraMetadata, Map<String, String> readSupportMetadata) {
        super(path, start, length, hosts);
        this.blocks = blocks;
        this.requestedSchema = requestedSchema;
        this.fileSchema = fileSchema;
        this.extraMetadata = extraMetadata;
        this.readSupportMetadata = readSupportMetadata;
    }

    public List<BlockMetaData> getBlocks() {
        return this.blocks;
    }

    public String getRequestedSchema() {
        return this.requestedSchema;
    }

    public String getFileSchema() {
        return this.fileSchema;
    }

    public Map<String, String> getExtraMetadata() {
        return this.extraMetadata;
    }

    public Map<String, String> getReadSupportMetadata() {
        return this.readSupportMetadata;
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        int blocksSize = in.readInt();
        this.blocks = new ArrayList<BlockMetaData>(blocksSize);
        for (int i = 0; i < blocksSize; ++i) {
            this.blocks.add(this.readBlock(in));
        }
        this.requestedSchema = this.decompressString(in);
        this.fileSchema = this.decompressString(in);
        this.extraMetadata = this.readKeyValues(in);
        this.readSupportMetadata = this.readKeyValues(in);
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.blocks.size());
        for (BlockMetaData block : this.blocks) {
            this.writeBlock(out, block);
        }
        byte[] compressedSchema = this.compressString(this.requestedSchema);
        out.writeInt(compressedSchema.length);
        out.write(compressedSchema);
        compressedSchema = this.compressString(this.fileSchema);
        out.writeInt(compressedSchema.length);
        out.write(compressedSchema);
        this.writeKeyValues(out, this.extraMetadata);
        this.writeKeyValues(out, this.readSupportMetadata);
    }

    byte[] compressString(String str) {
        ByteArrayOutputStream obj = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(obj);
            gzip.write(str.getBytes("UTF-8"));
            gzip.close();
        }
        catch (IOException e) {
            LOG.error((Object)("Unable to gzip InputSplit string " + str), (Throwable)e);
            throw new RuntimeException("Unable to gzip InputSplit string", e);
        }
        return obj.toByteArray();
    }

    String decompressString(DataInput in) throws IOException {
        int len = in.readInt();
        byte[] bytes = new byte[len];
        in.readFully(bytes);
        return this.decompressString(bytes);
    }

    String decompressString(byte[] bytes) {
        ByteArrayInputStream obj = new ByteArrayInputStream(bytes);
        GZIPInputStream gzip = null;
        String outStr = "";
        try {
            gzip = new GZIPInputStream(obj);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)gzip, "UTF-8"));
            char[] buffer = new char[1024];
            int n = 0;
            StringBuilder sb = new StringBuilder();
            while (-1 != (n = reader.read(buffer))) {
                sb.append(buffer, 0, n);
            }
            outStr = sb.toString();
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to uncompress InputSplit string", (Throwable)e);
            throw new RuntimeException("Unable to uncompress InputSplit String", e);
        }
        finally {
            if (null != gzip) {
                try {
                    gzip.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Unable to uncompress InputSplit", (Throwable)e);
                    throw new RuntimeException("Unable to uncompress InputSplit String", e);
                }
            }
        }
        return outStr;
    }

    private BlockMetaData readBlock(DataInput in) throws IOException {
        BlockMetaData block = new BlockMetaData();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            block.addColumn(this.readColumn(in));
        }
        block.setRowCount(in.readLong());
        block.setTotalByteSize(in.readLong());
        if (!in.readBoolean()) {
            block.setPath(in.readUTF().intern());
        }
        return block;
    }

    private void writeBlock(DataOutput out, BlockMetaData block) throws IOException {
        out.writeInt(block.getColumns().size());
        for (ColumnChunkMetaData column : block.getColumns()) {
            this.writeColumn(out, column);
        }
        out.writeLong(block.getRowCount());
        out.writeLong(block.getTotalByteSize());
        out.writeBoolean(block.getPath() == null);
        if (block.getPath() != null) {
            out.writeUTF(block.getPath());
        }
    }

    private ColumnChunkMetaData readColumn(DataInput in) throws IOException {
        CompressionCodecName codec = CompressionCodecName.values()[in.readInt()];
        String[] columnPath = new String[in.readInt()];
        for (int i = 0; i < columnPath.length; ++i) {
            columnPath[i] = in.readUTF().intern();
        }
        PrimitiveType.PrimitiveTypeName type = PrimitiveType.PrimitiveTypeName.values()[in.readInt()];
        int encodingsSize = in.readInt();
        HashSet<Encoding> encodings = new HashSet<Encoding>(encodingsSize);
        for (int i = 0; i < encodingsSize; ++i) {
            encodings.add(Encoding.values()[in.readInt()]);
        }
        ColumnChunkMetaData column = ColumnChunkMetaData.get(ColumnPath.get(columnPath), type, codec, encodings, in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong());
        return column;
    }

    private void writeColumn(DataOutput out, ColumnChunkMetaData column) throws IOException {
        out.writeInt(column.getCodec().ordinal());
        out.writeInt(column.getPath().size());
        for (String s : column.getPath()) {
            out.writeUTF(s);
        }
        out.writeInt(column.getType().ordinal());
        out.writeInt(column.getEncodings().size());
        for (Encoding encoding : column.getEncodings()) {
            out.writeInt(encoding.ordinal());
        }
        out.writeLong(column.getFirstDataPageOffset());
        out.writeLong(column.getDictionaryPageOffset());
        out.writeLong(column.getValueCount());
        out.writeLong(column.getTotalSize());
        out.writeLong(column.getTotalUncompressedSize());
    }

    private Map<String, String> readKeyValues(DataInput in) throws IOException {
        int size = in.readInt();
        HashMap<String, String> map = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            String key = this.decompressString(in).intern();
            String value = this.decompressString(in).intern();
            map.put(key, value);
        }
        return map;
    }

    private void writeKeyValues(DataOutput out, Map<String, String> map) throws IOException {
        if (map == null) {
            out.writeInt(0);
        } else {
            out.writeInt(map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                byte[] compr = this.compressString(entry.getKey());
                out.writeInt(compr.length);
                out.write(compr);
                compr = this.compressString(entry.getValue());
                out.writeInt(compr.length);
                out.write(compr);
            }
        }
    }

    public String toString() {
        Object[] hosts = new String[]{};
        try {
            hosts = this.getLocations();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ((Object)((Object)this)).getClass().getSimpleName() + "{" + "part: " + this.getPath() + " start: " + this.getStart() + " length: " + this.getLength() + " hosts: " + Arrays.toString(hosts) + " blocks: " + this.blocks.size() + " requestedSchema: " + (this.fileSchema.equals(this.requestedSchema) ? "same as file" : this.requestedSchema) + " fileSchema: " + this.fileSchema + " extraMetadata: " + this.extraMetadata + " readSupportMetadata: " + this.readSupportMetadata + "}";
    }
}

