/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.kitesdk.data.hbase.filters.EntityFilter;
import org.kitesdk.data.hbase.filters.RegexEntityFilter;
import org.kitesdk.data.hbase.filters.SingleFieldEntityFilter;
import org.kitesdk.data.hbase.impl.EntityMapper;
import org.kitesdk.data.hbase.impl.EntityScanner;
import org.kitesdk.data.hbase.impl.ScanModifier;
import org.kitesdk.data.spi.PartitionKey;

public abstract class EntityScannerBuilder<E> {
    private HTablePool tablePool;
    private String tableName;
    private PartitionKey startKey;
    private PartitionKey stopKey;
    private boolean startInclusive = true;
    private boolean stopInclusive = false;
    private int caching;
    private EntityMapper<E> entityMapper;
    private List<ScanModifier> scanModifiers = new ArrayList<ScanModifier>();
    private boolean passAllFilters = true;
    private List<Filter> filterList = new ArrayList<Filter>();

    public EntityScannerBuilder(HTablePool tablePool, String tableName, EntityMapper<E> entityMapper) {
        this.tablePool = tablePool;
        this.tableName = tableName;
        this.entityMapper = entityMapper;
    }

    HTablePool getTablePool() {
        return this.tablePool;
    }

    String getTableName() {
        return this.tableName;
    }

    EntityMapper<E> getEntityMapper() {
        return this.entityMapper;
    }

    PartitionKey getStartKey() {
        return this.startKey;
    }

    public EntityScannerBuilder<E> setStartKey(PartitionKey startKey) {
        this.startKey = startKey;
        return this;
    }

    PartitionKey getStopKey() {
        return this.stopKey;
    }

    public EntityScannerBuilder<E> setStopKey(PartitionKey stopKey) {
        this.stopKey = stopKey;
        return this;
    }

    boolean getStartInclusive() {
        return this.startInclusive;
    }

    public EntityScannerBuilder<E> setStartInclusive(boolean startInclusive) {
        this.startInclusive = startInclusive;
        return this;
    }

    boolean getStopInclusive() {
        return this.stopInclusive;
    }

    public EntityScannerBuilder<E> setStopInclusive(boolean stopInclusive) {
        this.stopInclusive = stopInclusive;
        return this;
    }

    int getCaching() {
        return this.caching;
    }

    public EntityScannerBuilder<E> setCaching(int caching) {
        this.caching = caching;
        return this;
    }

    public EntityScannerBuilder<E> addEqualFilter(String fieldName, Object filterValue) {
        SingleFieldEntityFilter singleFieldEntityFilter = new SingleFieldEntityFilter(this.entityMapper.getEntitySchema(), this.entityMapper.getEntitySerDe(), fieldName, filterValue, CompareFilter.CompareOp.EQUAL);
        this.filterList.add(singleFieldEntityFilter.getFilter());
        return this;
    }

    public EntityScannerBuilder<E> addNotEqualFilter(String fieldName, Object filterValue) {
        SingleFieldEntityFilter singleFieldEntityFilter = new SingleFieldEntityFilter(this.entityMapper.getEntitySchema(), this.entityMapper.getEntitySerDe(), fieldName, filterValue, CompareFilter.CompareOp.NOT_EQUAL);
        this.filterList.add(singleFieldEntityFilter.getFilter());
        return this;
    }

    public EntityScannerBuilder<E> addRegexMatchFilter(String fieldName, String regexString) {
        RegexEntityFilter regexEntityFilter = new RegexEntityFilter(this.entityMapper.getEntitySchema(), this.entityMapper.getEntitySerDe(), fieldName, regexString);
        this.filterList.add(regexEntityFilter.getFilter());
        return this;
    }

    public EntityScannerBuilder<E> addRegexNotMatchFilter(String fieldName, String regexString) {
        RegexEntityFilter regexEntityFilter = new RegexEntityFilter(this.entityMapper.getEntitySchema(), this.entityMapper.getEntitySerDe(), fieldName, regexString, false);
        this.filterList.add(regexEntityFilter.getFilter());
        return this;
    }

    public EntityScannerBuilder<E> addNotNullFilter(String fieldName) {
        RegexEntityFilter regexEntityFilter = new RegexEntityFilter(this.entityMapper.getEntitySchema(), this.entityMapper.getEntitySerDe(), fieldName, ".+");
        this.filterList.add(regexEntityFilter.getFilter());
        return this;
    }

    public EntityScannerBuilder<E> addIsNullFilter(String fieldName) {
        RegexEntityFilter regexEntityFilter = new RegexEntityFilter(this.entityMapper.getEntitySchema(), this.entityMapper.getEntitySerDe(), fieldName, ".+", false);
        this.filterList.add(regexEntityFilter.getFilter());
        return this;
    }

    public EntityScannerBuilder<E> addIsMissingFilter(String fieldName) {
        SingleFieldEntityFilter singleFieldEntityFilter = new SingleFieldEntityFilter(this.entityMapper.getEntitySchema(), this.entityMapper.getEntitySerDe(), fieldName, "++++NON_SHALL_PASS++++", CompareFilter.CompareOp.EQUAL);
        SingleColumnValueFilter filter = (SingleColumnValueFilter)singleFieldEntityFilter.getFilter();
        filter.setFilterIfMissing(false);
        this.filterList.add((Filter)filter);
        return this;
    }

    boolean getPassAllFilters() {
        return this.passAllFilters;
    }

    public EntityScannerBuilder<E> setPassAllFilters(boolean passAllFilters) {
        this.passAllFilters = passAllFilters;
        return this;
    }

    List<Filter> getFilterList() {
        return this.filterList;
    }

    public EntityScannerBuilder<E> addFilter(EntityFilter filter) {
        this.filterList.add(filter.getFilter());
        return this;
    }

    List<ScanModifier> getScanModifiers() {
        return this.scanModifiers;
    }

    public EntityScannerBuilder<E> addScanModifier(ScanModifier scanModifier) {
        this.scanModifiers.add(scanModifier);
        return this;
    }

    public abstract EntityScanner<E> build();
}

