/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.impl;

import java.util.ArrayList;
import java.util.Set;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Result;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.FieldMapping;
import org.kitesdk.data.hbase.impl.EntityComposer;
import org.kitesdk.data.hbase.impl.EntityMapper;
import org.kitesdk.data.hbase.impl.EntitySchema;
import org.kitesdk.data.hbase.impl.EntitySerDe;
import org.kitesdk.data.hbase.impl.HBaseUtils;
import org.kitesdk.data.hbase.impl.KeySchema;
import org.kitesdk.data.hbase.impl.KeySerDe;
import org.kitesdk.data.hbase.impl.PutAction;
import org.kitesdk.data.spi.PartitionKey;

public class BaseEntityMapper<E>
implements EntityMapper<E> {
    private final KeySchema keySchema;
    private final EntitySchema entitySchema;
    private final KeySerDe keySerDe;
    private final EntitySerDe<E> entitySerDe;

    public BaseEntityMapper(EntitySchema entitySchema, EntitySerDe<E> entitySerDe) {
        this(null, entitySchema, null, entitySerDe);
    }

    public BaseEntityMapper(KeySchema keySchema, EntitySchema entitySchema, KeySerDe keySerDe, EntitySerDe<E> entitySerDe) {
        this.keySchema = keySchema;
        this.entitySchema = entitySchema;
        this.keySerDe = keySerDe;
        this.entitySerDe = entitySerDe;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public E mapToEntity(Result result) {
        boolean allNull = true;
        PartitionKey partitionKey = this.keySerDe == null ? null : this.keySerDe.deserialize(result.getRow());
        EntityComposer.Builder<E> builder = this.getEntityComposer().getBuilder();
        for (FieldMapping fieldMapping : this.entitySchema.getColumnMappingDescriptor().getFieldMappings()) {
            Object fieldValue;
            if (fieldMapping.getMappingType() == FieldMapping.MappingType.KEY) {
                if (partitionKey == null) throw new DatasetException("[BUG] Key-mapped field and null key");
                fieldValue = partitionKey.get(this.keySchema.position(fieldMapping.getFieldName()));
            } else {
                fieldValue = this.entitySerDe.deserialize(fieldMapping, result);
            }
            if (fieldValue == null) continue;
            builder.put(fieldMapping.getFieldName(), fieldValue);
            if (fieldMapping.getMappingType() == FieldMapping.MappingType.KEY) continue;
            allNull = false;
        }
        if (allNull) {
            return null;
        }
        E entity = builder.build();
        return entity;
    }

    @Override
    public PartitionKey mapToKey(E entity) {
        return this.getEntityComposer().extractKey(this.keySchema.getPartitionStrategy(), entity);
    }

    @Override
    public PutAction mapFromEntity(E entity) {
        ArrayList<PutAction> putActionList = new ArrayList<PutAction>();
        byte[] keyBytes = this.keySchema == null || this.keySerDe == null ? new byte[]{0} : this.keySerDe.serialize(this.mapToKey(entity));
        for (FieldMapping fieldMapping : this.entitySchema.getColumnMappingDescriptor().getFieldMappings()) {
            Object fieldValue;
            if (fieldMapping.getMappingType() == FieldMapping.MappingType.KEY || (fieldValue = this.getEntityComposer().extractField(entity, fieldMapping.getFieldName())) == null) continue;
            PutAction put = this.entitySerDe.serialize(keyBytes, fieldMapping, fieldValue);
            putActionList.add(put);
        }
        return HBaseUtils.mergePutActions(keyBytes, putActionList);
    }

    @Override
    public Increment mapToIncrement(PartitionKey key, String fieldName, long amount) {
        FieldMapping fieldMapping = this.entitySchema.getColumnMappingDescriptor().getFieldMapping(fieldName);
        if (fieldMapping == null) {
            throw new DatasetException("Unknown field in the schema: " + fieldName);
        }
        if (fieldMapping.getMappingType() != FieldMapping.MappingType.COUNTER) {
            throw new DatasetException("Field is not a counter type: " + fieldName);
        }
        byte[] keyBytes = this.keySerDe == null ? new byte[]{0} : this.keySerDe.serialize(key);
        Increment increment = new Increment(keyBytes);
        increment.addColumn(fieldMapping.getFamily(), fieldMapping.getQualifier(), amount);
        return increment;
    }

    @Override
    public long mapFromIncrementResult(Result result, String fieldName) {
        FieldMapping fieldMapping = this.entitySchema.getColumnMappingDescriptor().getFieldMapping(fieldName);
        if (fieldMapping == null) {
            throw new DatasetException("Unknown field in the schema: " + fieldName);
        }
        if (fieldMapping.getMappingType() != FieldMapping.MappingType.COUNTER) {
            throw new DatasetException("Field is not a counter type: " + fieldName);
        }
        return (Long)this.entitySerDe.deserialize(fieldMapping, result);
    }

    @Override
    public Set<String> getRequiredColumns() {
        return this.entitySchema.getColumnMappingDescriptor().getRequiredColumns();
    }

    @Override
    public Set<String> getRequiredColumnFamilies() {
        return this.entitySchema.getColumnMappingDescriptor().getRequiredColumnFamilies();
    }

    @Override
    public KeySchema getKeySchema() {
        return this.keySchema;
    }

    @Override
    public EntitySchema getEntitySchema() {
        return this.entitySchema;
    }

    @Override
    public KeySerDe getKeySerDe() {
        return this.keySerDe;
    }

    @Override
    public EntitySerDe<E> getEntitySerDe() {
        return this.entitySerDe;
    }

    public EntityComposer<E> getEntityComposer() {
        return this.entitySerDe.getEntityComposer();
    }
}

