/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.avro;

import java.util.List;
import org.apache.avro.Schema;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.hbase.avro.AvroUtils;
import org.kitesdk.data.hbase.impl.KeySchema;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.SchemaUtil;

public class AvroKeySchema
extends KeySchema {
    private final Schema schema;

    public AvroKeySchema(Schema entitySchema, PartitionStrategy partitionStrategy) {
        super(null, partitionStrategy);
        this.schema = SchemaUtil.keySchema((Schema)entitySchema, (PartitionStrategy)partitionStrategy);
    }

    @Override
    public boolean compatible(KeySchema keySchema) {
        List fieldPartitioners = Accessor.getDefault().getFieldPartitioners(this.getPartitionStrategy());
        List otherFieldPartitioners = Accessor.getDefault().getFieldPartitioners(keySchema.getPartitionStrategy());
        if (fieldPartitioners.size() != otherFieldPartitioners.size()) {
            return false;
        }
        return AvroUtils.avroSchemaTypesEqual(this.schema, ((AvroKeySchema)keySchema).schema);
    }

    @Override
    public String getRawSchema() {
        return this.getAvroSchema().toString();
    }

    public Schema getAvroSchema() {
        return this.schema;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AvroKeySchema other = (AvroKeySchema)obj;
        return !(this.schema == null ? other.schema != null : !this.schema.equals((Object)other.schema));
    }
}

