/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;

public final class SystemPermission
extends BasicPermission {
    private static final long serialVersionUID = 1965420504091489898L;
    public static final String SERVER = "server";
    public static final String ENGINE = "engine";
    public static final String JMX = "jmx";
    public static final String SHUTDOWN = "shutdown";
    public static final String CONTROL = "control";
    public static final String MONITOR = "monitor";
    private static final Set<String> LEGAL_NAMES = new HashSet<String>();
    private static final List<String> LEGAL_ACTIONS;
    private String actions;

    public SystemPermission(String string, String string2) {
        super(string);
        this.validateNameAndActions(string, string2);
    }

    private void validateNameAndActions(String string, String string2) {
        if (!LEGAL_NAMES.contains(string)) {
            throw new IllegalArgumentException("Unknown permission " + string);
        }
        this.actions = SystemPermission.getCanonicalForm(string2);
    }

    @Override
    public String getActions() {
        return this.actions;
    }

    private static String getCanonicalForm(String string) {
        Set<String> set = SystemPermission.parseActions(string);
        ArrayList<String> arrayList = new ArrayList<String>(LEGAL_ACTIONS);
        arrayList.retainAll(set);
        return SystemPermission.buildActionsString(arrayList);
    }

    static Set<String> parseActions(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : string.split(",", -1)) {
            hashSet.add(string2.trim().toLowerCase(Locale.ENGLISH));
        }
        return hashSet;
    }

    static String buildActionsString(Iterable<String> iterable) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : iterable) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        SystemPermission systemPermission = (SystemPermission)object;
        return this.getActions().equals(systemPermission.getActions());
    }

    @Override
    public boolean implies(Permission permission) {
        int n;
        if (!super.implies(permission)) {
            return false;
        }
        int n2 = SystemPermission.getActionMask(this.getActions());
        return (n2 & (n = SystemPermission.getActionMask(permission.getActions()))) == n;
    }

    private static int getActionMask(String string) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            int n2 = LEGAL_ACTIONS.indexOf(stringTokenizer.nextElement());
            if (n2 == -1) continue;
            n |= 1 << n2;
        }
        return n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.validateNameAndActions(this.getName(), this.getActions());
    }

    static {
        LEGAL_NAMES.add(SERVER);
        LEGAL_NAMES.add(ENGINE);
        LEGAL_NAMES.add(JMX);
        LEGAL_ACTIONS = new ArrayList<String>();
        LEGAL_ACTIONS.add(CONTROL);
        LEGAL_ACTIONS.add(MONITOR);
        LEGAL_ACTIONS.add(SHUTDOWN);
    }
}

