/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.EnumSet;
import org.apache.derby.iapi.services.io.FilePermissionService;

final class FilePermissionServiceImpl
implements FilePermissionService {
    FilePermissionServiceImpl() {
    }

    @Override
    public boolean limitAccessToOwner(File file) throws IOException {
        Path path = file.toPath();
        PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        if (posixFileAttributeView != null) {
            EnumSet<PosixFilePermission> enumSet = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE);
            if (file.isDirectory()) {
                enumSet.add(PosixFilePermission.OWNER_EXECUTE);
            }
            posixFileAttributeView.setPermissions(enumSet);
            return true;
        }
        AclFileAttributeView aclFileAttributeView = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
        if (aclFileAttributeView != null) {
            AclEntry aclEntry = AclEntry.newBuilder().setPrincipal(Files.getOwner(path, new LinkOption[0])).setType(AclEntryType.ALLOW).setPermissions(EnumSet.allOf(AclEntryPermission.class)).build();
            aclFileAttributeView.setAcl(Collections.singletonList(aclEntry));
            return true;
        }
        return false;
    }
}

