/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.util;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.exceptions.TypeException;
import org.ojai.json.Json;
import org.ojai.json.JsonOptions;

@API.Public
public class Values {
    public static byte asByte(@API.NonNullable Value value) {
        return Values.asNumber(value).byteValue();
    }

    public static short asShort(@API.NonNullable Value value) {
        return Values.asNumber(value).shortValue();
    }

    public static int asInt(@API.NonNullable Value value) {
        return Values.asNumber(value).intValue();
    }

    public static long asLong(Value value) {
        return Values.asNumber(value).longValue();
    }

    public static float asFloat(Value value) {
        return Values.asNumber(value).floatValue();
    }

    public static double asDouble(Value value) {
        return Values.asNumber(value).doubleValue();
    }

    public static BigDecimal asDecimal(Value value) {
        Number val = Values.asNumber(value);
        return val instanceof BigDecimal ? (BigDecimal)val : (val instanceof Long ? new BigDecimal(val.longValue()) : new BigDecimal(val.doubleValue()));
    }

    public static Number asNumber(@API.NonNullable Value value) {
        Preconditions.checkNotNull((Object)value);
        switch (value.getType()) {
            case BYTE: {
                return value.getByte();
            }
            case SHORT: {
                return value.getShort();
            }
            case INT: {
                return value.getInt();
            }
            case LONG: {
                return value.getLong();
            }
            case FLOAT: {
                return Float.valueOf(value.getFloat());
            }
            case DOUBLE: {
                return value.getDouble();
            }
            case DECIMAL: {
                return value.getDecimal();
            }
            case STRING: {
                try {
                    return new BigDecimal(value.getString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        throw new TypeException(value.asJsonString() + " can not be converted to a Number.");
    }

    public static boolean asBoolean(@API.NonNullable Value value) {
        Preconditions.checkNotNull((Object)value);
        switch (value.getType()) {
            case NULL: {
                return false;
            }
            case BOOLEAN: {
                return value.getBoolean();
            }
            case STRING: {
                String strValue = value.getString();
                if (strValue.equalsIgnoreCase("true")) {
                    return true;
                }
                if (!strValue.equalsIgnoreCase("false")) break;
                return false;
            }
            default: {
                if (!value.getType().isNumeric()) break;
                return 0.0 != Values.asNumber(value).doubleValue();
            }
        }
        throw new TypeException(value.asJsonString() + " can not be converted to a Boolean value.");
    }

    public static String asString(@API.NonNullable Value value) {
        Preconditions.checkNotNull((Object)value);
        switch (value.getType()) {
            case NULL: {
                return null;
            }
            case STRING: {
                return value.getString();
            }
            case DATE: {
                return value.getDate().toDateStr();
            }
            case INTERVAL: {
                return String.valueOf(value.getInterval().getTimeInMillis());
            }
            case TIME: {
                return value.getTime().toTimeStr();
            }
            case TIMESTAMP: {
                return value.getTimestamp().toUTCString();
            }
        }
        return Json.toJsonString(value.asReader(), JsonOptions.WITHOUT_TAGS);
    }

    public static BigDecimal parseBigDecimal(@API.NonNullable String s) {
        return new BigDecimal(s);
    }

    public static ByteBuffer parseBinary(@API.NonNullable String s) {
        return ByteBuffer.wrap(BaseEncoding.base64().decode((CharSequence)s));
    }

    public static String asJsonString(@API.NonNullable Value value) {
        return Json.toJsonString(value.asReader(), JsonOptions.WITH_TAGS);
    }
}

