/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.json.impl.store;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.exceptions.DecodingException;
import org.ojai.exceptions.OjaiException;
import org.ojai.json.Json;
import org.ojai.json.impl.JsonValueBuilder;
import org.ojai.json.impl.store.JsonConnection;
import org.ojai.store.Connection;
import org.ojai.store.DocumentMutation;
import org.ojai.store.Driver;
import org.ojai.store.DriverManager;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.ValueBuilder;

public class JsonDriver
implements Driver {
    private static final JsonDriver DRIVER_INSTANCE = new JsonDriver();

    @Override
    public Document newDocument() {
        return Json.newDocument();
    }

    @Override
    public Document newDocument(String documentJson) throws DecodingException {
        return Json.newDocument(documentJson);
    }

    @Override
    public Document newDocument(Map<String, Object> map) throws DecodingException {
        return Json.newDocument(map);
    }

    @Override
    public Document newDocument(Object bean) throws DecodingException {
        return Json.newDocument(bean);
    }

    @Override
    public DocumentBuilder newDocumentBuilder() {
        return Json.newDocumentBuilder();
    }

    @Override
    public DocumentMutation newMutation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public QueryCondition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Query newQuery() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Query newQuery(String queryJson) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean accepts(String url) {
        Preconditions.checkNotNull((Object)url);
        return url.startsWith("ojai:json:@");
    }

    @Override
    public Connection connect(String url, Document options) throws OjaiException {
        Preconditions.checkArgument((boolean)this.accepts(url));
        return new JsonConnection(this, url, options);
    }

    @Override
    public String getName() {
        return "Json OJAI Driver";
    }

    public int hashCode() {
        return 31;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public ValueBuilder getValueBuilder() {
        return JsonValueBuilder.INSTANCE;
    }

    static {
        DriverManager.registerDriver(DRIVER_INSTANCE);
    }
}

