/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.json.impl;

import java.io.UnsupportedEncodingException;
import org.ojai.DocumentBuilder;
import org.ojai.DocumentReader;
import org.ojai.annotation.API;
import org.ojai.exceptions.DecodingException;

@API.Internal
public class JsonUtils {
    public static byte[] getBytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static void addToMap(DocumentReader r, DocumentBuilder w) {
        DocumentReader.EventType e;
        block21: while ((e = r.next()) != null) {
            switch (e) {
                case NULL: {
                    w.putNull(r.getFieldName());
                    continue block21;
                }
                case BOOLEAN: {
                    w.put(r.getFieldName(), r.getBoolean());
                    continue block21;
                }
                case STRING: {
                    w.put(r.getFieldName(), r.getString());
                    continue block21;
                }
                case BYTE: {
                    w.put(r.getFieldName(), r.getByte());
                    continue block21;
                }
                case SHORT: {
                    w.put(r.getFieldName(), r.getShort());
                    continue block21;
                }
                case INT: {
                    w.put(r.getFieldName(), r.getInt());
                    continue block21;
                }
                case LONG: {
                    w.put(r.getFieldName(), r.getLong());
                    continue block21;
                }
                case FLOAT: {
                    w.put(r.getFieldName(), r.getFloat());
                    continue block21;
                }
                case DOUBLE: {
                    w.put(r.getFieldName(), r.getDouble());
                    continue block21;
                }
                case DECIMAL: {
                    w.put(r.getFieldName(), r.getDecimal());
                    continue block21;
                }
                case DATE: {
                    w.put(r.getFieldName(), r.getDate());
                    continue block21;
                }
                case TIME: {
                    w.put(r.getFieldName(), r.getTime());
                    continue block21;
                }
                case TIMESTAMP: {
                    w.put(r.getFieldName(), r.getTimestamp());
                    continue block21;
                }
                case INTERVAL: {
                    w.put(r.getFieldName(), r.getInterval());
                    continue block21;
                }
                case BINARY: {
                    w.put(r.getFieldName(), r.getBinary());
                    continue block21;
                }
                case START_ARRAY: {
                    w.putNewArray(r.getFieldName());
                    JsonUtils.addToArray(r, w);
                    continue block21;
                }
                case END_ARRAY: {
                    w.endArray();
                    continue block21;
                }
                case START_MAP: {
                    if (r.getFieldName() != null) {
                        w.putNewMap(r.getFieldName());
                    } else {
                        w.addNewMap();
                    }
                    JsonUtils.addToMap(r, w);
                    continue block21;
                }
                case END_MAP: {
                    w.endMap();
                    return;
                }
            }
            throw new DecodingException("Unknown event type: " + (Object)((Object)e));
        }
    }

    public static void addToArray(DocumentReader r, DocumentBuilder w) {
        DocumentReader.EventType e;
        while ((e = r.next()) != null) {
            if (e == DocumentReader.EventType.END_ARRAY) {
                w.endArray();
                break;
            }
            JsonUtils.addReaderEvent(e, r, w.setArrayIndex(r.getArrayIndex()));
        }
    }

    public static void addReaderEvent(DocumentReader.EventType e, DocumentReader r, DocumentBuilder w) {
        switch (e) {
            case NULL: {
                w.addNull();
                break;
            }
            case BOOLEAN: {
                w.add(r.getBoolean());
                break;
            }
            case STRING: {
                w.add(r.getString());
                break;
            }
            case BYTE: {
                w.add(r.getByte());
                break;
            }
            case SHORT: {
                w.add(r.getShort());
                break;
            }
            case INT: {
                w.add(r.getInt());
                break;
            }
            case LONG: {
                w.add(r.getLong());
                break;
            }
            case FLOAT: {
                w.add(r.getFloat());
                break;
            }
            case DOUBLE: {
                w.add(r.getDouble());
                break;
            }
            case DECIMAL: {
                w.add(r.getDecimal());
                break;
            }
            case DATE: {
                w.add(r.getDate());
                break;
            }
            case TIME: {
                w.add(r.getTime());
                break;
            }
            case TIMESTAMP: {
                w.add(r.getTimestamp());
                break;
            }
            case INTERVAL: {
                w.add(r.getInterval());
                break;
            }
            case BINARY: {
                w.add(r.getBinary());
                break;
            }
            case START_MAP: {
                w.addNewMap();
                JsonUtils.addToMap(r, w);
                break;
            }
            case END_MAP: {
                w.endMap();
                break;
            }
            case START_ARRAY: {
                w.addNewArray();
                JsonUtils.addToArray(r, w);
                break;
            }
            default: {
                throw new DecodingException("Unexpected event type: " + (Object)((Object)e));
            }
        }
    }
}

