/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.json.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.ojai.FieldSegment;
import org.ojai.Value;
import org.ojai.json.impl.JsonDocument;
import org.ojai.json.impl.JsonValue;
import org.ojai.json.impl.JsonValueBuilder;

class JsonList
extends JsonValue
implements List<Object> {
    List<JsonValue> list;

    public JsonList() {
        this.valueType = Value.Type.ARRAY;
        this.objValue = this.list = new ArrayList<JsonValue>();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(JsonValueBuilder.initFromObject(o));
    }

    @Override
    public String toString() {
        Iterator<Object> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            Object e;
            sb.append((e = it.next()) == this ? "(this Collection)" : e);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public Iterator<Object> iterator() {
        final Iterator<JsonValue> itr = this.list.iterator();
        return new Iterator<Object>(){

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object next() {
                return ((JsonValue)itr.next()).getObject();
            }

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }
        };
    }

    @Override
    public Object[] toArray() {
        ArrayList<Object> objs = new ArrayList<Object>(this.list.size());
        for (JsonValue kv : this.list) {
            objs.add(kv.getObject());
        }
        return objs.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return a;
    }

    @Override
    public boolean add(Object e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.list.contains(JsonValueBuilder.initFromObject(o))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends Object> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(int index) {
        JsonValue kv = this.getJsonValueAt(index);
        if (kv == null) {
            return null;
        }
        return kv.getObject();
    }

    @Override
    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, Object element) {
        int size = this.list.size();
        while (index > size++) {
            this.list.add(null);
        }
        this.list.add(JsonValueBuilder.initFromObject(element));
    }

    @Override
    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(JsonValueBuilder.initFromObject(o));
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(JsonValueBuilder.initFromObject(o));
    }

    @Override
    public ListIterator<Object> listIterator() {
        return new JsonListIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return new JsonListIterator(index);
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        ArrayList<Object> l = new ArrayList<Object>();
        for (JsonValue v : this.list.subList(fromIndex, toIndex)) {
            l.add(v.getObject());
        }
        return l;
    }

    JsonValue createOrInsert(Iterator<FieldSegment> iter, JsonValue inJsonValue) {
        FieldSegment field = iter.next();
        int index = field.getIndexSegment().getIndex();
        JsonValue oldJsonValue = this.getJsonValueAt(index);
        if (field.isLastPath()) {
            int size = this.list.size();
            if (index >= size) {
                while (index > size++) {
                    JsonValue nullValue = JsonValueBuilder.initFromNull();
                    this.list.add(nullValue);
                }
                this.list.add(inJsonValue);
            } else {
                this.list.set(index, inJsonValue);
            }
            return this;
        }
        if (field.isMap()) {
            if (oldJsonValue == null || oldJsonValue.getType() != Value.Type.MAP) {
                JsonDocument newDocument = new JsonDocument();
                newDocument.createOrInsert(iter, inJsonValue);
                if (index >= this.list.size()) {
                    this.list.add(newDocument);
                } else {
                    this.list.set(index, newDocument);
                }
                return this;
            }
            JsonDocument newDocument = (JsonDocument)oldJsonValue;
            return newDocument.createOrInsert(iter, inJsonValue);
        }
        if (oldJsonValue == null || oldJsonValue.getType() != Value.Type.ARRAY) {
            JsonList newList = new JsonList();
            newList.createOrInsert(iter, inJsonValue);
            if (index >= this.list.size()) {
                this.list.add(newList);
            } else {
                this.list.set(index, newList);
            }
            return this;
        }
        JsonList newList = (JsonList)oldJsonValue;
        return newList.createOrInsert(iter, inJsonValue);
    }

    void addToList(JsonValue keyValue) {
        this.list.add(keyValue);
    }

    void delete(Iterator<FieldSegment> iter) {
        FieldSegment field = iter.next();
        if (field == null) {
            return;
        }
        int index = field.getIndexSegment().getIndex();
        JsonValue kv = this.getJsonValueAt(index);
        if (kv == null) {
            return;
        }
        if (field.isLastPath()) {
            this.list.remove(kv);
        }
        if (field.isMap()) {
            if (kv.getType() != Value.Type.MAP) {
                return;
            }
            ((JsonDocument)kv).delete(iter);
        }
        if (kv.getType() != Value.Type.ARRAY) {
            return;
        }
        JsonList l = (JsonList)kv;
        l.delete(iter);
    }

    JsonValue getJsonValueAt(int index) {
        return this.list.size() <= index ? null : this.list.get(index);
    }

    JsonValue getJsonValueAt(Iterator<FieldSegment> iter) {
        FieldSegment field = iter.next();
        if (field == null) {
            return null;
        }
        int index = field.getIndexSegment().getIndex();
        JsonValue kv = this.getJsonValueAt(index);
        if (kv == null) {
            return null;
        }
        if (field.isLastPath()) {
            return kv;
        }
        if (field.isMap()) {
            if (kv.getType() != Value.Type.MAP) {
                return null;
            }
            return ((JsonDocument)kv).getKeyValueAt(iter);
        }
        if (kv.getType() != Value.Type.ARRAY) {
            return null;
        }
        return ((JsonList)kv).getJsonValueAt(iter);
    }

    @Override
    JsonList shallowCopy() {
        JsonList rec = new JsonList();
        rec.list = this.list;
        rec.objValue = this.objValue;
        rec.jsonValue = this.jsonValue;
        return rec;
    }

    List<JsonValue> getRootList() {
        return this.list;
    }

    class JsonListIterator
    implements ListIterator<Object> {
        final ListIterator<JsonValue> iter;

        public JsonListIterator(int index) {
            this.iter = JsonList.this.list.listIterator(index);
        }

        public JsonListIterator() {
            this.iter = JsonList.this.list.listIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Object next() {
            JsonValue kv = this.iter.next();
            if (kv != null) {
                return kv.getObject();
            }
            return null;
        }

        @Override
        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        @Override
        public Object previous() {
            JsonValue kv = this.iter.previous();
            if (kv != null) {
                return kv.getObject();
            }
            return null;
        }

        @Override
        public int nextIndex() {
            return this.iter.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iter.previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object e) {
            throw new UnsupportedOperationException();
        }
    }
}

