/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.json.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import org.ojai.DocumentReader;
import org.ojai.Value;
import org.ojai.base.DocumentReaderBase;
import org.ojai.exceptions.TypeException;
import org.ojai.json.impl.JsonDocument;
import org.ojai.json.impl.JsonList;
import org.ojai.json.impl.JsonValue;
import org.ojai.json.impl.JsonValueBuilder;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.ojai.util.Types;

class JsonDOMDocumentReader
extends DocumentReaderBase {
    private Stack<IteratorWithType> stateStack = new Stack();
    private IteratorWithType currentItr = null;
    private DocumentReader.EventType nextEvent = null;
    private DocumentReader.EventType currentEvent = null;
    private JsonValue jsonValue;

    JsonDOMDocumentReader(JsonValue value) {
        this.jsonValue = value;
        Value.Type type = value.getType();
        this.nextEvent = Types.getEventTypeForType(type);
        if (!type.isScalar()) {
            this.stateStack.push(new IteratorWithType(value));
        }
    }

    private void processNextNode() {
        if (this.stateStack.empty()) {
            this.nextEvent = null;
            return;
        }
        this.currentItr = this.stateStack.peek();
        if (this.currentItr.hasNext()) {
            Object o = this.currentItr.next();
            this.jsonValue = this.inMap() ? (JsonValue)((Map.Entry)o).getValue() : JsonValueBuilder.initFromObject(o);
            this.nextEvent = Types.getEventTypeForType(this.jsonValue.getType());
            if (!this.jsonValue.getType().isScalar()) {
                this.stateStack.push(new IteratorWithType(this.jsonValue));
            }
        } else {
            IteratorWithType iter = this.stateStack.pop();
            this.jsonValue = iter.getValue();
            this.nextEvent = iter.getType() == Value.Type.MAP ? DocumentReader.EventType.END_MAP : DocumentReader.EventType.END_ARRAY;
            this.currentItr = this.stateStack.isEmpty() ? null : this.stateStack.peek();
        }
    }

    @Override
    public DocumentReader.EventType next() {
        this.currentEvent = null;
        if (this.nextEvent != null) {
            this.currentEvent = this.nextEvent;
            this.nextEvent = null;
        } else {
            this.processNextNode();
            this.currentEvent = this.nextEvent;
            this.nextEvent = null;
        }
        return this.currentEvent;
    }

    private void checkEventType(DocumentReader.EventType event) throws TypeException {
        if (this.currentEvent != event) {
            throw new TypeException(String.format("Event type mismatch. The operation requires %s, but found %s", new Object[]{event, this.currentEvent}));
        }
    }

    @Override
    public boolean inMap() {
        return this.currentItr == null || this.currentItr.getType() == Value.Type.MAP;
    }

    @Override
    public int getArrayIndex() {
        if (this.inMap()) {
            throw new IllegalStateException("Not traversing an array!");
        }
        return this.currentItr.previousIndex();
    }

    @Override
    public String getFieldName() {
        if (!this.inMap()) {
            throw new IllegalStateException("Not traversing a map!");
        }
        return this.jsonValue.getKey();
    }

    @Override
    public byte getByte() {
        this.checkEventType(DocumentReader.EventType.BYTE);
        return this.jsonValue.getByte();
    }

    @Override
    public short getShort() {
        this.checkEventType(DocumentReader.EventType.SHORT);
        return this.jsonValue.getShort();
    }

    @Override
    public int getInt() {
        this.checkEventType(DocumentReader.EventType.INT);
        return this.jsonValue.getInt();
    }

    @Override
    public long getLong() {
        this.checkEventType(DocumentReader.EventType.LONG);
        return this.jsonValue.getLong();
    }

    @Override
    public float getFloat() {
        this.checkEventType(DocumentReader.EventType.FLOAT);
        return this.jsonValue.getFloat();
    }

    @Override
    public double getDouble() {
        this.checkEventType(DocumentReader.EventType.DOUBLE);
        return this.jsonValue.getDouble();
    }

    @Override
    public BigDecimal getDecimal() {
        this.checkEventType(DocumentReader.EventType.DECIMAL);
        return this.jsonValue.getDecimal();
    }

    @Override
    public int getDecimalPrecision() {
        BigDecimal d = this.getDecimal();
        if (d != null) {
            return d.precision();
        }
        return 0;
    }

    @Override
    public int getDecimalScale() {
        BigDecimal d = this.getDecimal();
        if (d != null) {
            return d.scale();
        }
        return 0;
    }

    @Override
    public int getDecimalValueAsInt() {
        BigDecimal d = this.getDecimal();
        if (d != null) {
            return d.intValueExact();
        }
        return 0;
    }

    @Override
    public long getDecimalValueAsLong() {
        BigDecimal d = this.getDecimal();
        if (d != null) {
            return d.longValueExact();
        }
        return 0L;
    }

    @Override
    public ByteBuffer getDecimalValueAsBytes() {
        BigDecimal decimal = this.getDecimal();
        if (decimal != null) {
            BigInteger decimalInteger = decimal.unscaledValue();
            byte[] bytearray = decimalInteger.toByteArray();
            return ByteBuffer.wrap(bytearray);
        }
        return null;
    }

    @Override
    public boolean getBoolean() {
        this.checkEventType(DocumentReader.EventType.BOOLEAN);
        return this.jsonValue.getBoolean();
    }

    @Override
    public String getString() {
        this.checkEventType(DocumentReader.EventType.STRING);
        return this.jsonValue.getString();
    }

    @Override
    public long getTimestampLong() {
        this.checkEventType(DocumentReader.EventType.TIMESTAMP);
        return this.jsonValue.getTimestampAsLong();
    }

    @Override
    public OTimestamp getTimestamp() {
        this.checkEventType(DocumentReader.EventType.TIMESTAMP);
        return this.jsonValue.getTimestamp();
    }

    @Override
    public int getDateInt() {
        this.checkEventType(DocumentReader.EventType.DATE);
        return this.jsonValue.getDateAsInt();
    }

    @Override
    public ODate getDate() {
        this.checkEventType(DocumentReader.EventType.DATE);
        return this.jsonValue.getDate();
    }

    @Override
    public int getTimeInt() {
        this.checkEventType(DocumentReader.EventType.TIME);
        return this.jsonValue.getTimeAsInt();
    }

    @Override
    public OTime getTime() {
        this.checkEventType(DocumentReader.EventType.TIME);
        return this.jsonValue.getTime();
    }

    @Override
    public OInterval getInterval() {
        this.checkEventType(DocumentReader.EventType.INTERVAL);
        return this.jsonValue.getInterval();
    }

    @Override
    public int getIntervalDays() {
        return this.getInterval().getDays();
    }

    @Override
    public long getIntervalMillis() {
        return this.getInterval().getTimeInMillis();
    }

    @Override
    public ByteBuffer getBinary() {
        this.checkEventType(DocumentReader.EventType.BINARY);
        return this.jsonValue.getBinary();
    }

    @Override
    public DocumentReader.EventType getCurrentEvent() {
        return this.currentEvent;
    }

    private class IteratorWithType
    implements ListIterator<Object> {
        final Iterator<?> i;
        final JsonValue value;

        IteratorWithType(JsonValue value) {
            this.value = value;
            this.i = value.getType() == Value.Type.MAP ? ((JsonDocument)value).iterator() : ((JsonList)value).listIterator();
        }

        public JsonValue getValue() {
            return this.value;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public Object next() {
            return this.i.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return (this.getType() == Value.Type.ARRAY ? "ListIterator@" : "MapIterator@") + this.hashCode();
        }

        Value.Type getType() {
            return this.value.getType();
        }

        @Override
        public boolean hasPrevious() {
            this.checkList();
            return ((ListIterator)this.i).hasPrevious();
        }

        @Override
        public Object previous() {
            this.checkList();
            return ((ListIterator)this.i).previous();
        }

        @Override
        public int nextIndex() {
            this.checkList();
            return ((ListIterator)this.i).nextIndex();
        }

        @Override
        public int previousIndex() {
            this.checkList();
            return ((ListIterator)this.i).previousIndex();
        }

        @Override
        public void set(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object e) {
            throw new UnsupportedOperationException();
        }

        private void checkList() {
            if (this.getType() != Value.Type.ARRAY) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

