/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.json;

import java.util.IdentityHashMap;
import org.ojai.exceptions.OjaiException;

public class JsonOptions
implements Cloneable {
    public static final JsonOptions DEFAULT;
    public static final JsonOptions WITH_TAGS;
    public static final JsonOptions WITHOUT_TAGS;
    private static final IdentityHashMap<JsonOptions, Boolean> constants;
    private boolean pretty = false;
    private boolean withTags = false;

    public boolean isPretty() {
        return this.pretty;
    }

    public JsonOptions setPretty(boolean pretty) {
        this.checkMutationOfConstants();
        this.pretty = pretty;
        return this;
    }

    public JsonOptions pretty() {
        this.checkMutationOfConstants();
        this.pretty = true;
        return this;
    }

    public JsonOptions compact() {
        this.checkMutationOfConstants();
        this.pretty = false;
        return this;
    }

    public boolean isWithTags() {
        return this.withTags;
    }

    public JsonOptions setWithTags(boolean withTags) {
        this.checkMutationOfConstants();
        this.withTags = withTags;
        return this;
    }

    public JsonOptions withTags() {
        this.checkMutationOfConstants();
        this.withTags = true;
        return this;
    }

    public JsonOptions withoutTags() {
        this.checkMutationOfConstants();
        this.withTags = false;
        return this;
    }

    private void checkMutationOfConstants() {
        if (constants.containsKey(this)) {
            throw new UnsupportedOperationException("Can not modify constants options.");
        }
    }

    public String toString() {
        return "{\"pretty\":" + this.pretty + ", \"withTags\":" + this.withTags + "}";
    }

    public JsonOptions clone() {
        try {
            return (JsonOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new OjaiException(e);
        }
    }

    static {
        constants = new IdentityHashMap();
        DEFAULT = new JsonOptions();
        constants.put(DEFAULT, true);
        WITH_TAGS = new JsonOptions().withTags();
        constants.put(WITH_TAGS, true);
        WITHOUT_TAGS = new JsonOptions().withoutTags();
        constants.put(WITHOUT_TAGS, true);
    }
}

