/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.base;

import java.util.Iterator;
import org.ojai.Document;
import org.ojai.DocumentListener;
import org.ojai.DocumentReader;
import org.ojai.DocumentStream;
import org.ojai.exceptions.OjaiException;

public abstract class DocumentStreamBase
implements DocumentStream {
    protected boolean isUsed;
    private boolean isClosed;

    protected abstract Iterator<Document> iteratorDerived();

    protected void closeDerived() throws OjaiException {
    }

    protected void checkOpen() {
        if (this.isClosed) {
            throw new IllegalStateException("DocumentStream is already closed.");
        }
    }

    protected void checkAndSetInUse() {
        this.checkOpen();
        if (this.isUsed) {
            throw new IllegalStateException("DocumentStream is already in use.");
        }
        this.isUsed = true;
    }

    protected boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public final Iterator<Document> iterator() {
        this.checkAndSetInUse();
        return this.iteratorDerived();
    }

    @Override
    public final void close() throws OjaiException {
        if (this.isClosed) {
            return;
        }
        this.closeDerived();
        this.isClosed = true;
    }

    protected Iterable<DocumentReader> documentReadersDerived() {
        return new ReaderIterable(this.iteratorDerived());
    }

    @Override
    public final Iterable<DocumentReader> documentReaders() {
        this.checkAndSetInUse();
        return this.documentReadersDerived();
    }

    @Override
    public void streamTo(DocumentListener docListener) {
        try {
            for (Document doc : this) {
                docListener.documentArrived(doc);
            }
            docListener.eos();
        }
        catch (Exception ex) {
            docListener.failed(ex);
        }
    }

    private class ReaderIterable
    implements Iterable<DocumentReader> {
        private final Iterator<Document> docIter;

        public ReaderIterable(Iterator<Document> docIter) {
            this.docIter = docIter;
        }

        @Override
        public Iterator<DocumentReader> iterator() {
            return new ReaderIterator(this.docIter);
        }
    }

    private static class ReaderIterator
    implements Iterator<DocumentReader> {
        private final Iterator<Document> docIter;

        public ReaderIterator(Iterator<Document> docIter) {
            this.docIter = docIter;
        }

        @Override
        public boolean hasNext() {
            return this.docIter.hasNext();
        }

        @Override
        public DocumentReader next() {
            return this.docIter.next().asReader();
        }
    }
}

