/*
 * Decompiled with CFR 0.152.
 */
package org.ojai;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.ojai.DocumentReader;
import org.ojai.JsonString;
import org.ojai.annotation.API;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

@API.Public
@API.NotThreadSafe
public interface Value
extends JsonString {
    public static final byte TYPE_CODE_NULL = 1;
    public static final byte TYPE_CODE_BOOLEAN = 2;
    public static final byte TYPE_CODE_STRING = 3;
    public static final byte TYPE_CODE_BYTE = 4;
    public static final byte TYPE_CODE_SHORT = 5;
    public static final byte TYPE_CODE_INT = 6;
    public static final byte TYPE_CODE_LONG = 7;
    public static final byte TYPE_CODE_FLOAT = 8;
    public static final byte TYPE_CODE_DOUBLE = 9;
    public static final byte TYPE_CODE_DECIMAL = 10;
    public static final byte TYPE_CODE_DATE = 11;
    public static final byte TYPE_CODE_TIME = 12;
    public static final byte TYPE_CODE_TIMESTAMP = 13;
    public static final byte TYPE_CODE_INTERVAL = 14;
    public static final byte TYPE_CODE_BINARY = 15;
    public static final byte TYPE_CODE_MAP = 16;
    public static final byte TYPE_CODE_ARRAY = 17;
    public static final String TAG_BINARY = "$binary";
    public static final String TAG_INTERVAL = "$interval";
    public static final String TAG_TIMESTAMP = "$date";
    public static final String TAG_TIME = "$time";
    public static final String TAG_DATE = "$dateDay";
    public static final String TAG_DECIMAL = "$decimal";
    public static final String TAG_LONG = "$numberLong";
    public static final String TAG_BYTE = "$numberByte";
    public static final String TAG_SHORT = "$numberShort";
    public static final String TAG_INT = "$numberInt";
    public static final String TAG_FLOAT = "$numberFloat";

    public Type getType();

    public byte getByte();

    public short getShort();

    public int getInt();

    public long getLong();

    public float getFloat();

    public double getDouble();

    public BigDecimal getDecimal();

    public boolean getBoolean();

    public String getString();

    public OTimestamp getTimestamp();

    public long getTimestampAsLong();

    public ODate getDate();

    public int getDateAsInt();

    public OTime getTime();

    public int getTimeAsInt();

    public OInterval getInterval();

    public long getIntervalAsLong();

    public ByteBuffer getBinary();

    public Map<String, Object> getMap();

    public List<Object> getList();

    public Object getObject();

    public DocumentReader asReader();

    public static enum Type {
        NULL(1),
        BOOLEAN(2),
        STRING(3),
        BYTE(4, "$numberByte"),
        SHORT(5, "$numberShort"),
        INT(6, "$numberInt"),
        LONG(7, "$numberLong"),
        FLOAT(8, "$numberFloat"),
        DOUBLE(9),
        DECIMAL(10, "$decimal"),
        DATE(11, "$dateDay"),
        TIME(12, "$time"),
        TIMESTAMP(13, "$date"),
        INTERVAL(14, "$interval"),
        BINARY(15, "$binary"),
        MAP(16),
        ARRAY(17);

        private final byte code;
        private final String tagName;

        private Type(int code) {
            this(code, null);
        }

        private Type(int code, String tagName) {
            this.code = (byte)code;
            this.tagName = tagName;
        }

        public byte getCode() {
            return this.code;
        }

        public String getTagName() {
            return this.tagName;
        }

        public boolean isIntrinsic() {
            return this.tagName == null;
        }

        public boolean isScalar() {
            return this != MAP && this != ARRAY;
        }

        public boolean isNumeric() {
            return this.code >= Type.BYTE.code && this.code <= Type.DECIMAL.code;
        }

        public static Type valueOf(int typeCode) {
            switch (typeCode) {
                case 1: {
                    return NULL;
                }
                case 2: {
                    return BOOLEAN;
                }
                case 3: {
                    return STRING;
                }
                case 4: {
                    return BYTE;
                }
                case 5: {
                    return SHORT;
                }
                case 6: {
                    return INT;
                }
                case 7: {
                    return LONG;
                }
                case 8: {
                    return FLOAT;
                }
                case 9: {
                    return DOUBLE;
                }
                case 10: {
                    return DECIMAL;
                }
                case 11: {
                    return DATE;
                }
                case 12: {
                    return TIME;
                }
                case 13: {
                    return TIMESTAMP;
                }
                case 14: {
                    return INTERVAL;
                }
                case 15: {
                    return BINARY;
                }
                case 16: {
                    return MAP;
                }
                case 17: {
                    return ARRAY;
                }
            }
            return null;
        }
    }
}

