/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.impl.Constants;
import com.mapr.db.impl.MapRDBTableImplHelper;
import com.mapr.db.ojai.DBFieldProjector;
import com.mapr.db.rowcol.ArrayIndexDescriptor;
import com.mapr.db.rowcol.BaseSerializationContext;
import com.mapr.db.rowcol.ByteWriter;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBValueBuilder;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.DBValueWithTSBuilder;
import com.mapr.db.rowcol.InsertContext;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.SerializationAction;
import com.mapr.db.rowcol.SerializedFamilyInfo;
import com.mapr.db.rowcol.TimeAndUniq;
import com.mapr.db.rowcol.TimeDescriptor;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.ojai.DocumentReader;
import org.ojai.FieldPath;
import org.ojai.FieldSegment;
import org.ojai.Value;
import org.ojai.util.impl.MutableFieldSegment;

public class SerializationContext
extends BaseSerializationContext {
    byte flags;
    DBDocumentImpl rec;
    Map<FieldPath, Integer> jsonPathMap;
    private KeyValue currentKV;
    private FamilyInfo[] familyInfoList;
    private int lastSearchIndex = -1;
    private boolean fullRecordOp = false;
    private boolean hasMutation = false;
    private boolean storeRowTS = false;
    private boolean decodeTimestamp = false;
    private boolean preserveDeleteTime = false;
    private boolean checkFieldName = true;
    TimeAndUniq baseTime;
    TimeAndUniq[] baseCudTimes;
    TimeAndUniq[] cudTimes;
    TimeDescriptor.TimeStampState[] baseCudTimeStates;
    TimeDescriptor.TimeStampState[] cudTimeStates;
    TimeAndUniq arrayIndexTime;
    byte[] arrayIndexUniqTime;
    private boolean hasDeletes = false;
    private ArrayIndexDescriptor.ArrayIndexType indexType;
    private int arrayIndex;
    private DBValueBuilder builder = null;
    private DBFieldProjector curProjector = null;
    private Map<Integer, DBFieldProjector> projectors = null;
    private FieldPath currentPath = null;
    private boolean shouldPrunePaths = false;

    public SerializationContext setHasDeletes(boolean v) {
        this.hasDeletes = v;
        return this;
    }

    public boolean hasDeletes() {
        return this.hasDeletes;
    }

    public SerializationContext setPreserveDeleteTime(boolean v) {
        this.preserveDeleteTime = v;
        return this;
    }

    public boolean preserveDeleteTime() {
        return this.preserveDeleteTime;
    }

    public SerializationContext setDecodeTimestamp(boolean v) {
        int i;
        this.decodeTimestamp = v;
        if (!this.decodeTimestamp) {
            return this;
        }
        this.baseCudTimes = new TimeAndUniq[3];
        for (i = 0; i < 3; ++i) {
            this.baseCudTimes[i] = new TimeAndUniq();
        }
        this.cudTimes = new TimeAndUniq[3];
        for (i = 0; i < 3; ++i) {
            this.cudTimes[i] = new TimeAndUniq();
        }
        this.baseCudTimeStates = new TimeDescriptor.TimeStampState[3];
        for (i = 0; i < 3; ++i) {
            this.baseCudTimeStates[i] = TimeDescriptor.TimeStampState.NOT_SET;
        }
        this.cudTimeStates = new TimeDescriptor.TimeStampState[3];
        for (i = 0; i < 3; ++i) {
            this.cudTimeStates[i] = TimeDescriptor.TimeStampState.NOT_SET;
        }
        return this;
    }

    public boolean getDecodeTimestamp() {
        return this.decodeTimestamp;
    }

    public boolean isAbsoluteIndex() {
        return this.indexType == ArrayIndexDescriptor.ArrayIndexType.ARRAY_INDEX_TYPE_ABSOLUTE;
    }

    public SerializationContext setIndexType(ArrayIndexDescriptor.ArrayIndexType type) {
        this.indexType = type;
        return this;
    }

    public ArrayIndexDescriptor.ArrayIndexType getIndexType() {
        return this.indexType;
    }

    public SerializationContext setArrayIndex(int i) {
        this.arrayIndex = i;
        return this;
    }

    public int getArrayIndex() {
        return this.arrayIndex;
    }

    public TimeAndUniq getArrayIndexTime() {
        return this.arrayIndexTime;
    }

    SerializationContext setupFamilyList(DBDocumentImpl r, Map<FieldPath, Integer> jsonPathMap) {
        assert (jsonPathMap.size() > 0);
        this.jsonPathMap = jsonPathMap;
        this.rec = r;
        this.familyInfoList = new FamilyInfo[jsonPathMap.size()];
        int i = 0;
        for (Map.Entry<FieldPath, Integer> kv : jsonPathMap.entrySet()) {
            this.familyInfoList[i++] = this.setupFamilyInfo(kv.getKey(), kv.getValue());
        }
        return this;
    }

    private FamilyInfo setupFamilyInfo(FieldPath path, int id) {
        FamilyInfo info = new FamilyInfo();
        KeyValue kv = null;
        KeyValue lastParentKV = this.rec;
        InsertContext.OpType opType = InsertContext.OpType.NONE;
        if (path.equals((Object)FieldPath.EMPTY)) {
            kv = this.rec;
        } else {
            String key;
            KeyValue tmpkv;
            FieldSegment field;
            Iterator iter = path.iterator();
            DBDocumentImpl curRec = this.rec;
            while ((field = (FieldSegment)iter.next()) != null && (tmpkv = curRec.map.get(key = field.getNameSegment().getName())) != null) {
                if (tmpkv.opType != InsertContext.OpType.NONE.ordinal()) {
                    assert (opType == InsertContext.OpType.NONE);
                    opType = InsertContext.OpType.valueOf(tmpkv.opType);
                }
                if (field.isLastPath()) {
                    kv = tmpkv;
                    break;
                }
                lastParentKV = tmpkv;
                if (tmpkv.getType() != Value.Type.MAP) {
                    kv = null;
                    break;
                }
                curRec = (DBDocumentImpl)tmpkv;
            }
        }
        info.rootKV = kv;
        info.parentKV = lastParentKV;
        info.familyId = id;
        info.jsonPath = path;
        info.opType = opType;
        if (kv != null) {
            info.writer = new ByteWriter();
            kv.setRootOfColumnFamily(true);
            kv.setCFRootId(id);
        }
        return info;
    }

    public SerializedFamilyInfo[] getSerializedBuffers(Map<FieldPath, Integer> jsonPathMap, Map<Integer, ByteBuffer> cachedBufferMap) {
        assert (jsonPathMap.size() > 0);
        assert (cachedBufferMap.size() > 0);
        TreeMap<Integer, FamilyInfo> famInfoMap = new TreeMap<Integer, FamilyInfo>();
        for (Map.Entry<FieldPath, Integer> kv : jsonPathMap.entrySet()) {
            famInfoMap.put(kv.getValue(), new FamilyInfo(kv.getValue(), kv.getKey(), cachedBufferMap.get(kv.getValue())));
        }
        SerializedFamilyInfo[] famInfos = new FamilyInfo[famInfoMap.size()];
        int i = 0;
        for (Map.Entry fi : famInfoMap.entrySet()) {
            famInfos[i++] = (FamilyInfo)fi.getValue();
        }
        return famInfos;
    }

    public SerializationContext serializeFamilies(DBDocumentImpl r, Map<FieldPath, Integer> jsonPathMap) {
        this.setupFamilyList(r, jsonPathMap);
        if (this.isFullRecordOp()) {
            TimeDescriptor.setCreateTimeValid(r);
            TimeDescriptor.setUpdateTimeValid(r);
            TimeDescriptor.setDeleteTimeValid(r);
        }
        for (int i = 0; i < this.familyInfoList.length; ++i) {
            FamilyInfo info = this.familyInfoList[i];
            if (info.rootKV == null) {
                if (this.isFullRecordOp()) {
                    info.action = SerializationAction.DELETE_FAMILY;
                    continue;
                }
                if (info.parentKV.getType() != Value.Type.MAP) {
                    info.action = SerializationAction.DELETE_FAMILY;
                    continue;
                }
                if (info.opType == InsertContext.OpType.NONE) {
                    info.action = SerializationAction.NO_ACTION;
                    continue;
                }
                if (info.opType != InsertContext.OpType.MERGE) {
                    info.action = SerializationAction.DELETE_FAMILY;
                    continue;
                }
                info.action = SerializationAction.NO_ACTION;
                continue;
            }
            info.action = SerializationAction.SET;
            if (info.jsonPath.equals((Object)FieldPath.EMPTY)) {
                this.rec.serializeToRowCol(info.writer, this);
            } else {
                DBDocumentImpl dummyRoot = new DBDocumentImpl();
                if (this.isFullRecordOp()) {
                    TimeDescriptor.setCreateTimeValid(dummyRoot);
                    TimeDescriptor.setUpdateTimeValid(dummyRoot);
                    TimeDescriptor.setDeleteTimeValid(dummyRoot);
                } else {
                    switch (info.opType) {
                        case NONE: {
                            if (TimeDescriptor.isCreateTimeValid(info.rootKV)) {
                                TimeDescriptor.setCreateTimeValid(dummyRoot);
                            }
                            if (TimeDescriptor.isUpdateTimeValid(info.rootKV)) {
                                TimeDescriptor.setUpdateTimeValid(dummyRoot);
                            }
                            if (!TimeDescriptor.isDeleteTimeValid(info.rootKV)) break;
                            TimeDescriptor.setDeleteTimeValid(dummyRoot);
                            break;
                        }
                        case DELETE: {
                            assert (TimeDescriptor.isDeleteTimeValid(info.rootKV));
                            assert (!TimeDescriptor.isCreateTimeValid(info.rootKV));
                            assert (TimeDescriptor.isUpdateTimeValid(info.rootKV));
                            TimeDescriptor.setUpdateTimeValid(dummyRoot);
                            TimeDescriptor.setDeleteTimeValid(dummyRoot);
                            break;
                        }
                        case MERGE: 
                        case APPEND: 
                        case INCREMENT: {
                            assert (!TimeDescriptor.isDeleteTimeValid(info.rootKV));
                            assert (TimeDescriptor.isCreateTimeValid(info.rootKV));
                            assert (TimeDescriptor.isUpdateTimeValid(info.rootKV));
                            TimeDescriptor.setCreateTimeValid(dummyRoot);
                            TimeDescriptor.setUpdateTimeValid(dummyRoot);
                            break;
                        }
                        case SET: 
                        case SET_OR_REPLACE: {
                            assert (TimeDescriptor.isCreateTimeValid(info.rootKV));
                            assert (TimeDescriptor.isUpdateTimeValid(info.rootKV));
                            TimeDescriptor.setCreateTimeValid(dummyRoot);
                            TimeDescriptor.setUpdateTimeValid(dummyRoot);
                            TimeDescriptor.setDeleteTimeValid(dummyRoot);
                        }
                    }
                }
                this.currentKV = info.rootKV.shallowCopy();
                this.currentKV.timeDescriptor = info.rootKV.timeDescriptor;
                this.currentKV.opType = info.rootKV.opType;
                this.currentKV.setRootOfColumnFamily(false);
                dummyRoot.map.put("v", this.currentKV);
                this.hasMutation = false;
                dummyRoot.serializeToRowCol(info.writer, this);
            }
            if (this.isFullRecordOp() || this.hasMutation || info.opType != InsertContext.OpType.NONE) continue;
            info.action = SerializationAction.NO_ACTION;
            info.writer = null;
        }
        return this;
    }

    public SerializedFamilyInfo[] getSerializedBuffers() {
        return this.familyInfoList;
    }

    boolean isFamilyRoot(KeyValue kv) {
        if (this.familyInfoList == null || this.currentKV == kv) {
            return false;
        }
        for (int i = 1; i <= this.familyInfoList.length; ++i) {
            int index = (i + this.lastSearchIndex) % this.familyInfoList.length;
            if (this.familyInfoList[index].rootKV != kv) continue;
            this.lastSearchIndex = i;
            return true;
        }
        return false;
    }

    public SerializationContext setHasArrayProjection() {
        this.flags = 1;
        return this;
    }

    public boolean hasArrayProjection() {
        return this.flags != 0;
    }

    public SerializationContext setFullRecordOp(boolean v) {
        this.fullRecordOp = v;
        return this;
    }

    public boolean isFullRecordOp() {
        return this.fullRecordOp;
    }

    public SerializationContext setHasMutation(boolean v) {
        this.hasMutation = v;
        return this;
    }

    public boolean hasMutation() {
        return this.hasMutation;
    }

    private boolean pathIsOwner(String pathSoFar, FieldPath cfPath, Map<FieldPath, Integer> jsonPathMap) {
        FieldPath curPath = FieldPath.parseFrom((String)pathSoFar);
        Integer idx = jsonPathMap.get(curPath);
        return idx == null || cfPath.equals((Object)curPath);
    }

    DBDocumentImpl decode(Map<Integer, ByteBuffer> map, Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap, Map<String, FieldPath> fieldPathMap, DBDocumentImpl rec) {
        this.builder = this.decodeTimestamp ? DBValueWithTSBuilder.keyValueWithTSBuilder : DBValueBuilderImpl.KeyValueBuilder;
        Iterator<Map.Entry<FieldPath, Integer>> iter = jsonPathMap.entrySet().iterator();
        for (int i = 0; i < jsonPathMap.size(); ++i) {
            Map.Entry<FieldPath, Integer> e = iter.next();
            FieldPath path = e.getKey();
            int cfId = e.getValue();
            ByteBuffer buf = map.get(cfId);
            this.curProjector = this.getFieldProjector(cfId);
            if (this.shouldPrunePaths() && this.curProjector == null) continue;
            if (i == 0) {
                if (buf == null) continue;
                rec.deserializeFromRowCol(buf, fieldPathMap, this);
                continue;
            }
            if (buf == null) continue;
            DBDocumentImpl r = new DBDocumentImpl();
            r.deserializeFromRowCol(buf, fieldPathMap, this);
            KeyValue kv = r.getKeyValue(Constants.DUMMY_FIELDPATH_V);
            if (kv == null) continue;
            kv.setRecursiveNonDefaultColumnFamily(true, cfId);
            rec.set(path, (Value)kv);
            Iterator fpiter = path.iterator();
            String pathSoFar = null;
            while (fpiter.hasNext()) {
                FieldSegment field = (FieldSegment)fpiter.next();
                String thisKey = field.getNameSegment().getName();
                boolean ret = this.pathIsOwner(pathSoFar = pathSoFar == null ? thisKey : pathSoFar + "." + thisKey, path, jsonPathMap);
                if (!ret) continue;
                KeyValue rkv = rec.getKeyValue(pathSoFar);
                rkv.setPartOfNonDefaultColumnFamily(true);
                rkv.setCFRootId(cfId);
            }
        }
        return rec;
    }

    public SerializationContext setStoreRowTS(boolean v) {
        this.storeRowTS = v;
        return this;
    }

    public boolean storeRowTS() {
        return this.storeRowTS;
    }

    public SerializationContext setBaseTime(long time, int uniq) {
        this.baseTime = new TimeAndUniq(time, uniq);
        return this;
    }

    public SerializationContext setBaseTime(TimeAndUniq t) {
        this.baseTime = t;
        return this;
    }

    public TimeAndUniq getBaseTime() {
        return this.baseTime;
    }

    public TimeAndUniq[] getBaseCudTime() {
        return this.baseCudTimes;
    }

    public TimeDescriptor.TimeStampState[] getBaseCudTimeState() {
        return this.baseCudTimeStates;
    }

    public TimeAndUniq[] getCudTime() {
        return this.cudTimes;
    }

    public TimeDescriptor.TimeStampState[] getCudTimeState() {
        return this.cudTimeStates;
    }

    public SerializationContext clearCudTimeAndStates() {
        for (int i = 0; i < 3; ++i) {
            this.cudTimes[i].setTime(0L);
            this.cudTimes[i].setUniq(0);
            this.cudTimeStates[i] = TimeDescriptor.TimeStampState.NOT_SET;
        }
        return this;
    }

    public KeyValue newKeyValue() {
        return this.builder.newDBValue();
    }

    public boolean shouldPrunePaths() {
        return this.shouldPrunePaths;
    }

    public static FieldPath[] getFieldPaths(String[] ps) {
        if (ps == null || ps.length == 0) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < ps.length; ++i) {
            set.add(ps[i]);
        }
        Object[] p = new String[set.size()];
        set.toArray(p);
        Arrays.sort(p);
        FieldPath[] fieldPaths = new FieldPath[p.length];
        for (int i = 0; i < p.length; ++i) {
            fieldPaths[i] = FieldPath.parseFrom((String)p[i]);
        }
        return fieldPaths;
    }

    public DBFieldProjector getFieldProjector(int cfId) {
        if (this.shouldPrunePaths()) {
            return this.projectors.get(cfId);
        }
        return null;
    }

    public SerializationContext setProjectedPaths(FieldPath[] fieldPaths, Map<FieldPath, Integer> cfJsonPathMap) {
        if (fieldPaths == null || fieldPaths.length == 0) {
            this.curProjector = null;
            this.projectors = null;
            this.shouldPrunePaths = false;
        } else {
            this.projectors = new TreeMap<Integer, DBFieldProjector>();
            Map<Integer, List<FieldPath>> perCFQuals = MapRDBTableImplHelper.getMultipleCFQualifiers(cfJsonPathMap, true, fieldPaths);
            for (Map.Entry<Integer, List<FieldPath>> cfQuals : perCFQuals.entrySet()) {
                List<FieldPath> fpList = cfQuals.getValue();
                DBFieldProjector cfProj = new DBFieldProjector(fpList.toArray(new FieldPath[fpList.size()])).reset();
                this.projectors.put(cfQuals.getKey(), cfProj);
            }
            this.shouldPrunePaths = true;
        }
        return this;
    }

    public SerializationContext setProjectedPaths(String[] ps, Map<FieldPath, Integer> cfJsonPathMap) {
        if (ps != null && ps.length != 0) {
            this.shouldPrunePaths = true;
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < ps.length; ++i) {
                set.add(ps[i]);
            }
            Object[] p = new String[set.size()];
            set.toArray(p);
            Arrays.sort(p);
            FieldPath[] paths = new FieldPath[p.length];
            for (int i = 0; i < p.length; ++i) {
                paths[i] = FieldPath.parseFrom((String)p[i]);
            }
            return this.setProjectedPaths(paths, cfJsonPathMap);
        }
        this.curProjector = null;
        this.shouldPrunePaths = false;
        return this;
    }

    public void moveToNextField(MutableFieldSegment fieldSegment, DocumentReader.EventType event) {
        this.curProjector.moveTo(fieldSegment, event);
    }

    public boolean shouldIncludeField() {
        if (this.curProjector != null) {
            assert (this.shouldPrunePaths());
            return this.curProjector.shouldEmitEvent();
        }
        return true;
    }

    public boolean projectionComplete() {
        if (this.curProjector != null) {
            return this.curProjector.isDone();
        }
        return false;
    }

    public SerializationContext setCurrentPath(FieldPath p) {
        this.currentPath = p;
        return this;
    }

    public FieldPath currentPath() {
        return this.currentPath;
    }

    public boolean isCheckFieldName() {
        return this.checkFieldName;
    }

    public SerializationContext setCheckFieldName(boolean checkFieldName) {
        this.checkFieldName = checkFieldName;
        return this;
    }

    class FamilyInfo
    implements SerializedFamilyInfo {
        KeyValue rootKV;
        int familyId;
        ByteWriter writer;
        FieldPath jsonPath;
        ByteBuffer cachedBuffer;
        InsertContext.OpType parentOpType;
        public InsertContext.OpType opType;
        public SerializationAction action;
        public KeyValue parentKV;

        public FamilyInfo() {
        }

        public FamilyInfo(int familyId, FieldPath jsonPath, ByteBuffer cachedBuffer) {
            this.familyId = familyId;
            this.jsonPath = jsonPath;
            this.cachedBuffer = cachedBuffer;
            this.action = this.cachedBuffer == null ? SerializationAction.NO_ACTION : SerializationAction.SET;
        }

        @Override
        public int getFamilyId() {
            return this.familyId;
        }

        @Override
        public SerializationAction getAction() {
            return this.action;
        }

        @Override
        public ByteBuffer getByteBuffer() {
            if (this.cachedBuffer != null) {
                return this.cachedBuffer;
            }
            if (this.writer == null) {
                return null;
            }
            return this.writer.getByteBuffer();
        }
    }
}

