/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.rowcol.DBList;
import com.mapr.db.rowcol.DBValueBuilderBase;
import com.mapr.db.rowcol.InsertContext;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.KeyValueWithTS;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import org.ojai.Value;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

public class DBValueWithTSBuilder
extends DBValueBuilderBase {
    public static DBValueWithTSBuilder keyValueWithTSBuilder = new DBValueWithTSBuilder();

    private DBValueWithTSBuilder() {
    }

    @Override
    public KeyValueWithTS newDBValue() {
        return new KeyValueWithTS();
    }

    @Override
    public KeyValueWithTS initFrom(boolean value) {
        KeyValueWithTS v = new KeyValueWithTS(Value.Type.BOOLEAN);
        v.setPrimValue(value ? 1L : 0L);
        return v;
    }

    @Override
    public KeyValueWithTS initFrom(String value) {
        KeyValueWithTS v = new KeyValueWithTS(Value.Type.STRING);
        v.setObjValue(value);
        return v;
    }

    @Override
    public KeyValueWithTS initFrom(byte value) {
        KeyValueWithTS v = new KeyValueWithTS(Value.Type.BYTE);
        v.setPrimValue(value);
        return v;
    }

    @Override
    public KeyValueWithTS initFrom(short value) {
        KeyValueWithTS v = new KeyValueWithTS(Value.Type.SHORT);
        v.setPrimValue(value);
        return v;
    }

    @Override
    public KeyValueWithTS initFrom(int value) {
        KeyValueWithTS v = new KeyValueWithTS(Value.Type.INT);
        v.setPrimValue(value);
        return v;
    }

    @Override
    public KeyValueWithTS initFrom(long value) {
        KeyValueWithTS v = new KeyValueWithTS(Value.Type.LONG);
        v.setPrimValue(value);
        return v;
    }

    @Override
    public KeyValueWithTS initFrom(float value) {
        KeyValueWithTS v = new KeyValueWithTS(Value.Type.FLOAT);
        v.setPrimValue(Float.floatToIntBits(value));
        return v;
    }

    @Override
    public KeyValueWithTS initFrom(double value) {
        KeyValueWithTS v = new KeyValueWithTS(Value.Type.DOUBLE);
        v.setPrimValue(Double.doubleToLongBits(value));
        return v;
    }

    @Override
    public KeyValueWithTS initFrom(OTime value) {
        KeyValueWithTS v = new KeyValueWithTS(Value.Type.TIME);
        v.setPrimValue(value.toTimeInMillis());
        return v;
    }

    @Override
    public KeyValueWithTS initFrom(ODate value) {
        KeyValueWithTS v = new KeyValueWithTS(Value.Type.DATE);
        v.setPrimValue(value.toDaysSinceEpoch());
        return v;
    }

    @Override
    public KeyValueWithTS initFrom(BigDecimal value) {
        KeyValueWithTS v = new KeyValueWithTS(Value.Type.DECIMAL);
        v.setObjValue(value);
        return v;
    }

    @Override
    public KeyValueWithTS initFrom(OTimestamp value) {
        KeyValueWithTS v = new KeyValueWithTS(Value.Type.TIMESTAMP);
        v.setPrimValue(value.getMillis());
        return v;
    }

    @Override
    public KeyValueWithTS initFrom(OInterval value) {
        KeyValueWithTS v = new KeyValueWithTS(Value.Type.INTERVAL);
        v.setPrimValue(value.getTimeInMillis());
        return v;
    }

    @Override
    public KeyValueWithTS initFrom(ByteBuffer value) {
        KeyValueWithTS v = new KeyValueWithTS(Value.Type.BINARY);
        v.setObjValue(value.duplicate());
        return v;
    }

    @Override
    public KeyValueWithTS initFrom(List<? extends Object> list) {
        if (list instanceof DBList) {
            return ((DBList)list).shallowCopy();
        }
        DBList l = new DBList(InsertContext.OpType.NONE);
        for (Object object : list) {
            KeyValueWithTS child = (KeyValueWithTS)this.initFromObject(object);
            child.setOpTypeAndFlags(null, false);
            l.addToDBList(child);
        }
        return l;
    }

    @Override
    public KeyValue initFrom(Value value) {
        if (value instanceof KeyValueWithTS) {
            return ((KeyValueWithTS)value).shallowCopy();
        }
        return this.initFromObject(value.getObject());
    }

    @Override
    public KeyValue initFromObject(Object value) {
        if (value instanceof KeyValueWithTS) {
            return ((KeyValueWithTS)value).shallowCopy();
        }
        if (value == null) {
            return new KeyValueWithTS(Value.Type.NULL);
        }
        return this.initFromObjectType(value);
    }

    @Override
    public KeyValue initFromNull() {
        return new KeyValueWithTS(Value.Type.NULL);
    }
}

