/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.google.common.base.Preconditions;
import com.mapr.db.ControlInfo;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.ojai.DBDOMDocumentReader;
import com.mapr.db.ojai.DBDocumentReader2;
import com.mapr.db.rowcol.ByteWriter;
import com.mapr.db.rowcol.DBList;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.InsertContext;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.KeyValueDeserializeHelper;
import com.mapr.db.rowcol.KeyValuePair;
import com.mapr.db.rowcol.KeyValueSerializeHelper;
import com.mapr.db.rowcol.KeyValueWithTS;
import com.mapr.db.rowcol.RootTimeDescriptor;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.db.rowcol.SerializationAction;
import com.mapr.db.rowcol.SerializationContext;
import com.mapr.db.rowcol.SerializedFamilyInfo;
import com.mapr.db.rowcol.TimeAndUniq;
import com.mapr.db.rowcol.TimeDescriptor;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import org.ojai.Document;
import org.ojai.DocumentReader;
import org.ojai.FieldPath;
import org.ojai.FieldSegment;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.beans.BeanCodec;
import org.ojai.exceptions.TypeException;
import org.ojai.json.Json;
import org.ojai.json.JsonOptions;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.ojai.util.DocumentReaders;
import org.ojai.util.Documents;

public class DBDocumentImpl
extends KeyValueWithTS
implements Document,
Map<String, Object> {
    private static ThreadLocal<KeyValuePair> threadLocalKVPair = new ThreadLocal<KeyValuePair>(){

        @Override
        protected KeyValuePair initialValue() {
            return new KeyValuePair();
        }
    };
    LinkedHashMap<String, KeyValue> map;
    CachedBufferInfo cachedBuffer;
    KeyValue idValue;
    boolean excludeId;
    boolean hasDeletes;
    byte rootTimeDescriptor;

    public DBDocumentImpl() {
        super(Value.Type.MAP);
        this.objValue = this.map = new LinkedHashMap();
        this.cachedBuffer = null;
        this.hasDeletes = false;
    }

    void setHasDeletes(boolean v) {
        this.hasDeletes = v;
    }

    boolean hasDeletes() {
        return this.hasDeletes;
    }

    public boolean isReadOnly() {
        return false;
    }

    @API.Internal
    public void setSerializedJson(Map<Integer, ByteBuffer> familyIdToRowColDataMap, Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap, ByteBuffer rowkeyBuffer, boolean excludeId, boolean decodeTimestamp, boolean preserveDeleteFlags, String[] paths, Map<String, FieldPath> fieldPathMap) {
        this.setSerializedJson(familyIdToRowColDataMap, jsonPathMap, idToCFNameMap, rowkeyBuffer, excludeId, decodeTimestamp, preserveDeleteFlags, false, paths, fieldPathMap);
    }

    public void setSerializedJson(Map<Integer, ByteBuffer> familyIdToRowColDataMap, Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap, ByteBuffer rowkeyBuffer, boolean excludeId, boolean decodeTimestamp, boolean preserveDeleteFlags, boolean preserveDeleteTime, String[] paths, Map<String, FieldPath> fieldPathMap) {
        this.cachedBuffer = new CachedBufferInfo(familyIdToRowColDataMap, jsonPathMap, idToCFNameMap, decodeTimestamp, preserveDeleteFlags, preserveDeleteTime, paths, fieldPathMap);
        if (rowkeyBuffer != null) {
            this.setId(IdCodec.decode(rowkeyBuffer), excludeId);
        }
    }

    public Map<FieldPath, Integer> getJsonPathMap() {
        return this.cachedBuffer.jsonPathMap;
    }

    public Map<Integer, ByteBuffer> getCachedBuffers() {
        return this.cachedBuffer.map;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public ControlInfo getControlInfo(String fieldPath) {
        return this.getControlInfo(FieldPath.parseFrom((String)fieldPath));
    }

    public ControlInfo getControlInfo(FieldPath fieldPath) {
        return null;
    }

    private void checkForZeroSizeKey(String key) {
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Empty field name is not permitted in MapR-DB JSON documents.");
        }
    }

    public static void checkForArrayNotation(FieldPath fp) {
        for (FieldSegment curSegment = fp.getRootSegment(); curSegment != null; curSegment = curSegment.getChild()) {
            if (!curSegment.isIndexed() || curSegment.getIndexSegment().hasIndex()) continue;
            throw new IllegalArgumentException("[] cannot be used to get/set/delete a value in a Document");
        }
    }

    public void insertKeyValue(String key, KeyValue value, boolean isAtRoot) {
        this.setMapOnDemand();
        this.checkForZeroSizeKey(key);
        if (isAtRoot && key.equals("_id")) {
            this.setId(value);
            return;
        }
        InsertContext ctx = new InsertContext();
        if (isAtRoot) {
            this.setRootFlags(ctx);
            ctx.SetIsAtRoot(false);
        }
        value.setOpTypeAndFlags(ctx, true);
        this.map.put(key, value);
    }

    void createOrInsert(Iterator<FieldSegment> iter, KeyValue newKeyValue, InsertContext ctx) {
        boolean isAssocIndex;
        this.setMapOnDemand();
        FieldSegment field = iter.next();
        String key = field.getNameSegment().getName();
        this.checkForZeroSizeKey(key);
        KeyValue oldKeyValue = this.map.get(key);
        if (ctx.IsAtRoot()) {
            if (key.equals("_id")) {
                if (!field.isLastPath()) {
                    throw new TypeException("'_id' field can not be a complex type.");
                }
                this.setId(newKeyValue);
                return;
            }
            this.setRootFlags(ctx);
            ctx.SetIsAtRoot(false);
        }
        if (field.isLastPath()) {
            newKeyValue.setOpTypeAndFlags(ctx, true);
            this.map.put(key, newKeyValue);
            return;
        }
        if (field.isMap()) {
            if (oldKeyValue == null || oldKeyValue.getType() != Value.Type.MAP) {
                DBDocumentImpl newDocument = new DBDocumentImpl();
                newDocument.createOrInsert(iter, newKeyValue, ctx);
                newDocument.setOpTypeAndFlags(ctx, false);
                this.map.put(key, newDocument);
                return;
            }
            if (ctx.getOpType() != InsertContext.OpType.NONE && oldKeyValue.getOpType() != InsertContext.OpType.NONE) {
                DBDocumentImpl newDocument = new DBDocumentImpl();
                newDocument.createOrInsert(iter, newKeyValue, ctx);
                newDocument.setOpTypeAndFlags(ctx, false);
                this.map.put(key, newDocument);
                return;
            }
            DBDocumentImpl newDocument = (DBDocumentImpl)oldKeyValue;
            newDocument.setOpTypeAndFlags(ctx, false);
            newDocument.createOrInsert(iter, newKeyValue, ctx);
            return;
        }
        if (oldKeyValue == null || oldKeyValue.getType() != Value.Type.ARRAY) {
            DBList newList = new DBList(ctx.getOpType());
            newList.createOrInsert(iter, newKeyValue, ctx);
            newList.setOpTypeAndFlags(ctx, false);
            this.map.put(key, newList);
            return;
        }
        InsertContext.OpType ctxOpType = ctx.getOpType();
        boolean bl = isAssocIndex = !((DBList)oldKeyValue).IsAbsoluteIndexType();
        if (ctxOpType == InsertContext.OpType.NONE && !isAssocIndex || ctxOpType != InsertContext.OpType.NONE && isAssocIndex || oldKeyValue.getOpType() != InsertContext.OpType.NONE) {
            DBList newList = new DBList(ctx.getOpType());
            newList.createOrInsert(iter, newKeyValue, ctx);
            newList.setOpTypeAndFlags(ctx, false);
            this.map.put(key, newList);
            return;
        }
        DBList newList = (DBList)oldKeyValue;
        newList.createOrInsert(iter, newKeyValue, ctx);
        newList.setOpTypeAndFlags(ctx, false);
    }

    private DBDocumentImpl setCommon(FieldPath fieldPath, KeyValue value) {
        DBDocumentImpl.checkForArrayNotation(fieldPath);
        Value.Type t = value.getType();
        if (t == Value.Type.DECIMAL || t == Value.Type.INTERVAL) {
            throw new UnsupportedOperationException("BigDecimal and Interval type not supported");
        }
        this.setMapOnDemand();
        Iterator iter = fieldPath.iterator();
        this.createOrInsert(iter, value, new InsertContext());
        return this;
    }

    private void checkValueForNull(FieldPath field, Value v) {
        if (v == null) {
            throw new NoSuchElementException("Field '" + field + "' not found in the record.");
        }
    }

    public DBDocumentImpl empty() {
        this.map.clear();
        this.idValue = null;
        this.cachedBuffer = null;
        return this;
    }

    public DBDocumentImpl set(String field, String value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull((Object)value);
        return this.setCommon(FieldPath.parseFrom((String)field), DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(FieldPath field, String value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull((Object)value);
        return this.setCommon(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(String field, boolean value) {
        Preconditions.checkNotNull((Object)field);
        return this.setCommon(FieldPath.parseFrom((String)field), DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(FieldPath field, boolean value) {
        Preconditions.checkNotNull((Object)field);
        return this.setCommon(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(String field, byte value) {
        Preconditions.checkNotNull((Object)field);
        return this.setCommon(FieldPath.parseFrom((String)field), DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(FieldPath field, byte value) {
        Preconditions.checkNotNull((Object)field);
        return this.setCommon(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(String field, short value) {
        Preconditions.checkNotNull((Object)field);
        return this.setCommon(FieldPath.parseFrom((String)field), DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(FieldPath field, short value) {
        Preconditions.checkNotNull((Object)field);
        return this.setCommon(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(String field, int value) {
        Preconditions.checkNotNull((Object)field);
        return this.setCommon(FieldPath.parseFrom((String)field), DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(FieldPath field, int value) {
        Preconditions.checkNotNull((Object)field);
        return this.setCommon(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(String field, long value) {
        Preconditions.checkNotNull((Object)field);
        return this.setCommon(FieldPath.parseFrom((String)field), DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(FieldPath field, long value) {
        Preconditions.checkNotNull((Object)field);
        return this.setCommon(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(String field, float value) {
        Preconditions.checkNotNull((Object)field);
        return this.setCommon(FieldPath.parseFrom((String)field), DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(FieldPath field, float value) {
        Preconditions.checkNotNull((Object)field);
        return this.setCommon(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(String field, double value) {
        Preconditions.checkNotNull((Object)field);
        return this.setCommon(FieldPath.parseFrom((String)field), DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(FieldPath field, double value) {
        Preconditions.checkNotNull((Object)field);
        return this.setCommon(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(String field, OTime value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull((Object)value);
        return this.setCommon(FieldPath.parseFrom((String)field), DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(FieldPath field, OTime value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull((Object)value);
        return this.setCommon(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(String field, ODate value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull((Object)value);
        return this.setCommon(FieldPath.parseFrom((String)field), DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(FieldPath field, ODate value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull((Object)value);
        return this.setCommon(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(String field, BigDecimal value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull((Object)value);
        return this.setCommon(FieldPath.parseFrom((String)field), DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(FieldPath field, BigDecimal value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull((Object)value);
        throw new UnsupportedOperationException("BigDecimal type not supported");
    }

    public DBDocumentImpl set(String field, byte[] value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull((Object)value);
        return this.setCommon(FieldPath.parseFrom((String)field), DBValueBuilderImpl.KeyValueBuilder.initFrom(ByteBuffer.wrap(value)));
    }

    public DBDocumentImpl set(FieldPath field, byte[] value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull((Object)value);
        return this.setCommon(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(ByteBuffer.wrap(value)));
    }

    public DBDocumentImpl set(String field, byte[] value, int off, int len) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull((Object)value);
        return this.setCommon(FieldPath.parseFrom((String)field), DBValueBuilderImpl.KeyValueBuilder.initFrom(ByteBuffer.wrap(value, off, len)));
    }

    public DBDocumentImpl set(FieldPath field, byte[] value, int off, int len) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull((Object)value);
        return this.setCommon(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(ByteBuffer.wrap(value, off, len)));
    }

    public DBDocumentImpl set(String field, ByteBuffer value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull((Object)value);
        return this.setCommon(FieldPath.parseFrom((String)field), DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(FieldPath field, ByteBuffer value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull((Object)value);
        return this.setCommon(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(String field, Map<String, ? extends Object> value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull(value);
        return this.setCommon(FieldPath.parseFrom((String)field), DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(FieldPath field, Map<String, ? extends Object> value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull(value);
        return this.setCommon(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(String field, Document value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull((Object)value);
        return this.setCommon(FieldPath.parseFrom((String)field), DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(FieldPath field, Document value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull((Object)value);
        return this.setCommon(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(String field, Value value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull((Object)value);
        return this.setCommon(FieldPath.parseFrom((String)field), DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(FieldPath field, Value value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull((Object)value);
        return this.setCommon(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(String field, List<? extends Object> value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull(value);
        return this.set(FieldPath.parseFrom((String)field), (Value)DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public DBDocumentImpl set(FieldPath field, List<? extends Object> value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull(value);
        if (value instanceof DBList) {
            return this.setCommon(field, (DBList)value);
        }
        DBList list = new DBList(InsertContext.OpType.NONE);
        for (Object object : value) {
            list.addToDBList(DBValueBuilderImpl.KeyValueBuilder.initFromObject(object));
        }
        return this.setCommon(field, list);
    }

    public Document set(String field, OTimestamp value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull((Object)value);
        return this.set(FieldPath.parseFrom((String)field), value);
    }

    public Document set(FieldPath field, OTimestamp value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull((Object)value);
        return this.setCommon(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }

    public Document set(String field, OInterval value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull((Object)value);
        return this.set(FieldPath.parseFrom((String)field), value);
    }

    public Document set(FieldPath field, OInterval value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull((Object)value);
        throw new UnsupportedOperationException("Interval type not supported");
    }

    public Document setArray(String fieldPath, byte[] values) {
        Preconditions.checkNotNull((Object)fieldPath);
        Preconditions.checkNotNull((Object)values);
        return this.setArray(FieldPath.parseFrom((String)fieldPath), values);
    }

    public Document setArray(FieldPath fieldPath, byte[] values) {
        Preconditions.checkNotNull((Object)fieldPath);
        Preconditions.checkNotNull((Object)values);
        return this.setCommon(fieldPath, DBValueBuilderImpl.KeyValueBuilder.initFromArray(values));
    }

    public Document setArray(String fieldPath, boolean[] values) {
        Preconditions.checkNotNull((Object)fieldPath);
        Preconditions.checkNotNull((Object)values);
        return this.setArray(FieldPath.parseFrom((String)fieldPath), values);
    }

    public Document setArray(FieldPath fieldPath, boolean[] values) {
        Preconditions.checkNotNull((Object)fieldPath);
        Preconditions.checkNotNull((Object)values);
        return this.setCommon(fieldPath, DBValueBuilderImpl.KeyValueBuilder.initFromArray(values));
    }

    public Document setArray(String fieldPath, short[] values) {
        Preconditions.checkNotNull((Object)fieldPath);
        Preconditions.checkNotNull((Object)values);
        return this.setArray(FieldPath.parseFrom((String)fieldPath), values);
    }

    public Document setArray(FieldPath fieldPath, short[] values) {
        Preconditions.checkNotNull((Object)fieldPath);
        Preconditions.checkNotNull((Object)values);
        return this.setCommon(fieldPath, DBValueBuilderImpl.KeyValueBuilder.initFromArray(values));
    }

    public Document setArray(String fieldPath, int[] values) {
        Preconditions.checkNotNull((Object)fieldPath);
        Preconditions.checkNotNull((Object)values);
        return this.setArray(FieldPath.parseFrom((String)fieldPath), values);
    }

    public Document setArray(FieldPath fieldPath, int[] values) {
        Preconditions.checkNotNull((Object)fieldPath);
        Preconditions.checkNotNull((Object)values);
        return this.setCommon(fieldPath, DBValueBuilderImpl.KeyValueBuilder.initFromArray(values));
    }

    public Document setArray(String fieldPath, long[] values) {
        Preconditions.checkNotNull((Object)fieldPath);
        Preconditions.checkNotNull((Object)values);
        return this.setArray(FieldPath.parseFrom((String)fieldPath), values);
    }

    public Document setArray(FieldPath fieldPath, long[] values) {
        Preconditions.checkNotNull((Object)fieldPath);
        Preconditions.checkNotNull((Object)values);
        return this.setCommon(fieldPath, DBValueBuilderImpl.KeyValueBuilder.initFromArray(values));
    }

    public Document setArray(String fieldPath, float[] values) {
        Preconditions.checkNotNull((Object)fieldPath);
        Preconditions.checkNotNull((Object)values);
        return this.setArray(FieldPath.parseFrom((String)fieldPath), values);
    }

    public Document setArray(FieldPath fieldPath, float[] values) {
        Preconditions.checkNotNull((Object)fieldPath);
        Preconditions.checkNotNull((Object)values);
        return this.setCommon(fieldPath, DBValueBuilderImpl.KeyValueBuilder.initFromArray(values));
    }

    public Document setArray(String fieldPath, double[] values) {
        Preconditions.checkNotNull((Object)fieldPath);
        Preconditions.checkNotNull((Object)values);
        return this.setArray(FieldPath.parseFrom((String)fieldPath), values);
    }

    public Document setArray(FieldPath fieldPath, double[] values) {
        Preconditions.checkNotNull((Object)fieldPath);
        Preconditions.checkNotNull((Object)values);
        return this.setCommon(fieldPath, DBValueBuilderImpl.KeyValueBuilder.initFromArray(values));
    }

    Document setCommonFromObjectArray(FieldPath field, Object[] values) {
        return this.setCommon(field, DBValueBuilderImpl.KeyValueBuilder.initFromArray(values));
    }

    public Document setArray(String fieldPath, String[] values) {
        Preconditions.checkNotNull((Object)fieldPath);
        Preconditions.checkNotNull((Object)values);
        return this.setArray(FieldPath.parseFrom((String)fieldPath), values);
    }

    public Document setArray(FieldPath fieldPath, String[] values) {
        Preconditions.checkNotNull((Object)fieldPath);
        Preconditions.checkNotNull((Object)values);
        return this.setCommonFromObjectArray(fieldPath, values);
    }

    public Document setArray(String fieldPath, Object ... values) {
        Preconditions.checkNotNull((Object)fieldPath);
        return this.setArray(FieldPath.parseFrom((String)fieldPath), values);
    }

    public Document setArray(FieldPath fieldPath, Object ... values) {
        Preconditions.checkNotNull((Object)fieldPath);
        return this.setCommonFromObjectArray(fieldPath, values);
    }

    public Document setNull(String fieldPath) {
        Preconditions.checkNotNull((Object)fieldPath);
        return this.setNull(FieldPath.parseFrom((String)fieldPath));
    }

    public Document setNull(FieldPath fieldPath) {
        Preconditions.checkNotNull((Object)fieldPath);
        return this.setCommon(fieldPath, new KeyValue(Value.Type.NULL));
    }

    KeyValue getKeyValueAt(Iterator<FieldSegment> iter) {
        this.setMapOnDemand();
        FieldSegment field = iter.next();
        if (field == null) {
            return null;
        }
        String key = field.getNameSegment().getName();
        if (this.idValue != null && key.equals("_id") && !this.excludeId) {
            return this.idValue;
        }
        if (key.equals("")) {
            return this;
        }
        KeyValue kv = this.map.get(key);
        if (kv == null) {
            return null;
        }
        if (field.isLastPath()) {
            return kv;
        }
        if (field.isMap()) {
            if (kv.getType() != Value.Type.MAP) {
                return null;
            }
            return ((DBDocumentImpl)kv).getKeyValueAt(iter);
        }
        if (kv.getType() != Value.Type.ARRAY) {
            return null;
        }
        return ((DBList)kv).getKeyValueAt(iter);
    }

    public KeyValue getKeyValue(String path) {
        return this.getKeyValue(FieldPath.parseFrom((String)path));
    }

    public KeyValue getKeyValue(FieldPath path) {
        DBDocumentImpl.checkForArrayNotation(path);
        return this.getKeyValueAt(path.iterator());
    }

    public Value getValue(String fieldPath) {
        return this.getValue(FieldPath.parseFrom((String)fieldPath));
    }

    public Value getValue(FieldPath fieldPath) {
        return this.getKeyValue(fieldPath);
    }

    public String getString(String field) {
        return this.getString(FieldPath.parseFrom((String)field));
    }

    public String getString(FieldPath field) {
        KeyValue v = this.getKeyValue(field);
        if (v != null) {
            return v.getString();
        }
        return null;
    }

    public boolean getBoolean(String field) {
        return this.getBoolean(FieldPath.parseFrom((String)field));
    }

    public boolean getBoolean(FieldPath field) {
        KeyValue v = this.getKeyValue(field);
        this.checkValueForNull(field, v);
        return v.getBoolean();
    }

    public Boolean getBooleanObj(String field) {
        return this.getBooleanObj(FieldPath.parseFrom((String)field));
    }

    public Boolean getBooleanObj(FieldPath field) {
        KeyValue v = this.getKeyValue(field);
        if (v != null) {
            return v.getBoolean();
        }
        return null;
    }

    public byte getByte(String field) {
        return this.getByte(FieldPath.parseFrom((String)field));
    }

    public byte getByte(FieldPath field) {
        KeyValue v = this.getKeyValue(field);
        this.checkValueForNull(field, v);
        return v.getByte();
    }

    public Byte getByteObj(String field) {
        return this.getByteObj(FieldPath.parseFrom((String)field));
    }

    public Byte getByteObj(FieldPath field) {
        KeyValue v = this.getKeyValue(field);
        if (v != null) {
            return v.getByte();
        }
        return null;
    }

    public short getShort(String field) {
        return this.getShort(FieldPath.parseFrom((String)field));
    }

    public short getShort(FieldPath field) {
        KeyValue v = this.getKeyValue(field);
        this.checkValueForNull(field, v);
        return v.getShort();
    }

    public Short getShortObj(String field) {
        return this.getShortObj(FieldPath.parseFrom((String)field));
    }

    public Short getShortObj(FieldPath field) {
        KeyValue v = this.getKeyValue(field);
        if (v != null) {
            return v.getShort();
        }
        return null;
    }

    public int getInt(String field) {
        return this.getInt(FieldPath.parseFrom((String)field));
    }

    public int getInt(FieldPath field) {
        KeyValue v = this.getKeyValue(field);
        this.checkValueForNull(field, v);
        return v.getInt();
    }

    public Integer getIntObj(String field) {
        return this.getIntObj(FieldPath.parseFrom((String)field));
    }

    public Integer getIntObj(FieldPath field) {
        KeyValue v = this.getKeyValue(field);
        if (v != null) {
            return v.getInt();
        }
        return null;
    }

    public long getLong(String field) {
        return this.getLong(FieldPath.parseFrom((String)field));
    }

    public long getLong(FieldPath field) {
        KeyValue v = this.getKeyValue(field);
        this.checkValueForNull(field, v);
        return v.getLong();
    }

    public Long getLongObj(String field) {
        return this.getLongObj(FieldPath.parseFrom((String)field));
    }

    public Long getLongObj(FieldPath field) {
        KeyValue v = this.getKeyValue(field);
        if (v != null) {
            return v.getLong();
        }
        return null;
    }

    public float getFloat(String field) {
        return this.getFloat(FieldPath.parseFrom((String)field));
    }

    public float getFloat(FieldPath field) {
        KeyValue v = this.getKeyValue(field);
        this.checkValueForNull(field, v);
        return v.getFloat();
    }

    public Float getFloatObj(String field) {
        return this.getFloatObj(FieldPath.parseFrom((String)field));
    }

    public Float getFloatObj(FieldPath field) {
        KeyValue v = this.getKeyValue(field);
        if (v != null) {
            return Float.valueOf(v.getFloat());
        }
        return null;
    }

    public double getDouble(String field) {
        return this.getDouble(FieldPath.parseFrom((String)field));
    }

    public double getDouble(FieldPath field) {
        KeyValue v = this.getKeyValue(field);
        this.checkValueForNull(field, v);
        return v.getDouble();
    }

    public Double getDoubleObj(String field) {
        return this.getDoubleObj(FieldPath.parseFrom((String)field));
    }

    public Double getDoubleObj(FieldPath field) {
        KeyValue v = this.getKeyValue(field);
        if (v != null) {
            return v.getDouble();
        }
        return null;
    }

    public OTime getTime(String field) {
        return this.getTime(FieldPath.parseFrom((String)field));
    }

    public OTime getTime(FieldPath field) {
        KeyValue v = this.getKeyValue(field);
        if (v != null) {
            return v.getTime();
        }
        return null;
    }

    public ODate getDate(String field) {
        return this.getDate(FieldPath.parseFrom((String)field));
    }

    public ODate getDate(FieldPath field) {
        KeyValue v = this.getKeyValue(field);
        if (v != null) {
            return v.getDate();
        }
        return null;
    }

    public BigDecimal getDecimal(String field) {
        return this.getDecimal(FieldPath.parseFrom((String)field));
    }

    public BigDecimal getDecimal(FieldPath field) {
        KeyValue v = this.getKeyValue(field);
        if (v != null) {
            return v.getDecimal();
        }
        return null;
    }

    public ByteBuffer getBinary(String field) {
        return this.getBinary(FieldPath.parseFrom((String)field));
    }

    public ByteBuffer getBinary(FieldPath field) {
        KeyValue v = this.getKeyValue(field);
        if (v != null) {
            return v.getBinary();
        }
        return null;
    }

    public OTimestamp getTimestamp(String fieldPath) {
        return this.getTimestamp(FieldPath.parseFrom((String)fieldPath));
    }

    public OTimestamp getTimestamp(FieldPath fieldPath) {
        KeyValue v = this.getKeyValue(fieldPath);
        if (v != null) {
            return v.getTimestamp();
        }
        return null;
    }

    public OInterval getInterval(String fieldPath) {
        return this.getInterval(FieldPath.parseFrom((String)fieldPath));
    }

    public OInterval getInterval(FieldPath fieldPath) {
        KeyValue v = this.getKeyValue(fieldPath);
        if (v != null) {
            return v.getInterval();
        }
        return null;
    }

    public Map<String, Object> getMap(String fieldPath) {
        return this.getMap(FieldPath.parseFrom((String)fieldPath));
    }

    public Map<String, Object> getMap(FieldPath fieldPath) {
        KeyValue v = this.getKeyValue(fieldPath);
        if (v != null) {
            return v.getMap();
        }
        return null;
    }

    public List<Object> getList(String fieldPath) {
        return this.getList(FieldPath.parseFrom((String)fieldPath));
    }

    public List<Object> getList(FieldPath fieldPath) {
        KeyValue v = this.getKeyValue(fieldPath);
        if (v != null) {
            return v.getList();
        }
        return null;
    }

    public Set<Value> getUniqueValues(FieldPath fieldPath) throws IllegalArgumentException {
        Set<Value> valList = null;
        if (fieldPath != null && fieldPath != FieldPath.EMPTY) {
            this.setMapOnDemand();
            valList = new HashSet<Value>();
            valList = this.addValuesAt(fieldPath.iterator(), valList);
        }
        return valList.isEmpty() ? null : valList;
    }

    Set<Value> addValuesAt(Iterator<FieldSegment> fpItr, Set<Value> values) {
        if (!fpItr.hasNext()) {
            return values;
        }
        FieldSegment field = fpItr.next();
        if (!field.isNamed()) {
            return null;
        }
        String key = field.getNameSegment().getName();
        if (key == "") {
            return values;
        }
        KeyValue kv = this.map.get(key);
        if (kv == null) {
            return values;
        }
        if (field.isArray()) {
            boolean isOpenArrayPath;
            if (kv.getType() == Value.Type.ARRAY) {
                return ((DBList)kv).addValuesAt(fpItr, values);
            }
            FieldSegment childSeg = fpItr.next();
            if (!childSeg.isIndexed()) {
                throw new IllegalArgumentException("Parent is an array but child is not an array index");
            }
            FieldSegment.IndexSegment brackets = childSeg.getIndexSegment();
            boolean bl = isOpenArrayPath = !brackets.hasIndex();
            if (!isOpenArrayPath) {
                return values;
            }
            boolean isInnerMostDimension = true;
            FieldSegment grandChild = brackets.getChild();
            if (grandChild != null && grandChild.isIndexed()) {
                FieldSegment.IndexSegment grandChildIndexSeg = grandChild.getIndexSegment();
                isInnerMostDimension = grandChildIndexSeg.hasIndex();
            }
            if (isInnerMostDimension) {
                if (kv.getType() == Value.Type.MAP) {
                    return ((DBDocumentImpl)kv).addValuesAt(fpItr, values);
                }
                values.add(kv);
            }
        } else if (field.isMap()) {
            if (kv.getType() == Value.Type.MAP) {
                return ((DBDocumentImpl)kv).addValuesAt(fpItr, values);
            }
        } else {
            values.add(kv);
        }
        return values;
    }

    void delete(Iterator<FieldSegment> iter) {
        KeyValue kv;
        this.setMapOnDemand();
        FieldSegment field = iter.next();
        if (field == null) {
            return;
        }
        String key = field.getNameSegment().getName();
        if (field.isLastPath() && key.equals("_id")) {
            this.idValue = null;
        }
        if ((kv = this.map.get(key)) == null) {
            return;
        }
        if (field.isLastPath()) {
            this.cachedBuffer = null;
            this.map.remove(key);
            return;
        }
        if (field.isMap()) {
            if (kv.getType() != Value.Type.MAP) {
                return;
            }
            ((DBDocumentImpl)kv).delete(iter);
            return;
        }
        if (kv.getType() != Value.Type.ARRAY) {
            return;
        }
        ((DBList)kv).delete(iter);
    }

    public Document delete(String field) {
        this.delete(FieldPath.parseFrom((String)field));
        return this;
    }

    public Document delete(FieldPath path) {
        DBDocumentImpl.checkForArrayNotation(path);
        this.delete(path.iterator());
        return this;
    }

    public Iterator<Map.Entry<String, Value>> iterator() {
        return new DBDocumentIterator();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        this.setMapOnDemand();
        if (this.idValue != null && !this.excludeId && key.equals("_id")) {
            return true;
        }
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.setMapOnDemand();
        KeyValue v = DBValueBuilderImpl.KeyValueBuilder.initFromObject(value);
        if (this.idValue != null && !this.excludeId && v.equals(value)) {
            return true;
        }
        return this.map.containsValue(v);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        this.setMapOnDemand();
        LinkedHashSet<Map.Entry<String, Object>> s = new LinkedHashSet<Map.Entry<String, Object>>();
        if (this.idValue != null && !this.excludeId) {
            AbstractMap.SimpleImmutableEntry<String, Object> newEntry = new AbstractMap.SimpleImmutableEntry<String, Object>("_id", this.idValue.getObject());
            s.add(newEntry);
        }
        for (String k : this.map.keySet()) {
            AbstractMap.SimpleImmutableEntry<String, Object> newEntry = new AbstractMap.SimpleImmutableEntry<String, Object>(k, this.map.get(k).getObject());
            s.add(newEntry);
        }
        return s;
    }

    @Override
    public Object get(Object key) {
        this.setMapOnDemand();
        if (this.idValue != null && !this.excludeId && key.equals("_id")) {
            return this.idValue.getObject();
        }
        KeyValue kv = this.map.get(key);
        if (kv != null) {
            return kv.getObject();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        this.setMapOnDemand();
        if (this.idValue != null && !this.excludeId) {
            return false;
        }
        return this.map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        this.setMapOnDemand();
        HashSet<String> s = new HashSet<String>();
        if (this.idValue != null && !this.excludeId) {
            s.add("_id");
        }
        s.addAll(this.map.keySet());
        return s;
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        this.setMapOnDemand();
        int size = this.map.size();
        if (this.idValue != null && !this.excludeId) {
            ++size;
        }
        return size;
    }

    @Override
    public Collection<Object> values() {
        this.setMapOnDemand();
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.idValue != null && !this.excludeId) {
            list.add(this.idValue.getObject());
        }
        for (KeyValue v : this.map.values()) {
            list.add(v.getObject());
        }
        return list;
    }

    @Override
    public DocumentReader asReader() {
        if (this.cachedBuffer == null) {
            return new DBDOMDocumentReader(this, this.idValue);
        }
        return new DBDocumentReader2(this.cachedBuffer.map, this.cachedBuffer.jsonPathMap, this.idValue, this.excludeId, this.cachedBuffer.decodeTimestamp, this.cachedBuffer.preserveDeleteTime);
    }

    public void getDOMFromCachedBuffer() {
        if (this.cachedBuffer != null) {
            CachedBufferInfo c = this.cachedBuffer;
            this.cachedBuffer = null;
            RowcolCodec.decodeInternal(c.map, c.jsonPathMap, c.idToCFNameMap, c.decodeTimestamp, c.preserveDeleteFlags, this, c.paths, c.fpMap);
        }
    }

    public boolean getNeedDOMStruct() {
        return this.cachedBuffer != null;
    }

    public DocumentReader asReader(String fieldPath) {
        return this.asReader(FieldPath.parseFrom((String)fieldPath));
    }

    public DocumentReader asReader(FieldPath fieldPath) {
        KeyValue value = this.getKeyValue(fieldPath);
        return new DBDOMDocumentReader(value);
    }

    @Override
    public DBDocumentImpl shallowCopy() {
        this.setMapOnDemand();
        if (this.cachedBuffer != null) {
            return this;
        }
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.map = this.map;
        rec.objValue = this.objValue;
        rec.primValue = this.primValue;
        rec.orderInMap = this.orderInMap;
        rec.rootCFid = this.rootCFid;
        rec.partOfNonDefaultCF = this.partOfNonDefaultCF;
        return rec;
    }

    public int getIndex(String path) {
        FieldPath field = FieldPath.parseFrom((String)path);
        Iterator iter = field.iterator();
        return this.getIndex(iter);
    }

    private int getIndex(Iterator<FieldSegment> iter) {
        this.setMapOnDemand();
        FieldSegment fs = iter.next();
        String key = fs.getNameSegment().getName();
        if (fs.isLastPath()) {
            int i = 0;
            for (String k : this.map.keySet()) {
                if (key.equals(k)) {
                    return i;
                }
                ++i;
            }
        }
        if (fs.isMap()) {
            KeyValue kv = this.map.get(key);
            if (kv == null) {
                return -1;
            }
            return ((DBDocumentImpl)kv).getIndex(iter);
        }
        return -1;
    }

    @Override
    public void setRecursiveNonDefaultColumnFamily(boolean b, int cfId) {
        for (KeyValue kv : this.map.values()) {
            kv.setPartOfNonDefaultColumnFamily(b);
            kv.setCFRootId(cfId);
            kv.setRecursiveNonDefaultColumnFamily(b, cfId);
        }
    }

    public void serializeToRowCol(ByteWriter w, SerializationContext ctx) {
        KeyValue kv;
        ctx.setHasDeletes(false);
        RootTimeDescriptor.serialize(this, w, ctx);
        TimeDescriptor.serialize(this, w);
        TreeMap<String, KeyValue> sortedMap = new TreeMap<String, KeyValue>();
        int i = 0;
        for (Map.Entry<String, KeyValue> entry : this.map.entrySet()) {
            kv = entry.getValue();
            if (kv.isRootOfColumnFamily() && ctx.isFamilyRoot(kv)) {
                ++i;
                continue;
            }
            kv.setOrderOfField(i);
            sortedMap.put(entry.getKey(), kv);
            ++i;
        }
        for (Map.Entry<String, KeyValue> entry : sortedMap.entrySet()) {
            kv = entry.getValue();
            KeyValueSerializeHelper.serialize(entry.getKey(), kv, this, kv.getOrderOfField(), ctx, w);
        }
        if (ctx.hasDeletes()) {
            this.setHasDeletes(true);
            RootTimeDescriptor.rewriteHasDeleteFlag(this, w, ctx);
        }
        w.put((byte)0);
    }

    public void deserializeFromRowCol(ByteBuffer input, Map<String, FieldPath> fieldPathMap, SerializationContext ctx) {
        this.setIsRoot();
        RootTimeDescriptor.deserialize(input, ctx);
        TimeDescriptor.deserialize(this, input, ctx);
        KeyValuePair kv = threadLocalKVPair.get();
        TimeAndUniq savedBaseTs = ctx.getBaseTime();
        FieldPath savedCurrentPath = ctx.currentPath();
        ctx.setNewRecord(true);
        while (KeyValueDeserializeHelper.deserializeNextKeyValue(false, null, this, ctx, input, fieldPathMap, kv)) {
            if (ctx.getDecodeTimestamp()) {
                this.map.put(kv.getKey(), (KeyValueWithTS)kv.getValue());
            } else {
                this.map.put(kv.getKey(), kv.getValue());
            }
            ctx.setCurrentPath(savedCurrentPath);
            ctx.setNewRecord(true);
        }
        ctx.setBaseTime(savedBaseTs);
    }

    public <T> T toJavaBean(Class<T> beanClass) {
        return (T)BeanCodec.encode((DocumentReader)this.asReader(), beanClass);
    }

    public Document setId(String _id) {
        this.setId(DBValueBuilderImpl.KeyValueBuilder.initFrom(_id));
        return this;
    }

    public Document setId(ByteBuffer _id) {
        this.setId(DBValueBuilderImpl.KeyValueBuilder.initFrom(_id));
        return this;
    }

    public Document setId(Value id) {
        this.setId(id, false);
        return this;
    }

    public void setId(Value id, boolean exclude) {
        if (id != null) {
            switch (id.getType()) {
                case BINARY: 
                case STRING: {
                    break;
                }
                default: {
                    throw new TypeException("Only " + Value.Type.BINARY + " AND " + Value.Type.STRING + " types are currently support for '_id' field.");
                }
            }
            this.idValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(id);
        }
        if (exclude) {
            this.excludeId = exclude;
        }
    }

    public Value getId() {
        return this.idValue;
    }

    public String getIdString() {
        return this.idValue != null ? this.idValue.getString() : null;
    }

    public ByteBuffer getIdBinary() {
        return this.idValue != null ? this.idValue.getBinary() : null;
    }

    @API.Internal
    public String getIdAsString() {
        return this.idValue != null ? IdCodec.asString(this.idValue) : null;
    }

    @API.Internal
    public void setMapOnDemand() {
        if (this.getNeedDOMStruct()) {
            this.getDOMFromCachedBuffer();
        }
    }

    @Override
    public String toString() {
        return this.asJsonString();
    }

    @Override
    public String asJsonString() {
        return this.asJsonString(JsonOptions.DEFAULT);
    }

    @Override
    public String asJsonString(JsonOptions options) {
        this.setMapOnDemand();
        return Json.toJsonString((Document)this, (JsonOptions)options);
    }

    public Map<String, Object> asMap() {
        return DocumentReaders.encode((DocumentReader)this.asReader());
    }

    @Override
    public String toStringWithTimestamp() {
        this.setMapOnDemand();
        StringBuilder sb = new StringBuilder().append('{');
        if (this.isRoot()) {
            sb.append("\"_timestamp\":").append(TimeDescriptor.toStringWithTimestamp(this));
        }
        boolean addedChild = false;
        Iterator<Map.Entry<String, Value>> iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Value> element = iterator.next();
            if (!(element.getValue() instanceof KeyValueWithTS)) {
                throw new IllegalStateException("toStriwithTimestamp encountered value object without timestamps");
            }
            if (this.isRoot() && !addedChild) {
                sb.append(", ");
            }
            KeyValueWithTS kv = (KeyValueWithTS)element.getValue();
            sb.append("\"").append(element.getKey()).append("\"").append(':').append("{\"_timestamp\":").append(TimeDescriptor.toStringWithTimestamp(kv)).append(", ").append("\"_value\":").append(kv.toStringWithTimestamp()).append("}, ");
            addedChild = true;
        }
        if (addedChild) {
            sb.setLength(sb.length() - 2);
        }
        return sb.append('}').toString();
    }

    public void setCachedBuffer(ByteBuffer buffer) {
        this.cachedBuffer = null;
    }

    public String getStringWithTs(Map<FieldPath, Integer> tablePathToIdMap) {
        SerializedFamilyInfo[] doc1Data = RowcolCodec.encode(this, tablePathToIdMap, false, true);
        StringBuilder sb = new StringBuilder();
        for (SerializedFamilyInfo info : doc1Data) {
            ByteBuffer bb;
            if (info.getAction() == SerializationAction.NO_ACTION || (bb = info.getByteBuffer()).remaining() <= 0) continue;
            DBDocumentImpl familyDoc = (DBDocumentImpl)RowcolCodec.decode(bb, null, true, true, true);
            String path = null;
            for (Map.Entry<FieldPath, Integer> e : tablePathToIdMap.entrySet()) {
                if (e.getValue().intValue() != info.getFamilyId()) continue;
                path = e.getKey().toString();
                break;
            }
            sb.append("\"_familypath\":\"" + path + "\",");
            sb.append("\"_value\":" + familyDoc.toStringWithTimestamp());
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        this.setMapOnDemand();
        if (obj instanceof DBDocumentImpl) {
            ((DBDocumentImpl)obj).setMapOnDemand();
        }
        if (obj instanceof Document) {
            return Documents.equals((Document)this, (Document)((Document)obj));
        }
        if (obj instanceof Map) {
            return obj.equals(this);
        }
        return false;
    }

    class DBDocumentIterator
    implements Iterator<Map.Entry<String, Value>> {
        Iterator<String> keyIter;
        KeyValue idKeyValue;
        boolean returnedIdKeyValue;

        DBDocumentIterator() {
            DBDocumentImpl.this.setMapOnDemand();
            this.keyIter = DBDocumentImpl.this.map.keySet().iterator();
            this.idKeyValue = DBDocumentImpl.this.idValue;
            this.returnedIdKeyValue = DBDocumentImpl.this.idValue == null || DBDocumentImpl.this.excludeId;
        }

        @Override
        public boolean hasNext() {
            if (!this.returnedIdKeyValue) {
                return true;
            }
            return this.keyIter.hasNext();
        }

        @Override
        public Map.Entry<String, Value> next() {
            if (!this.returnedIdKeyValue) {
                AbstractMap.SimpleImmutableEntry<String, Value> e = new AbstractMap.SimpleImmutableEntry<String, Value>("_id", this.idKeyValue);
                this.returnedIdKeyValue = true;
                return e;
            }
            String key = this.keyIter.next();
            KeyValue kv = DBDocumentImpl.this.map.get(key);
            return new AbstractMap.SimpleImmutableEntry<String, Value>(key, kv);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class CachedBufferInfo {
        Map<Integer, ByteBuffer> map;
        Map<FieldPath, Integer> jsonPathMap;
        Map<Integer, String> idToCFNameMap;
        public boolean decodeTimestamp;
        boolean preserveDeleteFlags;
        boolean preserveDeleteTime;
        private String[] paths;
        private Map fpMap;

        public CachedBufferInfo(Map<Integer, ByteBuffer> map, Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap, boolean decodeTimestamp, boolean preserveDeleteFlags, boolean preserveDeleteTime, String[] paths, Map<String, FieldPath> fieldPathMap) {
            this.map = map;
            for (Integer i : map.keySet()) {
                ByteBuffer src = map.get(i);
                src.order(ByteOrder.LITTLE_ENDIAN);
            }
            this.jsonPathMap = jsonPathMap;
            this.idToCFNameMap = idToCFNameMap;
            this.decodeTimestamp = decodeTimestamp;
            this.preserveDeleteFlags = preserveDeleteFlags;
            this.preserveDeleteTime = preserveDeleteTime;
            this.paths = paths;
            this.fpMap = fieldPathMap;
        }
    }
}

