/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.rowcol.ByteWriter;
import com.mapr.db.rowcol.KeyValueSizeDescriptor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.nio.ByteBuffer;

public class BigDecimalSizeDescriptor {
    static byte encodeSize(int size) {
        if (size <= 2) {
            return (byte)size;
        }
        return 4;
    }

    static int decodeSize(int size) {
        if (size >= 3) {
            return 4;
        }
        return size;
    }

    public static int getSerializedSize(BigDecimal d) {
        int precision = d.precision();
        int scale = d.scale();
        byte[] unscaledValue = d.unscaledValue().toByteArray();
        int size = 1;
        int precisionSize = KeyValueSizeDescriptor.varIntSize(precision);
        int scaleSize = KeyValueSizeDescriptor.varIntSize(scale);
        if (unscaledValue.length >= 15) {
            size += 4;
        }
        size += precisionSize;
        size += scaleSize;
        return size += unscaledValue.length;
    }

    public static void serialize(BigDecimal d, ByteWriter w) {
        int precision = d.precision();
        int scale = d.scale();
        byte[] unscaledValue = d.unscaledValue().toByteArray();
        byte sizeDesc = 0;
        int precisionSize = KeyValueSizeDescriptor.varIntSize(precision);
        int scaleSize = KeyValueSizeDescriptor.varIntSize(scale);
        sizeDesc = BigDecimalSizeDescriptor.encodeSize(precisionSize);
        sizeDesc = (byte)(sizeDesc | BigDecimalSizeDescriptor.encodeSize(scaleSize) << 2);
        if (unscaledValue.length < 15) {
            sizeDesc = (byte)(sizeDesc | unscaledValue.length << 4);
            w.put(sizeDesc);
        } else {
            sizeDesc = (byte)(sizeDesc | 0xF0);
            w.put(sizeDesc);
            w.putInt(unscaledValue.length);
        }
        KeyValueSizeDescriptor.encodeVarInt(precision, precisionSize, w);
        KeyValueSizeDescriptor.encodeVarInt(scale, scaleSize, w);
        w.put(unscaledValue);
    }

    public static BigDecimal deSerialize(ByteBuffer input) {
        byte sizeDesc = input.get();
        int unscaledValueSize = BigDecimalSizeDescriptor.getBigDecimalUnscaledValueSize(sizeDesc, input);
        int precision = BigDecimalSizeDescriptor.getBigDecimalPrecision(sizeDesc, input);
        int scale = BigDecimalSizeDescriptor.getBigDecimalScale(sizeDesc, input);
        byte[] unscaledValue = BigDecimalSizeDescriptor.getBigDecimalUnscaledValue(unscaledValueSize, input);
        return new BigDecimal(new BigInteger(unscaledValue), scale, new MathContext(precision));
    }

    public static int getBigDecimalPrecision(byte sizeDesc, ByteBuffer input) {
        int precisionSize = BigDecimalSizeDescriptor.decodeSize(sizeDesc & 3);
        return KeyValueSizeDescriptor.readVarInt(precisionSize, input);
    }

    public static int getBigDecimalScale(byte sizeDesc, ByteBuffer input) {
        int scaleSize = BigDecimalSizeDescriptor.decodeSize(sizeDesc >> 2 & 3);
        return KeyValueSizeDescriptor.readVarInt(scaleSize, input);
    }

    public static int getBigDecimalUnscaledValueSize(byte sizeDesc, ByteBuffer input) {
        int unscaledValueSize = (sizeDesc & 0xFF) >> 4;
        if (unscaledValueSize >= 15) {
            unscaledValueSize = input.getInt();
        }
        return unscaledValueSize;
    }

    public static byte[] getBigDecimalUnscaledValue(int valueSize, ByteBuffer input) {
        byte[] unscaledValue = new byte[valueSize];
        input.get(unscaledValue);
        return unscaledValue;
    }
}

