/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.ojai;

import com.mapr.db.rowcol.TimeAndUniq;
import com.mapr.db.rowcol.TimeDescriptor;
import org.ojai.DocumentReader;
import org.ojai.annotation.API;

@API.Internal
public class EventTypeWithTime {
    private DocumentReader.EventType eventType_;
    private TimeAndUniq[] cudTimes_;
    private TimeDescriptor.TimeStampState[] cudTimeStates_;

    public EventTypeWithTime() {
        this(DocumentReader.EventType.NULL);
    }

    public EventTypeWithTime(DocumentReader.EventType eventType) {
        this.eventType_ = eventType;
        this.cudTimes_ = new TimeAndUniq[3];
        this.cudTimeStates_ = new TimeDescriptor.TimeStampState[3];
        for (int i = 0; i < 3; ++i) {
            this.cudTimes_[i] = new TimeAndUniq();
            this.cudTimeStates_[i] = TimeDescriptor.TimeStampState.NOT_SET;
        }
    }

    public DocumentReader.EventType getType() {
        return this.eventType_;
    }

    public void setType(DocumentReader.EventType eventType) {
        this.eventType_ = eventType;
    }

    public TimeAndUniq[] getCudTime() {
        return this.cudTimes_;
    }

    public TimeDescriptor.TimeStampState[] getCudTimeState() {
        return this.cudTimeStates_;
    }

    public void clearCudTimeAndStates() {
        for (int i = 0; i < 3; ++i) {
            this.cudTimes_[i].setTime(0L);
            this.cudTimes_[i].setUniq(0);
            this.cudTimeStates_[i] = TimeDescriptor.TimeStampState.NOT_SET;
        }
    }

    public void setTypeAndCudTime(DocumentReader.EventType eventType, TimeAndUniq[] cudTimes, TimeDescriptor.TimeStampState[] cudTimeStates) {
        this.eventType_ = eventType;
        this.setCudTimesAndStates(cudTimes, cudTimeStates);
    }

    public void setCudTimesAndStates(TimeAndUniq[] cudTimes, TimeDescriptor.TimeStampState[] cudTimeStates) {
        if (cudTimes == null) {
            this.clearCudTimeAndStates();
        } else {
            for (int i = 0; i < 3; ++i) {
                this.cudTimes_[i].setTime(cudTimes[i].time());
                this.cudTimes_[i].setUniq(cudTimes[i].uniq());
                this.cudTimeStates_[i] = cudTimeStates[i];
            }
        }
    }

    public TimeDescriptor.TimeStampState getCreateTimeState() {
        if (this.cudTimeStates_ == null || this.cudTimeStates_.length != 3) {
            return null;
        }
        return this.cudTimeStates_[0];
    }

    public TimeDescriptor.TimeStampState getUpdateTimeState() {
        if (this.cudTimeStates_ == null || this.cudTimeStates_.length != 3) {
            return null;
        }
        return this.cudTimeStates_[1];
    }

    public TimeDescriptor.TimeStampState getDeleteTimeState() {
        if (this.cudTimeStates_ == null || this.cudTimeStates_.length != 3) {
            return null;
        }
        return this.cudTimeStates_[2];
    }

    public TimeAndUniq getCreateTime() {
        if (this.cudTimes_ == null || this.cudTimes_.length != 3) {
            return null;
        }
        return this.cudTimes_[0];
    }

    public TimeAndUniq getUpdateTime() {
        if (this.cudTimes_ == null || this.cudTimes_.length != 3) {
            return null;
        }
        return this.cudTimes_[1];
    }

    public TimeAndUniq getDeleteTime() {
        if (this.cudTimes_ == null || this.cudTimes_.length != 3) {
            return null;
        }
        return this.cudTimes_[2];
    }
}

