/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.mapr.db.impl.AlwaysFalseCondition;
import com.mapr.db.impl.AlwaysTrueCondition;
import com.mapr.db.impl.ConditionBlock;
import com.mapr.db.impl.ConditionDescriptor;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionLeaf;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.MapRDBIndexImplWrapper;
import com.mapr.db.impl.MapRDBTableImplHelper;
import com.mapr.db.impl.SqlTransformer;
import com.mapr.fs.proto.Dbfilters;
import com.mapr.utils.CommaSeparated;
import com.mapr.utils.IndentingStringBuilder;
import com.mapr.utils.ParentheticalStringBuilder;
import com.mapr.utils.PrependingStringBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ojai.FieldPath;
import org.ojai.store.QueryCondition;

public class AefTransformer {
    public static final String SHOW_TRANSFORM_NAME = "ojai.mapr.query.aeftransformer-show";
    private static final String SHOW_TRANSFORM_DEFAULT = "false";
    private static final boolean SHOW_TRANSFORM = Boolean.parseBoolean(System.getProperty("ojai.mapr.query.aeftransformer-show", "false"));
    private Format format;
    private ConditionNode cNode;
    private final ArrayList<AefTransformer> children;
    private final ConditionBlock.BlockType blockType;
    private String arrayName;
    private Dbfilters.ArrayElementFilterProto.ArrayModeProto arrayMode;
    private Dbfilters.ArrayElementFilterProto.OpTypeProto opType;
    private boolean innermostDimension = false;
    private static final AefTransformer EMPTY_TRANSFORMER = new EmptyTransformer();
    private String flattenAlias;
    private AefTransformer priorFlatten;
    private static final String SELECT_ID = "select _id";
    private static final String FROM_PAREN = "from (";

    public static boolean showTransform() {
        return SHOW_TRANSFORM;
    }

    public AefTransformer(ConditionNode cNode) {
        this(cNode, null, null);
    }

    public AefTransformer(ConditionNode cNode, ConditionBlock.BlockType blockType, ArrayList<AefTransformer> childTransformers) {
        Preconditions.checkArgument((childTransformers == null || childTransformers.size() > 0 ? 1 : 0) != 0, (Object)"childTransformers must be null, or a non-empty List<>");
        this.cNode = cNode;
        if (cNode == null || cNode.isLeaf()) {
            this.blockType = blockType;
            this.children = childTransformers;
            this.arrayName = null;
            this.arrayMode = null;
            this.opType = null;
        } else {
            ConditionBlock block = (ConditionBlock)cNode;
            this.blockType = block.getType();
            this.opType = this.blockType.toOpTypeProto();
            FieldPath prefixPath = block.getPrefixPath();
            if (prefixPath != null) {
                this.arrayName = prefixPath.toString();
                this.arrayMode = Dbfilters.ArrayElementFilterProto.ArrayModeProto.ARRAY_ITERATE;
            } else {
                this.arrayName = null;
                this.arrayMode = null;
            }
            if (childTransformers != null) {
                this.children = childTransformers;
            } else {
                List<ConditionNode> blockChildren = block.getChildren();
                if (blockChildren == null) {
                    this.children = null;
                } else {
                    this.children = new ArrayList(blockChildren.size());
                    for (ConditionNode childNode : blockChildren) {
                        this.children.add(new AefTransformer(childNode));
                    }
                }
            }
        }
        this.format = Format.INTERMEDIATE;
    }

    public AefTransformer(AefTransformer childTransformer) {
        this(null, Dbfilters.ArrayElementFilterProto.OpTypeProto.MUST_PASS_ALL_ANY_ELEMENT, childTransformer);
    }

    private static <T> ArrayList<T> makeListOfOne(T t) {
        ArrayList<T> newList = new ArrayList<T>(1);
        newList.add(t);
        return newList;
    }

    public AefTransformer(String arrayName, Dbfilters.ArrayElementFilterProto.OpTypeProto opType, AefTransformer childTransformer) {
        this(arrayName, opType, AefTransformer.makeListOfOne(childTransformer));
    }

    public AefTransformer(String arrayName, Dbfilters.ArrayElementFilterProto.OpTypeProto opType, ArrayList<AefTransformer> childTransformers) {
        Preconditions.checkNotNull((Object)opType, (Object)"opType can't be null");
        this.cNode = null;
        this.blockType = ConditionBlock.BlockType.fromOpTypeProto(opType);
        this.children = childTransformers;
        this.arrayName = arrayName;
        this.arrayMode = Dbfilters.ArrayElementFilterProto.ArrayModeProto.ARRAY_ITERATE;
        this.opType = opType;
        this.format = Format.INTERMEDIATE;
    }

    private String getIteratedArray() {
        if (this.arrayMode == Dbfilters.ArrayElementFilterProto.ArrayModeProto.ARRAY_ITERATE) {
            if (this.arrayName == null) {
                return "";
            }
            return this.arrayName;
        }
        return null;
    }

    private void factorCommonArrayIterators() {
        String arrayName;
        if (this.children == null) {
            return;
        }
        for (AefTransformer childTransformer : this.children) {
            childTransformer.factorCommonArrayIterators();
        }
        ArrayList<AefTransformer> factoredChildren = new ArrayList<AefTransformer>(this.children.size());
        HashMap<String, ArrayList<AefTransformer>> aefGroups = new HashMap<String, ArrayList<AefTransformer>>(this.children.size());
        for (AefTransformer aefTransformer : this.children) {
            arrayName = aefTransformer.getIteratedArray();
            if (arrayName == null || aefTransformer.blockType == ConditionBlock.BlockType.elementAnd) {
                factoredChildren.add(aefTransformer);
                continue;
            }
            ArrayList<AefTransformer> arrayChildren = (ArrayList<AefTransformer>)aefGroups.get(arrayName);
            if (arrayChildren == null) {
                arrayChildren = new ArrayList<AefTransformer>(this.children.size());
                aefGroups.put(arrayName, arrayChildren);
            }
            arrayChildren.add(aefTransformer);
        }
        if (aefGroups.size() > 0) {
            for (Map.Entry entry : aefGroups.entrySet()) {
                Dbfilters.ArrayElementFilterProto.OpTypeProto useType;
                arrayName = (String)entry.getKey();
                List arrayTransforms = (List)entry.getValue();
                if (arrayTransforms.size() == 1) {
                    factoredChildren.add((AefTransformer)arrayTransforms.get(0));
                    continue;
                }
                ArrayList<AefTransformer> factoredChildList = new ArrayList<AefTransformer>(arrayTransforms.size());
                for (AefTransformer arrayChildTransform : arrayTransforms) {
                    factoredChildList.addAll(arrayChildTransform.children);
                }
                if (this.opType != null) {
                    useType = this.opType == Dbfilters.ArrayElementFilterProto.OpTypeProto.MUST_PASS_ALL_SAME_ELEMENT ? Dbfilters.ArrayElementFilterProto.OpTypeProto.MUST_PASS_ALL_ANY_ELEMENT : this.opType;
                } else if (this.cNode instanceof ConditionBlock) {
                    ConditionBlock cb = (ConditionBlock)this.cNode;
                    ConditionBlock.BlockType blockType = cb.getType();
                    useType = blockType.toOpTypeProto();
                } else {
                    throw new IllegalStateException();
                }
                AefTransformer newCommonParent = new AefTransformer(arrayName, useType, factoredChildList);
                newCommonParent.factorCommonArrayIterators();
                newCommonParent.format = Format.SERVER;
                factoredChildren.add(newCommonParent);
            }
        }
        assert (factoredChildren.size() <= this.children.size());
        this.children.clear();
        this.children.addAll(factoredChildren);
        this.format = Format.SERVER;
    }

    private AefTransformer removeSingleChildFilterLists() {
        if (this.children == null) {
            return this;
        }
        int nChildren = this.children.size();
        for (int i = 0; i < nChildren; ++i) {
            AefTransformer child = this.children.get(i);
            AefTransformer newChild = child.removeSingleChildFilterLists();
            if (newChild == child) continue;
            this.children.set(i, newChild);
        }
        if (this.blockType != null && this.arrayMode != Dbfilters.ArrayElementFilterProto.ArrayModeProto.ARRAY_ITERATE && this.blockType.isLogicalOperator() && this.children.size() == 1) {
            return this.children.get(0);
        }
        return this;
    }

    protected AefTransformer() {
        this.arrayName = null;
        this.blockType = null;
        this.children = null;
        this.cNode = null;
    }

    protected boolean isEmpty() {
        if (this.children != null) {
            return false;
        }
        if (this.cNode == null) {
            return true;
        }
        return this.arrayMode != null;
    }

    private AefTransformer removeEmptyTransformers() {
        if (this.children != null) {
            int nChildren = this.children.size();
            int writeChild = 0;
            for (int readChild = 0; readChild < nChildren; ++readChild) {
                AefTransformer thisChild = this.children.get(readChild);
                AefTransformer newChild = thisChild.removeEmptyTransformers();
                if (newChild == null) continue;
                if (writeChild != readChild || newChild != thisChild) {
                    this.children.set(writeChild, newChild);
                }
                ++writeChild;
            }
            if (writeChild < nChildren) {
                for (int i = nChildren - 1; i >= writeChild; --i) {
                    this.children.remove(i);
                }
            }
        }
        if ((this.children == null || this.children.size() == 0) && this.isEmpty()) {
            return EMPTY_TRANSFORMER;
        }
        return this;
    }

    private void markInnermostDimensions() {
        if (this.children == null || this.children.isEmpty()) {
            return;
        }
        for (AefTransformer childTransformer : this.children) {
            childTransformer.markInnermostDimensions();
            if (this.arrayMode == Dbfilters.ArrayElementFilterProto.ArrayModeProto.ARRAY_ITERATE) {
                if (childTransformer.arrayMode != Dbfilters.ArrayElementFilterProto.ArrayModeProto.ARRAY_ITERATE) {
                    this.innermostDimension = true;
                    continue;
                }
                String childArrayName = childTransformer.arrayName;
                if (childArrayName == null || childArrayName.isEmpty()) continue;
                if (this.arrayName == null || this.arrayName.isEmpty()) {
                    this.innermostDimension = true;
                    continue;
                }
                this.innermostDimension = true;
                continue;
            }
            assert (this.arrayName == null) : "arrayMode " + this.arrayMode + " arrayName " + this.arrayName;
        }
    }

    @VisibleForTesting
    public AefTransformer toServer() {
        this.factorCommonArrayIterators();
        AefTransformer newTransformer = this.removeSingleChildFilterLists();
        newTransformer = newTransformer.removeEmptyTransformers();
        newTransformer.markInnermostDimensions();
        return newTransformer;
    }

    public ConditionDescriptor getDescriptor(BiMap<FieldPath, Integer> pathIdMap, String iteratedArray, MapRDBIndexImplWrapper idxWrapper, int topEANDCf) {
        Dbfilters.ArrayElementFilterProto.ArrayModeProto newArrayMode;
        HashMap blockFamilyFieldPathsMap = Maps.newHashMap();
        if (this.cNode != null) {
            if (this.blockType == null) {
                assert (this.cNode.isLeaf());
                return this.cNode.getDescriptor(pathIdMap, idxWrapper);
            }
            if (this.blockType.isLogicalOperator() && iteratedArray == null) {
                Dbfilters.FilterListProto.Builder builder = Dbfilters.FilterListProto.newBuilder().setOperator(this.blockType.toOperatorProto());
                for (AefTransformer childTransformer : this.children) {
                    ConditionDescriptor child = childTransformer.getDescriptor(pathIdMap, iteratedArray, idxWrapper, topEANDCf);
                    if (child == null) continue;
                    builder.addFilters(child.getFilterMsg());
                    ConditionBlock.gatherChildFamilyFieldPaths(blockFamilyFieldPathsMap, child);
                }
                Dbfilters.FilterMsg filterMsg = Dbfilters.FilterMsg.newBuilder().setId("a42ebf64").setSerializedState(builder.build().toByteString()).build();
                ConditionDescriptor cd = new ConditionDescriptor(filterMsg, blockFamilyFieldPathsMap);
                return cd;
            }
        }
        assert (this.children != null && this.children.size() > 0);
        if (this.arrayMode != null) {
            newArrayMode = this.arrayMode;
        } else {
            this.arrayMode = newArrayMode = Dbfilters.ArrayElementFilterProto.ArrayModeProto.ARRAY_PASSTHROUGH;
        }
        Dbfilters.ArrayElementFilterProto.Builder builder = Dbfilters.ArrayElementFilterProto.newBuilder().setOp(this.opType).setArrayMode(newArrayMode);
        String newIteratedArray = this.arrayName != null && this.arrayName.length() > 0 ? this.arrayName : iteratedArray;
        if (this.innermostDimension) {
            builder.setIsInnermostDimension(true);
        }
        Map.Entry<Integer, FieldPath> cfCol = null;
        if (topEANDCf == -1) {
            Map<Integer, FieldPath> idMap = MapRDBTableImplHelper.getOneCFQualifier(FieldPath.parseFrom((String)newIteratedArray), pathIdMap, true);
            cfCol = idMap.entrySet().iterator().next();
            builder.setFamilyId(cfCol.getKey().intValue());
            if (this.arrayName != null && this.arrayName.length() > 0) {
                builder.setArrayFieldPath(cfCol.getValue().toString());
            }
        } else {
            builder.setFamilyId(topEANDCf);
            if (this.arrayName != null && this.arrayName.length() > 0) {
                builder.setArrayFieldPath(newIteratedArray);
            }
        }
        for (AefTransformer childTransformer : this.children) {
            ConditionDescriptor child = topEANDCf == -1 ? childTransformer.getDescriptor(pathIdMap, newIteratedArray, idxWrapper, cfCol.getKey()) : childTransformer.getDescriptor(pathIdMap, newIteratedArray, idxWrapper, topEANDCf);
            if (child == null) continue;
            builder.addChildFilters(child.getFilterMsg());
            ConditionBlock.gatherChildFamilyFieldPaths(blockFamilyFieldPathsMap, child);
        }
        Dbfilters.FilterMsg filterMsg = Dbfilters.FilterMsg.newBuilder().setId("deadbeef").setSerializedState(builder.build().toByteString()).build();
        ConditionDescriptor cd = new ConditionDescriptor(filterMsg, blockFamilyFieldPathsMap);
        return cd;
    }

    public void prettyPrint(StringBuilder sb, int depth) {
        int nSpaces = depth * 2;
        for (int i = 0; i < nSpaces; ++i) {
            sb.append(' ');
        }
        sb.append('[');
        sb.append(depth);
        CommaSeparated cs = new CommaSeparated(sb, "] AEFT(", ")\n");
        if (this.arrayMode != null) {
            cs.append("arrayMode = " + this.arrayMode);
        }
        if (this.innermostDimension) {
            cs.append("innermostDimension");
        }
        if (this.arrayName != null) {
            cs.append("arrayName = " + this.arrayName);
        }
        if (this.blockType != null) {
            cs.append("blockType = " + (Object)((Object)this.blockType));
        }
        if (this.cNode != null && !(this.cNode instanceof ConditionBlock)) {
            cs.append("cNode = " + this.cNode.toString());
        }
        if (this.format != null) {
            cs.append("format = " + (Object)((Object)this.format));
        }
        if (this.opType != null) {
            cs.append("opType = " + this.opType);
        }
        cs.build();
        if (this.children != null) {
            for (AefTransformer childTransformer : this.children) {
                childTransformer.prettyPrint(sb, depth + 1);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.prettyPrint(sb, 0);
        return sb.toString();
    }

    public static AefTransformer fromSerializedState(String filterHashCode, ByteString serializedState, boolean inArray, ConditionImpl topLevelCondition) {
        ConditionNode node;
        switch (filterHashCode) {
            case "d71875e1": {
                node = new AlwaysFalseCondition(topLevelCondition);
                break;
            }
            case "7846fa80": {
                node = new AlwaysTrueCondition(topLevelCondition);
                break;
            }
            case "469dbd04": 
            case "rk_filter": 
            case "8cbdcd12": 
            case "17544506": {
                node = new ConditionLeaf(filterHashCode, serializedState, topLevelCondition);
                break;
            }
            case "a42ebf64": {
                try {
                    Dbfilters.FilterListProto proto = Dbfilters.FilterListProto.parseFrom((ByteString)serializedState);
                    List filterMsgList = proto.getFiltersList();
                    ConditionBlock newBlock = new ConditionBlock(ConditionBlock.BlockType.fromOperatorProto(proto.getOperator()), topLevelCondition);
                    ArrayList<AefTransformer> childTransformers = new ArrayList<AefTransformer>(proto.getFiltersCount());
                    for (Dbfilters.FilterMsg filter : filterMsgList) {
                        String nodeId = filter.getId();
                        ByteString nodeState = filter.getSerializedState();
                        AefTransformer childTransformer = AefTransformer.fromSerializedState(nodeId, nodeState, inArray, topLevelCondition);
                        childTransformers.add(childTransformer);
                    }
                    newBlock.close();
                    AefTransformer newTransformer = new AefTransformer(newBlock, newBlock.getType(), childTransformers);
                    return newTransformer;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            case "deadbeef": {
                try {
                    Dbfilters.ArrayElementFilterProto proto = Dbfilters.ArrayElementFilterProto.parseFrom((ByteString)serializedState);
                    List filterMsgList = proto.getChildFiltersList();
                    int childCount = proto.getChildFiltersCount();
                    ArrayList<AefTransformer> childNodes = new ArrayList<AefTransformer>(childCount);
                    for (Dbfilters.FilterMsg filter : filterMsgList) {
                        String nodeId = filter.getId();
                        ByteString nodeState = filter.getSerializedState();
                        AefTransformer childTransformer = AefTransformer.fromSerializedState(nodeId, nodeState, inArray, topLevelCondition);
                        childNodes.add(childTransformer);
                    }
                    String arrayName = proto.hasArrayFieldPath() ? proto.getArrayFieldPath() : null;
                    AefTransformer newTransformer = new AefTransformer(arrayName, proto.getOp(), childNodes);
                    if (proto.hasArrayMode()) {
                        newTransformer.arrayMode = proto.getArrayMode();
                    }
                    return newTransformer;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to decode message", e);
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown filter in the serialized message: " + filterHashCode);
            }
        }
        return new AefTransformer(node);
    }

    private boolean isLeaf() {
        return this.cNode != null && this.cNode.isLeaf();
    }

    private void distributeArrayReference(String arrayName, ArrayList<AefTransformer> processedChildren, ConditionImpl topLevelCondition) {
        if (this.children == null) {
            return;
        }
        int nChildren = this.children.size();
        int nProcessed = 0;
        for (int readChild = 0; readChild < nChildren; ++readChild) {
            AefTransformer childTransformer = this.children.get(readChild);
            if (childTransformer.isLeaf()) {
                processedChildren.add(this.processLeaf(childTransformer, arrayName, topLevelCondition));
                ++nProcessed;
                continue;
            }
            AefTransformer newTransformer = childTransformer.distributeArrayReferences(topLevelCondition);
            if (newTransformer != childTransformer) {
                if (newTransformer.isLeaf()) {
                    processedChildren.add(this.processLeaf(newTransformer, arrayName, topLevelCondition));
                    ++nProcessed;
                    continue;
                }
                this.children.set(readChild, newTransformer);
            }
            if (newTransformer.arrayName == null && newTransformer.arrayMode == Dbfilters.ArrayElementFilterProto.ArrayModeProto.ARRAY_ITERATE && newTransformer.opType == Dbfilters.ArrayElementFilterProto.OpTypeProto.MUST_PASS_ALL_ANY_ELEMENT) {
                newTransformer.distributeArrayReference(arrayName + "[]", processedChildren, topLevelCondition);
                ++nProcessed;
                continue;
            }
            if (newTransformer.arrayName == null && newTransformer.arrayMode == null && newTransformer.opType == Dbfilters.ArrayElementFilterProto.OpTypeProto.MUST_PASS_ALL_ANY_ELEMENT) {
                newTransformer.distributeArrayReference(arrayName, processedChildren, topLevelCondition);
                ++nProcessed;
                continue;
            }
            ++nProcessed;
            processedChildren.add(newTransformer);
        }
        if (nProcessed != nChildren) {
            throw new IllegalStateException();
        }
    }

    AefTransformer processLeaf(AefTransformer leaf, String arrayName, ConditionImpl topLevelCondition) {
        ConditionLeaf childLeaf = (ConditionLeaf)leaf.cNode;
        String fieldName = childLeaf.getField().toString();
        String childField = arrayName;
        if (!fieldName.equals("$")) {
            childField = childField + "." + fieldName;
        }
        ConditionLeaf newLeaf = new ConditionLeaf(FieldPath.parseFrom((String)childField), childLeaf.getOp(), childLeaf.getValue(), childLeaf.getComparatorMode(), childLeaf, topLevelCondition);
        return new AefTransformer(newLeaf);
    }

    private AefTransformer distributeArrayReferences(ConditionImpl topLevelCondition) {
        if (this.children == null) {
            return this;
        }
        int nChildren = this.children.size();
        if (this.opType != Dbfilters.ArrayElementFilterProto.OpTypeProto.MUST_PASS_ALL_SAME_ELEMENT && this.arrayName != null && this.arrayMode == Dbfilters.ArrayElementFilterProto.ArrayModeProto.ARRAY_ITERATE) {
            ConditionBlock.BlockType newBlockType;
            ArrayList<AefTransformer> processedChildren = new ArrayList<AefTransformer>(nChildren);
            this.distributeArrayReference(this.arrayName + "[]", processedChildren, topLevelCondition);
            if (processedChildren.size() == 1) {
                return processedChildren.get(0);
            }
            if (this.blockType != null) {
                newBlockType = this.blockType;
            } else {
                assert (this.opType != null);
                newBlockType = ConditionBlock.BlockType.fromOpTypeProto(this.opType);
            }
            ConditionBlock newBlock = new ConditionBlock(newBlockType, topLevelCondition);
            for (AefTransformer childTransformer : processedChildren) {
                newBlock.add(childTransformer.cNode);
            }
            AefTransformer newTransformer = new AefTransformer(newBlock, newBlock.getType(), processedChildren);
            return newTransformer;
        }
        for (int readChild = 0; readChild < nChildren; ++readChild) {
            AefTransformer childTransformer = this.children.get(readChild);
            AefTransformer newTransformer = childTransformer.distributeArrayReferences(topLevelCondition);
            this.children.set(readChild, newTransformer);
        }
        return this;
    }

    private void mergeLogicalOperators(QueryCondition topLevelCondition) {
        if (this.children == null) {
            return;
        }
        for (AefTransformer childTransformer : this.children) {
            childTransformer.mergeLogicalOperators(topLevelCondition);
        }
        if (this.blockType == null || !this.blockType.isLogicalOperator()) {
            return;
        }
        ArrayList<AefTransformer> newChildren = null;
        ArrayList<AefTransformer> hasMergeable = null;
        int nChildren = this.children.size();
        for (AefTransformer childTransformer : this.children) {
            if (childTransformer.blockType != this.blockType) {
                if (newChildren == null) {
                    newChildren = new ArrayList<AefTransformer>(nChildren);
                }
                newChildren.add(childTransformer);
                continue;
            }
            if (hasMergeable == null) {
                hasMergeable = new ArrayList<AefTransformer>(nChildren);
            }
            hasMergeable.add(childTransformer);
        }
        if (hasMergeable == null) {
            return;
        }
        this.children.clear();
        if (newChildren != null) {
            this.children.addAll(newChildren);
        }
        for (AefTransformer mergeableChild : hasMergeable) {
            this.children.addAll(mergeableChild.children);
        }
    }

    public AefTransformer toClient(ConditionImpl topLevelCondition) {
        AefTransformer newTransform = this.distributeArrayReferences(topLevelCondition);
        newTransform.collapseElementBlocks();
        newTransform.mergeLogicalOperators(topLevelCondition);
        return newTransform;
    }

    private void collapseElementBlocks() {
        if (this.children == null) {
            return;
        }
        if (this.blockType == ConditionBlock.BlockType.elementAnd) {
            assert (this.arrayName != null);
            StringBuilder multiDimensionalArray = new StringBuilder(this.arrayName).append("[]");
            while (this.children.size() == 1) {
                AefTransformer childTransform = this.children.get(0);
                if (childTransform.blockType != ConditionBlock.BlockType.elementAnd || childTransform.arrayName != null) break;
                multiDimensionalArray.append("[]");
                this.children.clear();
                this.children.addAll(childTransform.children);
            }
            this.arrayName = multiDimensionalArray.toString();
        }
        for (AefTransformer childTransformer : this.children) {
            childTransformer.collapseElementBlocks();
        }
    }

    public ConditionNode toCondition(ConditionImpl topLevelCondition) {
        if (this.cNode != null && this.cNode.isLeaf()) {
            return this.cNode;
        }
        FieldPath arrayPath = this.arrayName == null ? null : FieldPath.parseFrom((String)this.arrayName);
        ConditionBlock cb = new ConditionBlock(this.blockType, topLevelCondition, arrayPath);
        if (this.children != null) {
            for (AefTransformer childTransformer : this.children) {
                ConditionNode childCondition = childTransformer.toCondition(topLevelCondition);
                cb.add(childCondition);
            }
        }
        this.cNode = cb;
        return cb;
    }

    private String getFlattenAlias(SqlTransformer sqlTransformer) {
        if (this.flattenAlias == null) {
            this.flattenAlias = sqlTransformer.makeUniqueId("f");
        }
        return this.flattenAlias;
    }

    private void findFlattenTiers(SqlTransformer sqlTransformer, AefTransformer priorFlatten, int flattenLayer) {
        if (this.arrayMode == Dbfilters.ArrayElementFilterProto.ArrayModeProto.ARRAY_ITERATE) {
            this.priorFlatten = priorFlatten;
            priorFlatten = this;
            sqlTransformer.addToFlattenLayer(flattenLayer, this);
            ++flattenLayer;
        }
        if (this.children == null || this.children.isEmpty()) {
            return;
        }
        for (AefTransformer childTransformer : this.children) {
            childTransformer.findFlattenTiers(sqlTransformer, priorFlatten, flattenLayer);
        }
    }

    public void appendSqlInSubquery(IndentingStringBuilder sb, SqlTransformer sqlTransformer) {
        this.findFlattenTiers(sqlTransformer, null, 0);
        Iterator<List<AefTransformer>> flattenListIter = sqlTransformer.flattenLayerIterator();
        if (!flattenListIter.hasNext()) {
            throw new IllegalStateException();
        }
        sb.pushIndent().nextLine();
        sb.append(SELECT_ID);
        String sourceTableAlias = sqlTransformer.makeUniqueId("t");
        try {
            AefTransformer.appendSubQuery(sb, sqlTransformer, flattenListIter, sourceTableAlias, this.blockType.getAssumedLogicalConnector());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void appendSqlConditions(IndentingStringBuilder sb, SqlTransformer sqlTransformer, String myTableAlias) throws Exception {
        if (this.children == null || this.children.isEmpty()) {
            return;
        }
        String opString = this.blockType.getAssumedLogicalConnector();
        String flattenAlias = this.getFlattenAlias(sqlTransformer);
        try (ParentheticalStringBuilder psb = new ParentheticalStringBuilder(sb);){
            boolean needOp = false;
            for (AefTransformer childTransformer : this.children) {
                if (childTransformer.cNode == null) continue;
                if (needOp) {
                    psb.append(opString);
                }
                int psbLength = psb.length();
                childTransformer.cNode.appendSqlArrayCondition((IndentingStringBuilder)psb, myTableAlias, flattenAlias);
                needOp = psb.length() > psbLength;
            }
        }
    }

    private static void appendSubQuery(IndentingStringBuilder sb, SqlTransformer sqlTransformer, Iterator<List<AefTransformer>> flattenListIter, String myTableAlias, String opString) throws Exception {
        List<AefTransformer> flattenList = flattenListIter.next();
        boolean hasNext = flattenListIter.hasNext();
        sb.pushIndent().nextLine();
        sb.append(FROM_PAREN);
        sb.pushIndent().nextLine();
        sb.append(SELECT_ID);
        String sourceTableAlias = hasNext ? sqlTransformer.makeUniqueId("t") : null;
        String layerOpString = null;
        for (AefTransformer transformer : flattenList) {
            String[] components;
            sb.append(", flatten(");
            if (hasNext) {
                sb.append(sourceTableAlias);
                sb.append('.');
                sb.append(transformer.priorFlatten.getFlattenAlias(sqlTransformer));
                sb.append('.');
            }
            sb.append(myTableAlias);
            for (String c : components = transformer.arrayName.split("\\.")) {
                sb.append('.');
                sb.append('`');
                sb.append(c);
                sb.append('`');
            }
            sb.append(") ");
            sb.append(transformer.getFlattenAlias(sqlTransformer));
            layerOpString = transformer.blockType.getAssumedLogicalConnector();
        }
        if (hasNext) {
            AefTransformer.appendSubQuery(sb, sqlTransformer, flattenListIter, sourceTableAlias, layerOpString);
        } else {
            sb.pushIndent().nextLine();
            sb.append("from ");
            sb.append(sqlTransformer.engineName);
            sb.append(".`");
            sb.append(sqlTransformer.tableName);
            sb.append('`');
            sb.append(" " + myTableAlias);
            sb.popIndent().popIndent().nextLine();
        }
        sb.append(") as ");
        sb.append(myTableAlias);
        sb.nextLine();
        PrependingStringBuilder psb = new PrependingStringBuilder(sb, "where ");
        boolean needOp = false;
        for (AefTransformer transformer : flattenList) {
            if (needOp) {
                psb.append(opString);
            }
            int psbLength = psb.length();
            transformer.appendSqlConditions((IndentingStringBuilder)psb, sqlTransformer, myTableAlias);
            needOp = psb.length() > psbLength;
        }
        sb.popIndent().popIndent().nextLine();
    }

    private static class EmptyTransformer
    extends AefTransformer {
        private EmptyTransformer() {
        }

        @Override
        public ConditionDescriptor getDescriptor(BiMap<FieldPath, Integer> pathIdMap, String iteratedArray, MapRDBIndexImplWrapper idxWrapper, int topEANDCf) {
            return ConditionDescriptor.EMPTY_DESC;
        }
    }

    static enum Format {
        INTERMEDIATE,
        USER,
        SERVER;

    }
}

