/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.mapr.db.Admin;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.exceptions.ExceptionHandler;
import com.mapr.db.impl.AdminImpl;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.jni.MapRUserInfo;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminProvider {
    private static Logger logger = LoggerFactory.getLogger(AdminProvider.class);
    LoadingCache<AdminKey, Admin> adminCache = CacheBuilder.newBuilder().maximumSize(50L).expireAfterAccess(1L, TimeUnit.DAYS).removalListener((RemovalListener)new RemovalListener<AdminKey, Admin>(){

        public void onRemoval(RemovalNotification<AdminKey, Admin> entry) {
            try {
                ((Admin)entry.getValue()).close();
            }
            catch (DBException e) {
                logger.warn(e.getMessage(), (Throwable)((Object)e));
            }
        }
    }).build((CacheLoader)new CacheLoader<AdminKey, Admin>(){

        public Admin load(AdminKey key) throws DBException {
            return new AdminImpl(key.conf);
        }
    });

    public Admin getAdmin(Configuration conf) {
        Preconditions.checkNotNull((Object)conf);
        try {
            MapRUserInfo userInfo = MapRFileSystem.CurrentUserInfo();
            return (Admin)this.adminCache.getUnchecked((Object)new AdminKey(userInfo, conf));
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "getAdmin()");
        }
    }

    private static class AdminKey {
        final MapRUserInfo user;
        final Configuration conf;

        public AdminKey(MapRUserInfo user, Configuration conf) {
            this.user = user;
            this.conf = conf;
        }

        public int hashCode() {
            return this.user.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AdminKey other = (AdminKey)obj;
            return !(this.user == null ? other.user != null : !this.user.equals((Object)other.user));
        }
    }
}

