/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async.auth;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import org.apache.zookeeper.server.auth.KerberosName;
import org.hbase.async.HBaseClient;
import org.hbase.async.auth.ClientAuthProvider;
import org.hbase.async.auth.Login;
import org.jboss.netty.util.HashedWheelTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosClientAuthProvider
extends ClientAuthProvider {
    public static final String PASSWORD_KEY = "hbase.regionserver.kerberos.password";
    public static final String PRINCIPAL_KEY = "hbase.kerberos.regionserver.principal";
    private static final Logger LOG = LoggerFactory.getLogger(KerberosClientAuthProvider.class);
    private String client_principal_name;

    public KerberosClientAuthProvider(HBaseClient hbase_client) {
        super(hbase_client);
        String password = null;
        if (hbase_client.getConfig().hasProperty(PASSWORD_KEY)) {
            password = hbase_client.getConfig().getString(PASSWORD_KEY);
        }
        try {
            Login.initUserIfNeeded(hbase_client.getConfig(), (HashedWheelTimer)hbase_client.getTimer(), hbase_client.getConfig().getString("hbase.sasl.clientconfig"), new ClientCallbackHandler(password));
        }
        catch (LoginException e) {
            throw new IllegalStateException("Failed to get login context", e);
        }
        Login client_login = Login.getCurrentLogin();
        this.client_principal_name = this.getClientPrincipalName(client_login);
    }

    @Override
    public SaslClient newSaslClient(String service_ip, final Map<String, String> props) {
        Login client_login = Login.getCurrentLogin();
        String server_principal = this.hbase_client.getConfig().getString(PRINCIPAL_KEY);
        if (server_principal.contains("_HOST")) {
            try {
                String host = InetAddress.getByName(service_ip).getCanonicalHostName();
                server_principal = server_principal.replaceAll("_HOST", host);
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException("Failed to resolve hostname for: " + service_ip, e);
            }
        }
        LOG.info("Connecting to " + server_principal);
        KerberosName service_kerberos_name = new KerberosName(server_principal);
        final String service_name = service_kerberos_name.getServiceName();
        final String service_hostname = service_kerberos_name.getHostName();
        try {
            final class PriviledgedAction
            implements PrivilegedExceptionAction<SaslClient> {
                PriviledgedAction() {
                }

                @Override
                public SaslClient run() throws Exception {
                    LOG.info("Client will use GSSAPI as SASL mechanism.");
                    String[] mechanism = new String[]{"GSSAPI"};
                    LOG.debug("Creating sasl client: client=" + KerberosClientAuthProvider.this.client_principal_name + ", service=" + service_name + ", serviceHostname=" + service_hostname);
                    return Sasl.createSaslClient(mechanism, null, service_name, service_hostname, props, null);
                }

                public String toString() {
                    return "create sasl client";
                }
            }
            return Subject.doAs(client_login.getSubject(), new PriviledgedAction());
        }
        catch (Exception e) {
            LOG.error("Error creating SASL client", (Throwable)e);
            throw new IllegalStateException("Error creating SASL client", e);
        }
    }

    @Override
    public String getClientUsername() {
        return this.client_principal_name;
    }

    @Override
    public byte getAuthMethodCode() {
        return 81;
    }

    @Override
    public Subject getClientSubject() {
        return Login.getCurrentLogin().getSubject();
    }

    private String getClientPrincipalName(Login login) {
        if (login.getSubject() == null) {
            return null;
        }
        Set<Principal> principals = login.getSubject().getPrincipals();
        if (principals == null || principals.isEmpty()) {
            return null;
        }
        Principal principal = principals.iterator().next();
        KerberosName name = new KerberosName(principal.getName());
        return name.toString();
    }

    static class ClientCallbackHandler
    implements CallbackHandler {
        private String password;

        public ClientCallbackHandler(String password) {
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                LOG.debug("Processing callback: " + callback.getClass());
                if (callback instanceof NameCallback) {
                    NameCallback name_callback = (NameCallback)callback;
                    name_callback.setName(name_callback.getDefaultName());
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback password_callback = (PasswordCallback)callback;
                    if (this.password != null) {
                        password_callback.setPassword(this.password.toCharArray());
                        continue;
                    }
                    LOG.warn("Could not login: the client is being asked for a password, but the  client code does not currently support obtaining a password from the user. Make sure that the client is configured to use a ticket cache (using the JAAS configuration setting 'useTicketCache=true)' and restart the client. If you still get this message after that, the TGT in the ticket cache has expired and must be manually refreshed. To do so, first determine if you are using a password or a keytab. If the former, run kinit in a Unix shell in the environment of the user who is running this asynchbase client using the command 'kinit <princ>' (where <princ> is the name of the client's Kerberos principal). If the latter, do 'kinit -k -t <keytab> <princ>' (where <princ> is the name of the Kerberos principal, and <keytab> is the location of the keytab file). After manually refreshing your cache, restart this client. If you continue to see this message after manually refreshing your cache, ensure that your KDC host's clock is in sync with this host's clock.");
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    RealmCallback realm_callback = (RealmCallback)callback;
                    realm_callback.setText(realm_callback.getDefaultText());
                    continue;
                }
                if (callback instanceof AuthorizeCallback) {
                    String authzid;
                    AuthorizeCallback authorize_callback = (AuthorizeCallback)callback;
                    String authid = authorize_callback.getAuthenticationID();
                    if (authid.equals(authzid = authorize_callback.getAuthorizationID())) {
                        authorize_callback.setAuthorized(true);
                        authorize_callback.setAuthorizedID(authzid);
                        continue;
                    }
                    authorize_callback.setAuthorized(false);
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL ClientCallback: " + callback.getClass());
            }
        }
    }
}

