/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import org.hbase.async.BatchableRpc;
import org.hbase.async.Bytes;
import org.hbase.async.GetRequest;
import org.hbase.async.HBaseRpc;
import org.hbase.async.InvalidResponseException;
import org.hbase.async.KeyValue;
import org.hbase.async.RowLock;
import org.hbase.async.generated.ClientPB;
import org.hbase.async.generated.HBasePB;
import org.jboss.netty.buffer.ChannelBuffer;

public final class AppendRequest
extends BatchableRpc
implements HBaseRpc.HasTable,
HBaseRpc.HasKey,
HBaseRpc.HasFamily,
HBaseRpc.HasQualifiers,
HBaseRpc.HasValues,
HBaseRpc.IsEdit,
HBaseRpc.HasQualifier,
HBaseRpc.HasValue {
    private static final byte[] APPEND = new byte[]{97, 112, 112, 101, 110, 100};
    private static final byte[] RETURN_RESULTS = new byte[]{95, 114, 114, 95};
    static final byte CODE = 78;
    private final byte[][] qualifiers;
    private final byte[][] values;
    private boolean return_result = false;

    public AppendRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, byte[] value) {
        this(table, key, family, qualifier, value, Long.MAX_VALUE, -1L);
    }

    public AppendRequest(byte[] table, byte[] key, byte[] family, byte[][] qualifiers, byte[][] values) {
        this(table, key, family, qualifiers, values, Long.MAX_VALUE, -1L, false);
    }

    public AppendRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, byte[] value, long timestamp) {
        this(table, key, family, qualifier, value, timestamp, -1L);
    }

    public AppendRequest(byte[] table, byte[] key, byte[] family, byte[][] qualifiers, byte[][] values, long timestamp) {
        this(table, key, family, qualifiers, values, timestamp, -1L, false);
    }

    public AppendRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, byte[] value, RowLock lock) {
        this(table, key, family, qualifier, value, Long.MAX_VALUE, lock.id());
    }

    public AppendRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, byte[] value, long timestamp, RowLock lock) {
        this(table, key, family, qualifier, value, timestamp, lock.id());
    }

    public AppendRequest(byte[] table, byte[] key, byte[] family, byte[][] qualifiers, byte[][] values, long timestamp, RowLock lock) {
        this(table, key, family, qualifiers, values, timestamp, lock.id(), false);
    }

    public AppendRequest(String table, String key, String family, String qualifier, String value) {
        this(table.getBytes(), key.getBytes(), family.getBytes(), qualifier.getBytes(), value.getBytes(), Long.MAX_VALUE, -1L);
    }

    public AppendRequest(String table, String key, String family, String qualifier, String value, RowLock lock) {
        this(table.getBytes(), key.getBytes(), family.getBytes(), qualifier.getBytes(), value.getBytes(), Long.MAX_VALUE, lock.id());
    }

    public AppendRequest(byte[] table, KeyValue kv) {
        this(table, kv, -1L);
    }

    public AppendRequest(byte[] table, KeyValue kv, RowLock lock) {
        this(table, kv, lock.id());
    }

    private AppendRequest(byte[] table, KeyValue kv, long lockid) {
        super(table, kv.key(), kv.family(), kv.timestamp(), lockid);
        this.qualifiers = new byte[][]{kv.qualifier()};
        this.values = new byte[][]{kv.value()};
    }

    private AppendRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, byte[] value, long timestamp, long lockid) {
        this(table, key, family, new byte[][]{qualifier}, new byte[][]{value}, timestamp, lockid, false);
    }

    private AppendRequest(byte[] table, byte[] key, byte[] family, byte[][] qualifiers, byte[][] values, long timestamp, long lockid, boolean return_result) {
        super(table, key, family, timestamp, lockid);
        KeyValue.checkFamily(family);
        if (qualifiers.length != values.length) {
            throw new IllegalArgumentException("Have " + qualifiers.length + " qualifiers and " + values.length + " values.  Should be equal.");
        }
        if (qualifiers.length == 0) {
            throw new IllegalArgumentException("Need at least one qualifier/value.");
        }
        for (int i = 0; i < qualifiers.length; ++i) {
            KeyValue.checkQualifier(qualifiers[i]);
            KeyValue.checkValue(values[i]);
        }
        this.qualifiers = qualifiers;
        this.values = values;
    }

    @Override
    byte[] method(byte server_version) {
        if (server_version >= 95) {
            return MUTATE;
        }
        return APPEND;
    }

    @Override
    public byte[] table() {
        return this.table;
    }

    @Override
    public byte[] key() {
        return this.key;
    }

    @Override
    public byte[] qualifier() {
        return this.qualifiers[0];
    }

    @Override
    public byte[][] qualifiers() {
        return this.qualifiers;
    }

    @Override
    public byte[] value() {
        return this.values[0];
    }

    @Override
    public byte[][] values() {
        return this.values;
    }

    @Override
    public String toString() {
        return super.toStringWithQualifiers("AppendRequest", this.family, this.qualifiers, this.values, ", timestamp=" + this.timestamp + ", lockid=" + this.lockid + ", durable=" + this.durable + ", return_result=" + this.return_result + ", bufferable=" + this.bufferable);
    }

    public void returnResult(boolean return_result) {
        this.return_result = return_result;
    }

    public boolean returnResult() {
        return this.return_result;
    }

    @Override
    byte version(byte server_version) {
        if (server_version >= 29) {
            return 2;
        }
        return 1;
    }

    @Override
    byte code() {
        return 78;
    }

    @Override
    int numKeyValues() {
        return this.qualifiers.length;
    }

    @Override
    int payloadSize() {
        int size = 0;
        for (int i = 0; i < this.qualifiers.length; ++i) {
            size += KeyValue.predictSerializedSize(this.key, this.family, this.qualifiers[i], this.values[i]);
        }
        return size;
    }

    @Override
    void serializePayload(ChannelBuffer buf) {
        for (int i = 0; i < this.qualifiers.length; ++i) {
            KeyValue.serialize(buf, (byte)4, this.timestamp, this.key, this.family, this.qualifiers[i], this.values[i]);
        }
    }

    private int predictSerializedSize() {
        int size = 0;
        size += 4;
        ++size;
        size += 3;
        size += this.region.name().length;
        size += this.predictAppendSize();
        size += 4;
        size += 4;
        size += 4;
        ++size;
        return ++size;
    }

    int predictAppendSize() {
        int size = 0;
        ++size;
        ++size;
        ++size;
        size += 3;
        size += this.key.length;
        size += 8;
        size += 8;
        ++size;
        size += 4;
        ++size;
        size += this.family.length;
        size += 4;
        size += 4;
        return size += this.payloadSize();
    }

    @Override
    ClientPB.MutationProto toMutationProto() {
        byte[] byArray;
        ClientPB.MutationProto.ColumnValue.Builder columns = ClientPB.MutationProto.ColumnValue.newBuilder().setFamily(Bytes.wrap(this.family));
        for (int i = 0; i < this.qualifiers.length; ++i) {
            ClientPB.MutationProto.ColumnValue.QualifierValue column = ClientPB.MutationProto.ColumnValue.QualifierValue.newBuilder().setQualifier(Bytes.wrap(this.qualifiers[i])).setValue(Bytes.wrap(this.values[i])).setTimestamp(this.timestamp).build();
            columns.addQualifierValue(column);
        }
        ClientPB.MutationProto.Builder append = ClientPB.MutationProto.newBuilder().setRow(Bytes.wrap(this.key)).setMutateType(ClientPB.MutationProto.MutationType.APPEND).addColumnValue(columns);
        if (!this.durable) {
            append.setDurability(ClientPB.MutationProto.Durability.SKIP_WAL);
        }
        HBasePB.NameBytesPair nameBytePair = HBasePB.NameBytesPair.getDefaultInstance();
        HBasePB.NameBytesPair.Builder builder = nameBytePair.toBuilder().setNameBytes(ByteString.copyFrom((byte[])RETURN_RESULTS));
        if (this.return_result) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = -1;
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = 0;
        }
        append.addAttribute(builder.setValue(ByteString.copyFrom((byte[])byArray)));
        return append.build();
    }

    @Override
    ChannelBuffer serialize(byte server_version) {
        if (server_version < 95) {
            return this.serializeOld(server_version);
        }
        ClientPB.MutateRequest req = ClientPB.MutateRequest.newBuilder().setRegion(this.region.toProtobuf()).setMutation(this.toMutationProto()).build();
        return AppendRequest.toChannelBuffer(MUTATE, (AbstractMessageLite)req);
    }

    private ChannelBuffer serializeOld(byte server_version) {
        ChannelBuffer buf = this.newBuffer(server_version, this.predictSerializedSize());
        buf.writeInt(2);
        AppendRequest.writeHBaseByteArray(buf, this.region.name());
        this.serializeInto(buf);
        return buf;
    }

    void serializeInto(ChannelBuffer buf) {
        buf.writeByte(78);
        buf.writeByte(78);
        buf.writeByte(1);
        AppendRequest.writeByteArray(buf, this.key);
        buf.writeLong(this.timestamp);
        buf.writeLong(this.lockid);
        buf.writeByte(this.durable ? 1 : 0);
        buf.writeInt(1);
        AppendRequest.writeByteArray(buf, this.family);
        buf.writeInt(this.qualifiers.length);
        buf.writeInt(this.payloadSize());
        this.serializePayload(buf);
        buf.writeInt(1);
        buf.writeInt(4);
        buf.writeBytes(RETURN_RESULTS);
        buf.writeByte(1);
        buf.writeByte(this.return_result ? 1 : 0);
    }

    @Override
    Object deserialize(ChannelBuffer buf, int cell_size) {
        if (!this.return_result) {
            HBaseRpc.ensureNoCell(cell_size);
        }
        ClientPB.MutateResponse resp = AppendRequest.readProtobuf(buf, ClientPB.MutateResponse.PARSER);
        ClientPB.Result result = resp.getResult();
        if (this.return_result) {
            ArrayList<KeyValue> kvs = GetRequest.convertResult(result, buf, cell_size);
            if (kvs.size() != 1) {
                throw new InvalidResponseException("Atomic increment returned " + kvs.size() + " KeyValue(s), but we expected exactly one. kvs=" + kvs, (Object)resp);
            }
            return kvs.get(0);
        }
        return null;
    }
}

