/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.utils.Utils;

public class SslFactory
implements Reconfigurable {
    private final Mode mode;
    private final String clientAuthConfigOverride;
    private final boolean keystoreVerifiableUsingTruststore;
    private String protocol;
    private String provider;
    private String kmfAlgorithm;
    private String tmfAlgorithm;
    private SecurityStore keystore = null;
    private SecurityStore truststore;
    private String[] cipherSuites;
    private String[] disabledcipherSuites;
    private String[] enabledProtocols;
    private String[] disabledProtocols;
    private String endpointIdentification;
    private SecureRandom secureRandomImplementation;
    private SSLContext sslContext;
    private boolean needClientAuth;
    private boolean wantClientAuth;

    public SslFactory(Mode mode) {
        this(mode, null, false);
    }

    public SslFactory(Mode mode, String clientAuthConfigOverride, boolean keystoreVerifiableUsingTruststore) {
        this.mode = mode;
        this.clientAuthConfigOverride = clientAuthConfigOverride;
        this.keystoreVerifiableUsingTruststore = keystoreVerifiableUsingTruststore;
    }

    @Override
    public void configure(Map<String, ?> configs) throws KafkaException {
        String clientAuthConfig;
        String secureRandomImplementation;
        String endpointIdentification;
        List disabledProtocolsList;
        List enabledProtocolsList;
        List disabledCipherSuitesList;
        this.protocol = (String)configs.get("ssl.protocol");
        this.provider = (String)configs.get("ssl.provider");
        List cipherSuitesList = (List)configs.get("ssl.cipher.suites");
        if (cipherSuitesList != null && !cipherSuitesList.isEmpty()) {
            this.cipherSuites = cipherSuitesList.toArray(new String[cipherSuitesList.size()]);
        }
        if ((disabledCipherSuitesList = (List)configs.get("ssl.cipher.suites.exclude")) != null && !disabledCipherSuitesList.isEmpty()) {
            this.disabledcipherSuites = disabledCipherSuitesList.toArray(new String[disabledCipherSuitesList.size()]);
        }
        if ((enabledProtocolsList = (List)configs.get("ssl.enabled.protocols")) != null && !enabledProtocolsList.isEmpty()) {
            this.enabledProtocols = enabledProtocolsList.toArray(new String[enabledProtocolsList.size()]);
        }
        if ((disabledProtocolsList = (List)configs.get("ssl.disabled.protocols")) != null && !disabledProtocolsList.isEmpty()) {
            this.disabledProtocols = disabledProtocolsList.toArray(new String[disabledProtocolsList.size()]);
        }
        if ((endpointIdentification = (String)configs.get("ssl.endpoint.identification.algorithm")) != null) {
            this.endpointIdentification = endpointIdentification;
        }
        if ((secureRandomImplementation = (String)configs.get("ssl.secure.random.implementation")) != null) {
            try {
                this.secureRandomImplementation = SecureRandom.getInstance(secureRandomImplementation);
            }
            catch (GeneralSecurityException e) {
                throw new KafkaException(e);
            }
        }
        if ((clientAuthConfig = this.clientAuthConfigOverride) == null) {
            clientAuthConfig = (String)configs.get("ssl.client.auth");
        }
        if (clientAuthConfig != null) {
            if (clientAuthConfig.equals("required")) {
                this.needClientAuth = true;
            } else if (clientAuthConfig.equals("requested")) {
                this.wantClientAuth = true;
            }
        }
        this.kmfAlgorithm = (String)configs.get("ssl.keymanager.algorithm");
        this.tmfAlgorithm = (String)configs.get("ssl.trustmanager.algorithm");
        this.keystore = this.createKeystore((String)configs.get("ssl.keystore.type"), (String)configs.get("ssl.keystore.location"), (Password)configs.get("ssl.keystore.password"), (Password)configs.get("ssl.key.password"));
        this.truststore = this.createTruststore((String)configs.get("ssl.truststore.type"), (String)configs.get("ssl.truststore.location"), (Password)configs.get("ssl.truststore.password"));
        try {
            this.sslContext = this.createSSLContext(this.keystore);
        }
        catch (Exception e) {
            throw new KafkaException(e);
        }
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return SslConfigs.RECONFIGURABLE_CONFIGS;
    }

    @Override
    public void validateReconfiguration(Map<String, ?> configs) {
        try {
            SecurityStore newKeystore = this.maybeCreateNewKeystore(configs);
            if (newKeystore != null) {
                this.createSSLContext(newKeystore);
            }
        }
        catch (Exception e) {
            throw new ConfigException("Validation of dynamic config update failed", (Object)e);
        }
    }

    @Override
    public void reconfigure(Map<String, ?> configs) throws KafkaException {
        SecurityStore newKeystore = this.maybeCreateNewKeystore(configs);
        if (newKeystore != null) {
            try {
                this.sslContext = this.createSSLContext(newKeystore);
                this.keystore = newKeystore;
            }
            catch (Exception e) {
                throw new ConfigException("Reconfiguration of SSL keystore failed", (Object)e);
            }
        }
    }

    private SecurityStore maybeCreateNewKeystore(Map<String, ?> configs) {
        boolean keystoreChanged;
        boolean bl = keystoreChanged = Objects.equals(configs.get("ssl.keystore.type"), this.keystore.type) || Objects.equals(configs.get("ssl.keystore.location"), this.keystore.path) || Objects.equals(configs.get("ssl.keystore.password"), this.keystore.password) || Objects.equals(configs.get("ssl.key.password"), this.keystore.keyPassword);
        if (keystoreChanged) {
            return this.createKeystore((String)configs.get("ssl.keystore.type"), (String)configs.get("ssl.keystore.location"), (Password)configs.get("ssl.keystore.password"), (Password)configs.get("ssl.key.password"));
        }
        return null;
    }

    SSLContext createSSLContext(SecurityStore keystore) throws GeneralSecurityException, IOException {
        SSLContext sslContext = this.provider != null ? SSLContext.getInstance(this.protocol, this.provider) : SSLContext.getInstance(this.protocol);
        KeyManager[] keyManagers = null;
        if (keystore != null) {
            String kmfAlgorithm = this.kmfAlgorithm != null ? this.kmfAlgorithm : KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(kmfAlgorithm);
            KeyStore ks = keystore.load();
            Password keyPassword = keystore.keyPassword != null ? keystore.keyPassword : keystore.password;
            kmf.init(ks, keyPassword.value().toCharArray());
            keyManagers = kmf.getKeyManagers();
        }
        String tmfAlgorithm = this.tmfAlgorithm != null ? this.tmfAlgorithm : TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
        KeyStore ts = this.truststore == null ? null : this.truststore.load();
        tmf.init(ts);
        sslContext.init(keyManagers, tmf.getTrustManagers(), this.secureRandomImplementation);
        if (keystore != null && keystore != this.keystore) {
            if (this.keystore == null) {
                throw new ConfigException("Cannot add SSL keystore to an existing listener for which no keystore was configured.");
            }
            if (this.keystoreVerifiableUsingTruststore) {
                SSLConfigValidatorEngine.validate(this, sslContext);
            }
            if (!CertificateEntries.create(this.keystore.load()).equals(CertificateEntries.create(keystore.load()))) {
                throw new ConfigException("Keystore DistinguishedName or SubjectAltNames do not match");
            }
        }
        return sslContext;
    }

    public SSLEngine createSslEngine(String peerHost, int peerPort) {
        return this.createSslEngine(this.sslContext, peerHost, peerPort);
    }

    private SSLEngine createSslEngine(SSLContext sslContext, String peerHost, int peerPort) {
        SSLEngine sslEngine = sslContext.createSSLEngine(peerHost, peerPort);
        HashSet<String> suites = new HashSet<String>(Arrays.asList(this.cipherSuites));
        suites.removeAll(Arrays.asList(this.disabledcipherSuites));
        if (this.cipherSuites != null) {
            sslEngine.setEnabledCipherSuites(suites.toArray(new String[suites.size()]));
        }
        HashSet<String> protocols = new HashSet<String>(Arrays.asList(this.enabledProtocols));
        protocols.removeAll(Arrays.asList(this.disabledProtocols));
        if (this.enabledProtocols != null) {
            sslEngine.setEnabledProtocols(protocols.toArray(new String[protocols.size()]));
        }
        if (this.mode == Mode.SERVER) {
            sslEngine.setUseClientMode(false);
            if (this.needClientAuth) {
                sslEngine.setNeedClientAuth(this.needClientAuth);
            } else {
                sslEngine.setWantClientAuth(this.wantClientAuth);
            }
        } else {
            sslEngine.setUseClientMode(true);
            SSLParameters sslParams = sslEngine.getSSLParameters();
            sslParams.setEndpointIdentificationAlgorithm(this.endpointIdentification);
            sslEngine.setSSLParameters(sslParams);
        }
        return sslEngine;
    }

    public SSLContext sslContext() {
        return this.sslContext;
    }

    private SecurityStore createKeystore(String type, String path, Password password, Password keyPassword) {
        if (path == null && password != null) {
            throw new KafkaException("SSL key store is not specified, but key store password is specified.");
        }
        if (path != null && password == null) {
            throw new KafkaException("SSL key store is specified, but key store password is not specified.");
        }
        if (path != null && password != null) {
            return new SecurityStore(type, path, password, keyPassword);
        }
        return null;
    }

    private SecurityStore createTruststore(String type, String path, Password password) {
        if (path == null && password != null) {
            throw new KafkaException("SSL trust store is not specified, but trust store password is specified.");
        }
        if (path != null) {
            return new SecurityStore(type, path, password, null);
        }
        return null;
    }

    static class CertificateEntries {
        private final Principal subjectPrincipal;
        private final Set<List<?>> subjectAltNames;

        static List<CertificateEntries> create(KeyStore keystore) throws GeneralSecurityException, IOException {
            Enumeration<String> aliases = keystore.aliases();
            ArrayList<CertificateEntries> entries = new ArrayList<CertificateEntries>();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate cert = keystore.getCertificate(alias);
                if (!(cert instanceof X509Certificate)) continue;
                entries.add(new CertificateEntries((X509Certificate)cert));
            }
            return entries;
        }

        CertificateEntries(X509Certificate cert) throws GeneralSecurityException {
            this.subjectPrincipal = cert.getSubjectX500Principal();
            Collection<List<?>> altNames = cert.getSubjectAlternativeNames();
            this.subjectAltNames = altNames != null ? new HashSet(altNames) : Collections.emptySet();
        }

        public int hashCode() {
            return Objects.hash(this.subjectPrincipal, this.subjectAltNames);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CertificateEntries)) {
                return false;
            }
            CertificateEntries other = (CertificateEntries)obj;
            return Objects.equals(this.subjectPrincipal, other.subjectPrincipal) && Objects.equals(this.subjectAltNames, other.subjectAltNames);
        }

        public String toString() {
            return "subjectPrincipal=" + this.subjectPrincipal + ", subjectAltNames=" + this.subjectAltNames;
        }
    }

    static class SSLConfigValidatorEngine {
        private static final ByteBuffer EMPTY_BUF = ByteBuffer.allocate(0);
        private final SSLEngine sslEngine;
        private SSLEngineResult handshakeResult;
        private ByteBuffer appBuffer;
        private ByteBuffer netBuffer;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void validate(SslFactory sslFactory, SSLContext sslContext) throws SSLException {
            SSLConfigValidatorEngine clientEngine = new SSLConfigValidatorEngine(sslFactory, sslContext, Mode.CLIENT);
            SSLConfigValidatorEngine serverEngine = new SSLConfigValidatorEngine(sslFactory, sslContext, Mode.SERVER);
            try {
                clientEngine.beginHandshake();
                serverEngine.beginHandshake();
                while (!serverEngine.complete() || !clientEngine.complete()) {
                    clientEngine.handshake(serverEngine);
                    serverEngine.handshake(clientEngine);
                }
            }
            finally {
                clientEngine.close();
                serverEngine.close();
            }
        }

        private SSLConfigValidatorEngine(SslFactory sslFactory, SSLContext sslContext, Mode mode) {
            this.sslEngine = sslFactory.createSslEngine(sslContext, "localhost", 0);
            this.sslEngine.setUseClientMode(mode == Mode.CLIENT);
            this.appBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getApplicationBufferSize());
            this.netBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize());
        }

        void beginHandshake() throws SSLException {
            this.sslEngine.beginHandshake();
        }

        void handshake(SSLConfigValidatorEngine peerEngine) throws SSLException {
            SSLEngineResult.HandshakeStatus handshakeStatus = this.sslEngine.getHandshakeStatus();
            block16: while (true) {
                switch (handshakeStatus) {
                    case NEED_WRAP: {
                        this.handshakeResult = this.sslEngine.wrap(EMPTY_BUF, this.netBuffer);
                        switch (this.handshakeResult.getStatus()) {
                            case OK: {
                                break;
                            }
                            case BUFFER_OVERFLOW: {
                                this.netBuffer.compact();
                                this.netBuffer = Utils.ensureCapacity(this.netBuffer, this.sslEngine.getSession().getPacketBufferSize());
                                this.netBuffer.flip();
                                break;
                            }
                            default: {
                                throw new SSLException("Unexpected handshake status: " + (Object)((Object)this.handshakeResult.getStatus()));
                            }
                        }
                        return;
                    }
                    case NEED_UNWRAP: {
                        if (peerEngine.netBuffer.position() == 0) {
                            return;
                        }
                        peerEngine.netBuffer.flip();
                        this.handshakeResult = this.sslEngine.unwrap(peerEngine.netBuffer, this.appBuffer);
                        peerEngine.netBuffer.compact();
                        handshakeStatus = this.handshakeResult.getHandshakeStatus();
                        switch (this.handshakeResult.getStatus()) {
                            case OK: {
                                continue block16;
                            }
                            case BUFFER_OVERFLOW: {
                                this.appBuffer = Utils.ensureCapacity(this.appBuffer, this.sslEngine.getSession().getApplicationBufferSize());
                                continue block16;
                            }
                            case BUFFER_UNDERFLOW: {
                                this.netBuffer = Utils.ensureCapacity(this.netBuffer, this.sslEngine.getSession().getPacketBufferSize());
                                continue block16;
                            }
                        }
                        throw new SSLException("Unexpected handshake status: " + (Object)((Object)this.handshakeResult.getStatus()));
                    }
                    case NEED_TASK: {
                        this.sslEngine.getDelegatedTask().run();
                        handshakeStatus = this.sslEngine.getHandshakeStatus();
                        continue block16;
                    }
                    case FINISHED: {
                        return;
                    }
                    case NOT_HANDSHAKING: {
                        if (this.handshakeResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) {
                            throw new SSLException("Did not finish handshake");
                        }
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException("Unexpected handshake status " + (Object)((Object)handshakeStatus));
        }

        boolean complete() {
            return this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED || this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }

        void close() {
            this.sslEngine.closeOutbound();
            try {
                this.sslEngine.closeInbound();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class SecurityStore {
        private final String type;
        private final String path;
        private final Password password;
        private final Password keyPassword;

        SecurityStore(String type, String path, Password password, Password keyPassword) {
            Objects.requireNonNull(type, "type must not be null");
            this.type = type;
            this.path = path;
            this.password = password;
            this.keyPassword = keyPassword;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        KeyStore load() {
            try (FileInputStream in = new FileInputStream(this.path);){
                KeyStore ks = KeyStore.getInstance(this.type);
                char[] passwordChars = this.password != null ? this.password.value().toCharArray() : null;
                ks.load(in, passwordChars);
                KeyStore keyStore = ks;
                return keyStore;
            }
            catch (IOException | GeneralSecurityException e) {
                throw new KafkaException("Failed to load SSL keystore " + this.path + " of type " + this.type, e);
            }
        }
    }
}

