/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.mapr.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.InvalidTopicException;

public class MapRTopicUtils {
    public static final String LEGAL_CHARS = "[a-zA-Z0-9._-]";
    public static final String LEAGAL_FULLTOPICNAME_PATTERN = String.format("(\\/%s+)+\\:%s+", "[a-zA-Z0-9._-]", "[a-zA-Z0-9._-]");

    public static void validateFullTopicName(String fullTopicName) {
        if (!fullTopicName.matches(LEAGAL_FULLTOPICNAME_PATTERN)) {
            throw new InvalidTopicException(String.format("Full topic name %s is invalid. It should be %s", fullTopicName, LEAGAL_FULLTOPICNAME_PATTERN));
        }
    }

    public static boolean isFullTopicName(String fullTopicName) {
        return fullTopicName.startsWith("/") && fullTopicName.contains(":");
    }

    public static String buildFullTopicName(String streamName, String shortTopicName) {
        return String.format("%s:%s", streamName, shortTopicName);
    }

    public static List<String> decorateTopicsWithDefaultStreamIfNeeded(List<String> topics, String defaultStream) {
        ArrayList<String> res = new ArrayList<String>(topics.size());
        Iterator<String> iterator = topics.iterator();
        while (iterator.hasNext()) {
            String topic;
            String decoratedTopic = topic = iterator.next();
            if (!topic.contains(":")) {
                if (defaultStream.isEmpty()) {
                    throw new InvalidTopicException(String.format("Default stream is not specified. Short topic name %s is invalid.", topic));
                }
                decoratedTopic = String.format("%s:%s", defaultStream, topic);
            }
            MapRTopicUtils.validateFullTopicName(decoratedTopic);
            res.add(decoratedTopic);
        }
        return res;
    }

    public static List<String> addStreamNameToTopics(List<String> topics, String stream) {
        LinkedList<String> res = new LinkedList<String>();
        for (String topic : topics) {
            res.add(MapRTopicUtils.buildFullTopicName(stream, topic));
        }
        return res;
    }

    public static Map<String, Set<String>> groupTopicsByStreamName(List<String> topics) {
        HashMap<String, Set<String>> res = new HashMap<String, Set<String>>();
        for (String topic : topics) {
            String[] parts = topic.split(":");
            String streamName = parts[0];
            String shortTopicName = parts[1];
            HashSet<String> groupedTopics = (HashSet<String>)res.get(streamName);
            if (groupedTopics == null) {
                groupedTopics = new HashSet<String>();
                res.put(streamName, groupedTopics);
            }
            groupedTopics.add(shortTopicName);
        }
        return res;
    }

    public static Map<String, Set<String>> allTopicsForStreamSet(Set<String> streamSet) {
        return MapRTopicUtils.allTopicsForStreamSet(streamSet, AdminClient.create(new Properties()));
    }

    public static Map<String, Set<String>> allTopicsForStreamSet(Set<String> streamSet, AdminClient adminClient) {
        HashMap<String, Set<String>> res = new HashMap<String, Set<String>>();
        try {
            for (String streamName : streamSet) {
                res.put(streamName, adminClient.listTopics(streamName).names().get(60L, TimeUnit.SECONDS));
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new KafkaException(e);
        }
        finally {
            adminClient.close();
        }
        return res;
    }
}

