/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerInterceptor;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.ConsumerCoordinator;
import org.apache.kafka.clients.consumer.internals.ConsumerInterceptors;
import org.apache.kafka.clients.consumer.internals.ConsumerMetrics;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.Fetcher;
import org.apache.kafka.clients.consumer.internals.NoOpConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.mapr.GenericHFactory;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;

public class KafkaConsumer<K, V>
implements Consumer<K, V> {
    private static final long NO_CURRENT_THREAD = -1L;
    private static final AtomicInteger CONSUMER_CLIENT_ID_SEQUENCE = new AtomicInteger(1);
    private static final String JMX_PREFIX = "kafka.consumer";
    static final long DEFAULT_CLOSE_TIMEOUT_MS = 30000L;
    Metrics metrics;
    private final Logger log;
    private String clientId;
    private ConsumerCoordinator coordinator;
    private Deserializer<K> keyDeserializer;
    private Deserializer<V> valueDeserializer;
    private Fetcher<K, V> fetcher;
    private ConsumerInterceptors<K, V> interceptors;
    private Time time;
    private ConsumerNetworkClient client;
    private SubscriptionState subscriptions;
    private Metadata metadata;
    private long retryBackoffMs;
    private long requestTimeoutMs;
    private volatile boolean closed = false;
    private List<PartitionAssignor> assignors;
    private final AtomicLong currentThread = new AtomicLong(-1L);
    private final AtomicInteger refcount = new AtomicInteger(0);
    private final LogContext logContext;
    private final ConsumerConfig config;
    private boolean isStreams = false;
    private boolean isStreamsClosed = false;
    private Consumer<K, V> consumerDriver = null;
    private String defaultStream = null;

    public KafkaConsumer(Map<String, Object> configs) {
        this(configs, null, null);
    }

    public KafkaConsumer(Map<String, Object> configs, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this(new ConsumerConfig(ConsumerConfig.addDeserializerToConfig(configs, keyDeserializer, valueDeserializer)), keyDeserializer, valueDeserializer);
    }

    public KafkaConsumer(Properties properties) {
        this(properties, (Deserializer<K>)null, (Deserializer<V>)null);
    }

    public KafkaConsumer(Properties properties, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this(new ConsumerConfig(ConsumerConfig.addDeserializerToConfig(properties, keyDeserializer, valueDeserializer)), keyDeserializer, valueDeserializer);
    }

    private KafkaConsumer(ConsumerConfig config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        String clientId = config.getString("client.id");
        if (clientId.isEmpty()) {
            clientId = "consumer-" + CONSUMER_CLIENT_ID_SEQUENCE.getAndIncrement();
        }
        this.clientId = clientId;
        String groupId = config.getString("group.id");
        this.logContext = new LogContext("[Consumer clientId=" + clientId + ", groupId=" + groupId + "] ");
        this.log = this.logContext.logger(this.getClass());
        this.log.debug("Starting the Kafka consumer");
        this.config = config;
        this.keyDeserializer = keyDeserializer;
        this.valueDeserializer = valueDeserializer;
        this.closed = false;
        this.isStreams = false;
        this.isStreamsClosed = false;
        if (keyDeserializer == null) {
            this.keyDeserializer = config.getConfiguredInstance("key.deserializer", Deserializer.class);
            this.keyDeserializer.configure(config.originals(), true);
        } else {
            config.ignore("key.deserializer");
            this.keyDeserializer = keyDeserializer;
        }
        if (valueDeserializer == null) {
            this.valueDeserializer = config.getConfiguredInstance("value.deserializer", Deserializer.class);
            this.valueDeserializer.configure(config.originals(), false);
        } else {
            config.ignore("value.deserializer");
            this.valueDeserializer = valueDeserializer;
        }
        this.defaultStream = null;
        try {
            this.defaultStream = config.getString("streams.consumer.default.stream");
            if (this.defaultStream == "") {
                this.defaultStream = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.defaultStream != null) {
            this.initializeConsumer(this.defaultStream + ":");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeConsumer(String topic) {
        KafkaConsumer kafkaConsumer = this;
        synchronized (kafkaConsumer) {
            if (this.isStreamsClosed) {
                this.log.error("cannot initialize consumer. already closed.");
                return;
            }
            if (this.consumerDriver != null) {
                this.log.debug("initialized consumer already.");
                return;
            }
            Map<String, Object> userProvidedConfigs = this.config.originals();
            userProvidedConfigs.put("client.id", this.clientId);
            List interceptorList = new ConsumerConfig(userProvidedConfigs, false).getConfiguredInstances("interceptor.classes", ConsumerInterceptor.class);
            this.interceptors = new ConsumerInterceptors(interceptorList);
            if (topic.startsWith("/") || topic.contains(":")) {
                try {
                    Class.forName("com.mapr.streams.impl.MarlinClient");
                }
                catch (Throwable e) {
                    throw new RuntimeException(String.format("Error occurred while instantiating class, com.mapr.streams.impl.MarlinClient. " + e.getMessage(), new Object[0]), e);
                }
                GenericHFactory consumerFactory = new GenericHFactory();
                Consumer ac = (Consumer)consumerFactory.getImplementorInstance("com.mapr.streams.impl.listener.MarlinListenerV10", new Object[]{this.config, this.keyDeserializer, this.valueDeserializer, this.interceptors}, ConsumerConfig.class, Deserializer.class, Deserializer.class, ConsumerInterceptors.class);
                this.isStreams = true;
                this.consumerDriver = ac;
            } else {
                this.isStreams = false;
                this.consumerDriver = this;
                List<InetSocketAddress> kafkaaddresses = ClientUtils.parseAndValidateAddresses(this.config.getList("bootstrap.servers"));
                if (kafkaaddresses.size() == 0 || kafkaaddresses.get(0).equals("")) {
                    throw new KafkaException("Bootstrap servers not specified in configuration");
                }
                try {
                    this.log.debug("Initializing the Kafka consumer");
                    String groupId = this.config.getString("group.id");
                    this.requestTimeoutMs = this.config.getInt("request.timeout.ms").intValue();
                    int sessionTimeOutMs = this.config.getInt("session.timeout.ms");
                    int fetchMaxWaitMs = this.config.getInt("fetch.max.wait.ms");
                    if (this.requestTimeoutMs <= (long)sessionTimeOutMs || this.requestTimeoutMs <= (long)fetchMaxWaitMs) {
                        throw new ConfigException("request.timeout.ms should be greater than session.timeout.ms and fetch.max.wait.ms");
                    }
                    this.time = Time.SYSTEM;
                    Map<String, String> metricsTags = Collections.singletonMap("client-id", this.clientId);
                    MetricConfig metricConfig = new MetricConfig().samples(this.config.getInt("metrics.num.samples")).timeWindow(this.config.getLong("metrics.sample.window.ms"), TimeUnit.MILLISECONDS).recordLevel(Sensor.RecordingLevel.forName(this.config.getString("metrics.recording.level"))).tags(metricsTags);
                    List<MetricsReporter> reporters = this.config.getConfiguredInstances("metric.reporters", MetricsReporter.class);
                    reporters.add(new JmxReporter(JMX_PREFIX));
                    this.metrics = new Metrics(metricConfig, reporters, this.time);
                    this.retryBackoffMs = this.config.getLong("retry.backoff.ms");
                    if (this.keyDeserializer == null) {
                        this.keyDeserializer = this.config.getConfiguredInstance("key.deserializer", Deserializer.class);
                        this.keyDeserializer.configure(this.config.originals(), true);
                    } else {
                        this.config.ignore("key.deserializer");
                        this.keyDeserializer = this.keyDeserializer;
                    }
                    if (this.valueDeserializer == null) {
                        this.valueDeserializer = this.config.getConfiguredInstance("value.deserializer", Deserializer.class);
                        this.valueDeserializer.configure(this.config.originals(), false);
                    } else {
                        this.config.ignore("value.deserializer");
                        this.valueDeserializer = this.valueDeserializer;
                    }
                    ClusterResourceListeners clusterResourceListeners = this.configureClusterResourceListeners(this.keyDeserializer, this.valueDeserializer, reporters, interceptorList);
                    this.metadata = new Metadata(this.retryBackoffMs, this.config.getLong("metadata.max.age.ms"), true, false, clusterResourceListeners);
                    List<InetSocketAddress> addresses = ClientUtils.parseAndValidateAddresses(this.config.getList("bootstrap.servers"));
                    this.metadata.update(Cluster.bootstrap(addresses), Collections.emptySet(), 0L);
                    String metricGrpPrefix = "consumer";
                    ConsumerMetrics metricsRegistry = new ConsumerMetrics(metricsTags.keySet(), "consumer");
                    ChannelBuilder channelBuilder = ClientUtils.createChannelBuilder(this.config);
                    IsolationLevel isolationLevel = IsolationLevel.valueOf(this.config.getString("isolation.level").toUpperCase(Locale.ROOT));
                    Sensor throttleTimeSensor = Fetcher.throttleTimeSensor(this.metrics, metricsRegistry.fetcherMetrics);
                    int heartbeatIntervalMs = this.config.getInt("heartbeat.interval.ms");
                    NetworkClient netClient = new NetworkClient(new Selector(this.config.getLong("connections.max.idle.ms"), this.metrics, this.time, metricGrpPrefix, channelBuilder, this.logContext), this.metadata, this.clientId, 100, this.config.getLong("reconnect.backoff.ms"), this.config.getLong("reconnect.backoff.max.ms"), this.config.getInt("send.buffer.bytes"), this.config.getInt("receive.buffer.bytes"), this.config.getInt("request.timeout.ms"), this.time, true, new ApiVersions(), throttleTimeSensor, this.logContext);
                    this.client = new ConsumerNetworkClient(this.logContext, netClient, this.metadata, this.time, this.retryBackoffMs, this.config.getInt("request.timeout.ms").intValue(), heartbeatIntervalMs);
                    OffsetResetStrategy offsetResetStrategy = OffsetResetStrategy.valueOf(this.config.getString("auto.offset.reset").toUpperCase(Locale.ROOT));
                    this.subscriptions = new SubscriptionState(offsetResetStrategy);
                    this.assignors = this.config.getConfiguredInstances("partition.assignment.strategy", PartitionAssignor.class);
                    this.coordinator = new ConsumerCoordinator(this.logContext, this.client, groupId, this.config.getInt("max.poll.interval.ms"), this.config.getInt("session.timeout.ms"), heartbeatIntervalMs, this.assignors, this.metadata, this.subscriptions, this.metrics, metricGrpPrefix, this.time, this.retryBackoffMs, this.config.getBoolean("enable.auto.commit"), this.config.getLong("auto.commit.interval.ms"), this.interceptors, this.config.getBoolean("exclude.internal.topics"), this.config.getBoolean("internal.leave.group.on.close"));
                    this.fetcher = new Fetcher<K, V>(this.logContext, this.client, this.config.getInt("fetch.min.bytes"), this.config.getInt("fetch.max.bytes"), this.config.getInt("fetch.max.wait.ms"), this.config.getInt("max.partition.fetch.bytes"), this.config.getInt("max.poll.records"), this.config.getBoolean("check.crcs"), this.keyDeserializer, this.valueDeserializer, this.metadata, this.subscriptions, this.metrics, metricsRegistry.fetcherMetrics, this.time, this.retryBackoffMs, this.requestTimeoutMs, isolationLevel);
                    this.config.logUnused();
                    AppInfoParser.registerAppInfo(JMX_PREFIX, this.clientId, this.metrics);
                    this.log.debug("Kafka consumer initialized");
                }
                catch (Throwable t) {
                    this.close(0L, true);
                    throw new KafkaException("Failed to construct kafka consumer", t);
                }
            }
        }
    }

    KafkaConsumer(LogContext logContext, String clientId, ConsumerCoordinator coordinator, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, Fetcher<K, V> fetcher, ConsumerInterceptors<K, V> interceptors, Time time, ConsumerNetworkClient client, Metrics metrics, SubscriptionState subscriptions, Metadata metadata, long retryBackoffMs, long requestTimeoutMs, List<PartitionAssignor> assignors) {
        this.config = null;
        this.logContext = logContext;
        this.log = logContext.logger(this.getClass());
        this.clientId = clientId;
        this.coordinator = coordinator;
        this.keyDeserializer = keyDeserializer;
        this.valueDeserializer = valueDeserializer;
        this.fetcher = fetcher;
        this.interceptors = Objects.requireNonNull(interceptors);
        this.time = time;
        this.client = client;
        this.metrics = metrics;
        this.subscriptions = subscriptions;
        this.metadata = metadata;
        this.retryBackoffMs = retryBackoffMs;
        this.requestTimeoutMs = requestTimeoutMs;
        this.assignors = assignors;
    }

    private boolean useDefaultStreamName(String topicname) {
        return !topicname.startsWith("/");
    }

    private String addDefaultStreamNameToTopicName(String topicname) {
        return this.defaultStream + ":" + topicname;
    }

    private TopicPartition addDefaultStreamNameToTopicPartition(TopicPartition tp) {
        return new TopicPartition(this.addDefaultStreamNameToTopicName(tp.topic()), tp.partition());
    }

    private TopicPartition getNewTopicPartitionWithDefaultStream(TopicPartition tp) {
        if (this.defaultStream != null && this.useDefaultStreamName(tp.topic())) {
            return this.addDefaultStreamNameToTopicPartition(tp);
        }
        return tp;
    }

    private String getNewTopicNameWithDefaultStream(String topic) {
        if (this.defaultStream != null && this.useDefaultStreamName(topic)) {
            return this.addDefaultStreamNameToTopicName(topic);
        }
        return topic;
    }

    private boolean checkIfPartitionsNeedDefaultStream(Collection<TopicPartition> partitions) {
        boolean needDefault = false;
        if (this.defaultStream != null) {
            for (TopicPartition tp : partitions) {
                if (!this.useDefaultStreamName(tp.topic())) continue;
                needDefault = true;
                break;
            }
        }
        return needDefault;
    }

    private boolean checkIfTopicsNeedDefaultStream(Collection<String> topics) {
        boolean needDefault = false;
        if (this.defaultStream != null) {
            for (String topic : topics) {
                if (!this.useDefaultStreamName(topic)) continue;
                needDefault = true;
                break;
            }
        }
        return needDefault;
    }

    private Collection<TopicPartition> getNewPartitionCollectionWithDefaultStream(Collection<TopicPartition> partitions) {
        if (this.checkIfPartitionsNeedDefaultStream(partitions)) {
            ArrayList<TopicPartition> newPartitions = new ArrayList<TopicPartition>(partitions.size());
            for (TopicPartition partition : partitions) {
                if (this.useDefaultStreamName(partition.topic())) {
                    partition = this.addDefaultStreamNameToTopicPartition(partition);
                }
                newPartitions.add(partition);
            }
            return newPartitions;
        }
        return partitions;
    }

    private Map<TopicPartition, ? extends Object> getNewPartitionMapWithDefaultStream(Map<TopicPartition, ? extends Object> partitions) {
        if (this.checkIfPartitionsNeedDefaultStream(partitions.keySet())) {
            HashMap<TopicPartition, Object> newPartitions = new HashMap<TopicPartition, Object>();
            for (Map.Entry<TopicPartition, ? extends Object> entry : partitions.entrySet()) {
                TopicPartition tp = entry.getKey();
                if (this.useDefaultStreamName(tp.topic())) {
                    tp = this.addDefaultStreamNameToTopicPartition(tp);
                }
                newPartitions.put(tp, entry.getValue());
            }
            return newPartitions;
        }
        return partitions;
    }

    private Collection<String> getNewTopicCollectionWithDefaultStream(Collection<String> topics) {
        if (this.checkIfTopicsNeedDefaultStream(topics)) {
            ArrayList<String> newTopics = new ArrayList<String>(topics.size());
            for (String topic : topics) {
                if (this.useDefaultStreamName(topic)) {
                    topic = this.addDefaultStreamNameToTopicName(topic);
                }
                newTopics.add(topic);
            }
            return newTopics;
        }
        return topics;
    }

    @Override
    public Set<TopicPartition> assignment() {
        if (this.consumerDriver == null) {
            return new HashSet<TopicPartition>();
        }
        if (this.isStreams) {
            return this.consumerDriver.assignment();
        }
        this.acquireAndEnsureOpen();
        try {
            Set<TopicPartition> set = Collections.unmodifiableSet(new HashSet<TopicPartition>(this.subscriptions.assignedPartitions()));
            return set;
        }
        finally {
            this.release();
        }
    }

    @Override
    public Set<String> subscription() {
        if (this.consumerDriver == null) {
            return new HashSet<String>();
        }
        if (this.isStreams) {
            return this.consumerDriver.subscription();
        }
        this.acquireAndEnsureOpen();
        try {
            Set<String> set = Collections.unmodifiableSet(new HashSet<String>(this.subscriptions.subscription()));
            return set;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(Collection<String> topics, ConsumerRebalanceListener listener) {
        if (topics.size() == 0) {
            this.log.debug("Subscribing to empty topics list");
            return;
        }
        if (this.consumerDriver == null) {
            this.initializeConsumer(topics.iterator().next());
        }
        if (this.consumerDriver == null) {
            this.log.error("consumer closed, cannot subscribe");
            return;
        }
        if (this.isStreams) {
            topics = this.getNewTopicCollectionWithDefaultStream(topics);
            this.consumerDriver.subscribe(topics, listener);
        } else {
            this.acquireAndEnsureOpen();
            try {
                if (topics == null) {
                    throw new IllegalArgumentException("Topic collection to subscribe to cannot be null");
                }
                if (topics.isEmpty()) {
                    this.unsubscribe();
                } else {
                    for (String topic : topics) {
                        if (topic != null && !topic.trim().isEmpty()) continue;
                        throw new IllegalArgumentException("Topic collection to subscribe to cannot contain null or empty topic");
                    }
                    this.throwIfNoAssignorsConfigured();
                    this.log.debug("Subscribed to topic(s): {}", (Object)Utils.join(topics, ", "));
                    this.subscriptions.subscribe(new HashSet<String>(topics), listener);
                    this.metadata.setTopics(this.subscriptions.groupSubscription());
                }
            }
            finally {
                this.release();
            }
        }
    }

    @Override
    public void subscribe(List<String> topics, ConsumerRebalanceListener listener) {
        this.subscribe((Collection<String>)topics, listener);
    }

    @Override
    public void subscribe(Collection<String> topics) {
        this.subscribe(topics, (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
    }

    @Override
    public void subscribe(List<String> topics) {
        this.subscribe(topics, (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
    }

    @Override
    public void subscribe(Pattern pattern, ConsumerRebalanceListener listener) {
        if (this.consumerDriver == null) {
            this.initializeConsumer(pattern.toString());
        }
        if (this.consumerDriver == null) {
            this.log.error("consumer closed, cannot subscribe");
            return;
        }
        if (this.isStreams) {
            pattern = Pattern.compile(this.getNewTopicNameWithDefaultStream(pattern.toString()));
            this.consumerDriver.subscribe(pattern, listener);
        } else {
            this.acquireAndEnsureOpen();
            try {
                if (pattern == null) {
                    throw new IllegalArgumentException("Topic pattern to subscribe to cannot be null");
                }
                this.throwIfNoAssignorsConfigured();
                this.log.debug("Subscribed to pattern: {}", (Object)pattern);
                this.subscriptions.subscribe(pattern, listener);
                this.metadata.needMetadataForAllTopics(true);
                this.coordinator.updatePatternSubscription(this.metadata.fetch());
                this.metadata.requestUpdate();
            }
            finally {
                this.release();
            }
        }
    }

    @Override
    public void subscribe(Pattern pattern) {
        this.subscribe(pattern, (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
    }

    @Override
    public void unsubscribe() {
        if (this.consumerDriver == null) {
            this.log.error("consumer closed, cannot subscribe");
            return;
        }
        if (this.isStreams) {
            this.consumerDriver.unsubscribe();
        } else {
            this.acquireAndEnsureOpen();
            try {
                this.log.debug("Unsubscribed all topics or patterns and assigned partitions");
                this.subscriptions.unsubscribe();
                this.coordinator.maybeLeaveGroup();
                this.metadata.needMetadataForAllTopics(false);
            }
            finally {
                this.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assign(Collection<TopicPartition> partitions) {
        if (partitions.size() == 0) {
            this.log.debug("assigning empty partitions list");
            return;
        }
        if (this.consumerDriver == null) {
            this.initializeConsumer(partitions.iterator().next().topic());
        }
        if (this.consumerDriver == null) {
            this.log.error("consumer closed, cannot subscribe");
            return;
        }
        if (this.isStreams) {
            partitions = this.getNewPartitionCollectionWithDefaultStream(partitions);
            this.consumerDriver.assign(partitions);
        } else {
            this.acquireAndEnsureOpen();
            try {
                if (partitions == null) {
                    throw new IllegalArgumentException("Topic partition collection to assign to cannot be null");
                }
                if (partitions.isEmpty()) {
                    this.unsubscribe();
                } else {
                    HashSet<String> topics = new HashSet<String>();
                    for (TopicPartition tp : partitions) {
                        String topic;
                        String string = topic = tp != null ? tp.topic() : null;
                        if (topic == null || topic.trim().isEmpty()) {
                            throw new IllegalArgumentException("Topic partitions to assign to cannot have null or empty topic");
                        }
                        topics.add(topic);
                    }
                    this.coordinator.maybeAutoCommitOffsetsAsync(this.time.milliseconds());
                    this.log.debug("Subscribed to partition(s): {}", (Object)Utils.join(partitions, ", "));
                    this.subscriptions.assignFromUser(new HashSet<TopicPartition>(partitions));
                    this.metadata.setTopics(topics);
                }
            }
            finally {
                this.release();
            }
        }
    }

    @Override
    public void assign(List<TopicPartition> partitions) {
        this.assign((Collection<TopicPartition>)partitions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsumerRecords<K, V> poll(long timeout) {
        if (this.consumerDriver == null) {
            throw new IllegalStateException("No active subscriptions");
        }
        if (this.isStreams) {
            ConsumerRecords<K, V> records = this.consumerDriver.poll(timeout);
            if (this.interceptors != null) {
                records = this.interceptors.onConsume(records);
            }
            return records;
        }
        this.acquireAndEnsureOpen();
        try {
            long elapsed;
            if (timeout < 0L) {
                throw new IllegalArgumentException("Timeout must not be negative");
            }
            if (this.subscriptions.hasNoSubscriptionOrUserAssignment()) {
                throw new IllegalStateException("Consumer is not subscribed to any topics or assigned any partitions");
            }
            long start = this.time.milliseconds();
            long remaining = timeout;
            do {
                Map<TopicPartition, List<ConsumerRecord<K, V>>> records;
                if ((records = this.pollOnce(remaining)).isEmpty()) continue;
                if (this.fetcher.sendFetches() > 0 || this.client.hasPendingRequests()) {
                    this.client.pollNoWakeup();
                }
                ConsumerRecords<K, V> consumerRecords = this.interceptors.onConsume(new ConsumerRecords<K, V>(records));
                return consumerRecords;
            } while ((remaining = timeout - (elapsed = this.time.milliseconds() - start)) > 0L);
            ConsumerRecords consumerRecords = ConsumerRecords.empty();
            return consumerRecords;
        }
        finally {
            this.release();
        }
    }

    private Map<TopicPartition, List<ConsumerRecord<K, V>>> pollOnce(long timeout) {
        this.client.maybeTriggerWakeup();
        long startMs = this.time.milliseconds();
        this.coordinator.poll(startMs, timeout);
        boolean hasAllFetchPositions = this.updateFetchPositions();
        Map<TopicPartition, List<ConsumerRecord<K, V>>> records = this.fetcher.fetchedRecords();
        if (!records.isEmpty()) {
            return records;
        }
        this.fetcher.sendFetches();
        long nowMs = this.time.milliseconds();
        long remainingTimeMs = Math.max(0L, timeout - (nowMs - startMs));
        long pollTimeout = Math.min(this.coordinator.timeToNextPoll(nowMs), remainingTimeMs);
        if (!hasAllFetchPositions && pollTimeout > this.retryBackoffMs) {
            pollTimeout = this.retryBackoffMs;
        }
        this.client.poll(pollTimeout, nowMs, new ConsumerNetworkClient.PollCondition(){

            @Override
            public boolean shouldBlock() {
                return !KafkaConsumer.this.fetcher.hasCompletedFetches();
            }
        });
        if (this.coordinator.needRejoin()) {
            return Collections.emptyMap();
        }
        return this.fetcher.fetchedRecords();
    }

    @Override
    public void commitSync() {
        if (this.consumerDriver == null) {
            throw new IllegalStateException("No active subscriptions");
        }
        if (this.isStreams) {
            this.consumerDriver.commitSync();
        } else {
            this.acquireAndEnsureOpen();
            try {
                this.coordinator.commitOffsetsSync(this.subscriptions.allConsumed(), Long.MAX_VALUE);
            }
            finally {
                this.release();
            }
        }
    }

    @Override
    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets) {
        if (offsets.size() == 0) {
            this.log.debug("commitSync called with empty offsets");
            return;
        }
        if (this.consumerDriver == null) {
            Set<TopicPartition> partitions = offsets.keySet();
            this.initializeConsumer(partitions.iterator().next().topic());
        }
        if (this.consumerDriver == null) {
            this.log.error("consumer closed, cannot commit");
            return;
        }
        if (this.isStreams) {
            Map<TopicPartition, Object> newoffsets = this.getNewPartitionMapWithDefaultStream(offsets);
            this.consumerDriver.commitSync(newoffsets);
        } else {
            this.acquireAndEnsureOpen();
            try {
                this.coordinator.commitOffsetsSync(new HashMap<TopicPartition, OffsetAndMetadata>(offsets), Long.MAX_VALUE);
            }
            finally {
                this.release();
            }
        }
    }

    @Override
    public void commitAsync() {
        this.commitAsync(null);
    }

    @Override
    public void commitAsync(OffsetCommitCallback callback) {
        if (this.consumerDriver == null) {
            throw new IllegalStateException("No active subscriptions");
        }
        if (this.isStreams) {
            this.consumerDriver.commitAsync(callback);
        } else {
            this.acquireAndEnsureOpen();
            try {
                this.commitAsync(this.subscriptions.allConsumed(), callback);
            }
            finally {
                this.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> offsets, OffsetCommitCallback callback) {
        if (offsets.size() == 0) {
            this.log.debug("commitAsync with no offsets");
            callback.onComplete(offsets, null);
            return;
        }
        if (this.consumerDriver == null) {
            Set<TopicPartition> partitions = offsets.keySet();
            this.initializeConsumer(partitions.iterator().next().topic());
        }
        if (this.consumerDriver == null) {
            this.log.error("consumer closed, cannot commit");
            return;
        }
        if (this.isStreams) {
            Map<TopicPartition, Object> newOffsets = this.getNewPartitionMapWithDefaultStream(offsets);
            this.consumerDriver.commitAsync(newOffsets, callback);
        } else {
            this.acquireAndEnsureOpen();
            try {
                this.log.debug("Committing offsets: {}", offsets);
                this.coordinator.commitOffsetsAsync(new HashMap<TopicPartition, OffsetAndMetadata>(offsets), callback);
            }
            finally {
                this.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seek(TopicPartition partition, long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("seek offset must not be a negative number");
        }
        if (this.consumerDriver == null) {
            this.initializeConsumer(partition.topic());
        }
        if (this.consumerDriver == null) {
            this.log.error("consumer closed, cannot seek");
            return;
        }
        if (this.isStreams) {
            partition = this.getNewTopicPartitionWithDefaultStream(partition);
            this.consumerDriver.seek(partition, offset);
        } else {
            this.acquireAndEnsureOpen();
            try {
                if (offset < 0L) {
                    throw new IllegalArgumentException("seek offset must not be a negative number");
                }
                this.log.debug("Seeking to offset {} for partition {}", (Object)offset, (Object)partition);
                this.subscriptions.seek(partition, offset);
            }
            finally {
                this.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seekToBeginning(Collection<TopicPartition> partitions) {
        if (this.consumerDriver == null) {
            this.initializeConsumer(partitions.iterator().next().topic());
        }
        if (this.consumerDriver == null) {
            this.log.error("consumer closed, cannot seek");
            return;
        }
        if (this.isStreams) {
            partitions = this.getNewPartitionCollectionWithDefaultStream(partitions);
            this.consumerDriver.seekToBeginning(partitions);
        } else {
            this.acquireAndEnsureOpen();
            try {
                if (partitions == null) {
                    throw new IllegalArgumentException("Partitions collection cannot be null");
                }
                Collection<TopicPartition> parts = partitions.size() == 0 ? this.subscriptions.assignedPartitions() : partitions;
                for (TopicPartition tp : parts) {
                    this.log.debug("Seeking to beginning of partition {}", (Object)tp);
                    this.subscriptions.requestOffsetReset(tp, OffsetResetStrategy.EARLIEST);
                }
            }
            finally {
                this.release();
            }
        }
    }

    @Override
    @Deprecated
    public void seekToBeginning(TopicPartition ... partitions) {
        this.seekToBeginning(Arrays.asList(partitions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seekToEnd(Collection<TopicPartition> partitions) {
        if (this.consumerDriver == null) {
            this.initializeConsumer(partitions.iterator().next().topic());
        }
        if (this.consumerDriver == null) {
            this.log.error("consumer closed, cannot seek");
            return;
        }
        if (this.isStreams) {
            partitions = this.getNewPartitionCollectionWithDefaultStream(partitions);
            this.consumerDriver.seekToEnd(partitions);
        } else {
            this.acquireAndEnsureOpen();
            try {
                if (partitions == null) {
                    throw new IllegalArgumentException("Partitions collection cannot be null");
                }
                Collection<TopicPartition> parts = partitions.size() == 0 ? this.subscriptions.assignedPartitions() : partitions;
                for (TopicPartition tp : parts) {
                    this.log.debug("Seeking to end of partition {}", (Object)tp);
                    this.subscriptions.requestOffsetReset(tp, OffsetResetStrategy.LATEST);
                }
            }
            finally {
                this.release();
            }
        }
    }

    @Override
    @Deprecated
    public void seekToEnd(TopicPartition ... partitions) {
        this.seekToEnd(Arrays.asList(partitions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(TopicPartition partition) {
        if (this.consumerDriver == null) {
            this.initializeConsumer(partition.topic());
        }
        if (this.consumerDriver == null) {
            this.log.error("consumer closed, cannot get position");
            throw new NoOffsetForPartitionException(partition);
        }
        if (this.isStreams) {
            partition = this.getNewTopicPartitionWithDefaultStream(partition);
            return this.consumerDriver.position(partition);
        }
        this.acquireAndEnsureOpen();
        try {
            if (!this.subscriptions.isAssigned(partition)) {
                throw new IllegalArgumentException("You can only check the position for partitions assigned to this consumer.");
            }
            Long offset = this.subscriptions.position(partition);
            while (offset == null) {
                this.updateFetchPositions();
                this.client.poll(this.retryBackoffMs);
                offset = this.subscriptions.position(partition);
            }
            long l = offset;
            return l;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OffsetAndMetadata committed(TopicPartition partition) {
        if (this.consumerDriver == null) {
            this.initializeConsumer(partition.topic());
        }
        if (this.consumerDriver == null) {
            this.log.error("consumer closed, cannot get committed");
            throw new NoOffsetForPartitionException(partition);
        }
        if (this.isStreams) {
            partition = this.getNewTopicPartitionWithDefaultStream(partition);
            return this.consumerDriver.committed(partition);
        }
        this.acquireAndEnsureOpen();
        try {
            Map<TopicPartition, OffsetAndMetadata> offsets = this.coordinator.fetchCommittedOffsets(Collections.singleton(partition));
            OffsetAndMetadata offsetAndMetadata = offsets.get(partition);
            return offsetAndMetadata;
        }
        finally {
            this.release();
        }
    }

    @Override
    public Map<MetricName, ? extends Metric> metrics() {
        if (this.consumerDriver == null) {
            this.log.info("consumed not initialized, cannot get metrics");
            return null;
        }
        if (this.isStreams) {
            return this.consumerDriver.metrics();
        }
        return Collections.unmodifiableMap(this.metrics.metrics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PartitionInfo> partitionsFor(String topic) {
        if (this.consumerDriver == null) {
            this.initializeConsumer(topic);
        }
        if (this.consumerDriver == null) {
            this.log.error("consumer closed, cannot get partitionsFor " + topic);
            return null;
        }
        if (this.isStreams) {
            topic = this.getNewTopicNameWithDefaultStream(topic);
            return this.consumerDriver.partitionsFor(topic);
        }
        this.acquireAndEnsureOpen();
        try {
            Cluster cluster = this.metadata.fetch();
            List<PartitionInfo> parts = cluster.partitionsForTopic(topic);
            if (!parts.isEmpty()) {
                List<PartitionInfo> list = parts;
                return list;
            }
            Map<String, List<PartitionInfo>> topicMetadata = this.fetcher.getTopicMetadata(new MetadataRequest.Builder(Collections.singletonList(topic), true), this.requestTimeoutMs);
            List<PartitionInfo> list = topicMetadata.get(topic);
            return list;
        }
        finally {
            this.release();
        }
    }

    @Override
    public Map<String, List<PartitionInfo>> listTopics() {
        if (this.consumerDriver == null) {
            this.log.info("consumer closed or not initialized, cannot listTopics");
            return new HashMap<String, List<PartitionInfo>>();
        }
        if (this.isStreams) {
            if (this.defaultStream == null) {
                throw new KafkaException("Cannot get listTopics() without default stream name");
            }
            return this.consumerDriver.listTopics(this.defaultStream);
        }
        this.acquireAndEnsureOpen();
        try {
            Map<String, List<PartitionInfo>> map = this.fetcher.getAllTopicMetadata(this.requestTimeoutMs);
            return map;
        }
        finally {
            this.release();
        }
    }

    @Override
    public Map<String, List<PartitionInfo>> listTopics(String stream) {
        if (this.consumerDriver == null) {
            this.initializeConsumer(stream + ":");
        }
        if (this.consumerDriver == null) {
            this.log.info("consumer closed or not initialized, cannot listTopics");
            return new HashMap<String, List<PartitionInfo>>();
        }
        if (this.isStreams) {
            return this.consumerDriver.listTopics(stream);
        }
        throw new KafkaException("Unsupported method for KafkaConsumer");
    }

    @Override
    public Map<String, List<PartitionInfo>> listTopics(Pattern pattern) {
        if (this.consumerDriver == null) {
            this.initializeConsumer(pattern.toString() + ":");
        }
        if (this.consumerDriver == null) {
            this.log.info("consumer closed or not initialized, cannot listTopics");
            return new HashMap<String, List<PartitionInfo>>();
        }
        if (this.isStreams) {
            pattern = Pattern.compile(this.getNewTopicNameWithDefaultStream(pattern.toString()));
            return this.consumerDriver.listTopics(pattern);
        }
        throw new KafkaException("Unsupported method for KafkaConsumer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause(Collection<TopicPartition> partitions) {
        if (this.consumerDriver == null) {
            this.initializeConsumer(partitions.iterator().next().topic());
        }
        if (this.consumerDriver == null) {
            this.log.error("consumer closed, cannot pause");
            return;
        }
        if (this.isStreams) {
            partitions = this.getNewPartitionCollectionWithDefaultStream(partitions);
            this.consumerDriver.pause(partitions);
        } else {
            this.acquireAndEnsureOpen();
            try {
                this.log.debug("Pausing partitions {}", partitions);
                for (TopicPartition partition : partitions) {
                    this.subscriptions.pause(partition);
                }
            }
            finally {
                this.release();
            }
        }
    }

    @Override
    @Deprecated
    public void pause(TopicPartition ... partitions) {
        this.pause(Arrays.asList(partitions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume(Collection<TopicPartition> partitions) {
        if (this.consumerDriver == null) {
            this.initializeConsumer(partitions.iterator().next().topic());
        }
        if (this.consumerDriver == null) {
            this.log.error("consumer closed, cannot resume");
            return;
        }
        if (this.isStreams) {
            partitions = this.getNewPartitionCollectionWithDefaultStream(partitions);
            this.consumerDriver.resume(partitions);
        } else {
            this.acquireAndEnsureOpen();
            try {
                this.log.debug("Resuming partitions {}", partitions);
                for (TopicPartition partition : partitions) {
                    this.subscriptions.resume(partition);
                }
            }
            finally {
                this.release();
            }
        }
    }

    @Override
    @Deprecated
    public void resume(TopicPartition ... partitions) {
        this.resume(Arrays.asList(partitions));
    }

    @Override
    public Set<TopicPartition> paused() {
        if (this.consumerDriver == null) {
            return new HashSet<TopicPartition>();
        }
        if (this.isStreams) {
            return this.consumerDriver.paused();
        }
        this.acquireAndEnsureOpen();
        try {
            Set<TopicPartition> set = Collections.unmodifiableSet(this.subscriptions.pausedPartitions());
            return set;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch) {
        if (timestampsToSearch.isEmpty()) {
            return Collections.emptyMap();
        }
        if (this.consumerDriver == null) {
            this.initializeConsumer(timestampsToSearch.keySet().iterator().next().topic());
        }
        if (this.consumerDriver == null) {
            this.log.error("consumer closed, cannot get offsetsForTimes");
            return new HashMap<TopicPartition, OffsetAndTimestamp>();
        }
        if (this.isStreams) {
            Map<TopicPartition, Object> newTimestampsToSearch = this.getNewPartitionMapWithDefaultStream(timestampsToSearch);
            return this.consumerDriver.offsetsForTimes(newTimestampsToSearch);
        }
        this.acquireAndEnsureOpen();
        try {
            for (Map.Entry<TopicPartition, Long> entry : timestampsToSearch.entrySet()) {
                if (entry.getValue() >= 0L) continue;
                throw new IllegalArgumentException("The target time for partition " + entry.getKey() + " is " + entry.getValue() + ". The target time cannot be negative.");
            }
            Map<TopicPartition, OffsetAndTimestamp> map = this.fetcher.offsetsByTimes(timestampsToSearch, this.requestTimeoutMs);
            return map;
        }
        finally {
            this.release();
        }
    }

    @Override
    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions) {
        if (partitions.isEmpty()) {
            return Collections.emptyMap();
        }
        if (this.consumerDriver == null) {
            this.initializeConsumer(partitions.iterator().next().topic());
        }
        if (this.consumerDriver == null) {
            this.log.error("consumer closed, cannot get endOffsets");
            return new HashMap<TopicPartition, Long>();
        }
        if (this.isStreams) {
            Collection<TopicPartition> newPartitions = this.getNewPartitionCollectionWithDefaultStream(partitions);
            return this.consumerDriver.beginningOffsets(newPartitions);
        }
        this.acquireAndEnsureOpen();
        try {
            Map<TopicPartition, Long> map = this.fetcher.beginningOffsets(partitions, this.requestTimeoutMs);
            return map;
        }
        finally {
            this.release();
        }
    }

    @Override
    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
        if (partitions.isEmpty()) {
            return Collections.emptyMap();
        }
        if (this.consumerDriver == null) {
            this.initializeConsumer(partitions.iterator().next().topic());
        }
        if (this.consumerDriver == null) {
            this.log.error("consumer closed, cannot get endOffsets");
            return new HashMap<TopicPartition, Long>();
        }
        if (this.isStreams) {
            Collection<TopicPartition> newPartitions = this.getNewPartitionCollectionWithDefaultStream(partitions);
            return this.consumerDriver.endOffsets(newPartitions);
        }
        this.acquireAndEnsureOpen();
        try {
            Map<TopicPartition, Long> map = this.fetcher.endOffsets(partitions, this.requestTimeoutMs);
            return map;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Consumer<K, V> consumerDriverToDelete = null;
        KafkaConsumer kafkaConsumer = this;
        synchronized (kafkaConsumer) {
            if (this.isStreamsClosed) {
                return;
            }
            this.isStreamsClosed = true;
            if (this.consumerDriver == null) {
                return;
            }
            consumerDriverToDelete = this.consumerDriver;
            this.consumerDriver = null;
        }
        if (this.isStreams) {
            consumerDriverToDelete.close();
        } else {
            this.close(30000L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(long timeout, TimeUnit timeUnit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("The timeout cannot be negative.");
        }
        Consumer<K, V> consumerDriverToDelete = null;
        KafkaConsumer kafkaConsumer = this;
        synchronized (kafkaConsumer) {
            if (this.isStreamsClosed) {
                return;
            }
            this.isStreamsClosed = true;
            if (this.consumerDriver == null) {
                return;
            }
            consumerDriverToDelete = this.consumerDriver;
            this.consumerDriver = null;
        }
        if (this.isStreams) {
            consumerDriverToDelete.close(timeout, timeUnit);
        } else {
            this.acquire();
            try {
                this.close(timeUnit.toMillis(timeout), false);
            }
            finally {
                this.release();
            }
        }
    }

    @Override
    public void wakeup() {
        if (this.consumerDriver == null) {
            this.log.info("consumed not initialized, cannot wakeup");
            return;
        }
        if (this.closed || this.isStreamsClosed) {
            this.log.error("Consumer closed, cannot wake up.");
            return;
        }
        if (this.isStreams) {
            this.consumerDriver.wakeup();
        } else {
            this.client.wakeup();
        }
    }

    private ClusterResourceListeners configureClusterResourceListeners(Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, List<?> ... candidateLists) {
        ClusterResourceListeners clusterResourceListeners = new ClusterResourceListeners();
        for (List<?> candidateList : candidateLists) {
            clusterResourceListeners.maybeAddAll(candidateList);
        }
        clusterResourceListeners.maybeAdd(keyDeserializer);
        clusterResourceListeners.maybeAdd(valueDeserializer);
        return clusterResourceListeners;
    }

    private void close(long timeoutMs, boolean swallowException) {
        this.log.trace("Closing the Kafka consumer");
        AtomicReference<Throwable> firstException = new AtomicReference<Throwable>();
        try {
            if (this.coordinator != null) {
                this.coordinator.close(Math.min(timeoutMs, this.requestTimeoutMs));
            }
        }
        catch (Throwable t) {
            firstException.compareAndSet(null, t);
            this.log.error("Failed to close coordinator", t);
        }
        ClientUtils.closeQuietly(this.fetcher, "fetcher", firstException);
        ClientUtils.closeQuietly(this.interceptors, "consumer interceptors", firstException);
        ClientUtils.closeQuietly(this.metrics, "consumer metrics", firstException);
        ClientUtils.closeQuietly(this.client, "consumer network client", firstException);
        ClientUtils.closeQuietly(this.keyDeserializer, "consumer key deserializer", firstException);
        ClientUtils.closeQuietly(this.valueDeserializer, "consumer value deserializer", firstException);
        AppInfoParser.unregisterAppInfo(JMX_PREFIX, this.clientId, this.metrics);
        this.log.debug("Kafka consumer has been closed");
        Throwable exception = firstException.get();
        if (exception != null && !swallowException) {
            if (exception instanceof InterruptException) {
                throw (InterruptException)exception;
            }
            throw new KafkaException("Failed to close kafka consumer", exception);
        }
    }

    private boolean updateFetchPositions() {
        if (this.subscriptions.hasAllFetchPositions()) {
            return true;
        }
        this.coordinator.refreshCommittedOffsetsIfNeeded();
        this.subscriptions.resetMissingPositions();
        this.fetcher.resetOffsetsIfNeeded();
        return false;
    }

    private void acquireAndEnsureOpen() {
        this.acquire();
        if (this.closed) {
            this.release();
            throw new IllegalStateException("This consumer has already been closed.");
        }
    }

    private void acquire() {
        long threadId = Thread.currentThread().getId();
        if (threadId != this.currentThread.get() && !this.currentThread.compareAndSet(-1L, threadId)) {
            throw new ConcurrentModificationException("KafkaConsumer is not safe for multi-threaded access");
        }
        this.refcount.incrementAndGet();
    }

    private void release() {
        if (this.refcount.decrementAndGet() == 0) {
            this.currentThread.set(-1L);
        }
    }

    private void throwIfNoAssignorsConfigured() {
        if (this.assignors.isEmpty()) {
            throw new IllegalStateException("Must configure at least one partition assigner class name to partition.assignment.strategy configuration property");
        }
    }
}

