/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source.scribe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDrivenSource;
import org.apache.flume.conf.Configurable;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.instrumentation.SourceCounter;
import org.apache.flume.source.AbstractSource;
import org.apache.flume.source.scribe.LogEntry;
import org.apache.flume.source.scribe.ResultCode;
import org.apache.flume.source.scribe.Scribe;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScribeSource
extends AbstractSource
implements EventDrivenSource,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(ScribeSource.class);
    public static final String SCRIBE_CATEGORY = "category";
    private static final int DEFAULT_PORT = 1499;
    private static final int DEFAULT_WORKERS = 5;
    private static final int DEFAULT_MAX_READ_BUFFER_BYTES = 0xFA0000;
    private TServer server;
    private int port;
    private int workers;
    private int maxReadBufferBytes;
    private SourceCounter sourceCounter;

    public void configure(Context context) {
        this.port = context.getInteger("port", Integer.valueOf(1499));
        this.maxReadBufferBytes = context.getInteger("maxReadBufferBytes", Integer.valueOf(0xFA0000));
        if (this.maxReadBufferBytes <= 0) {
            this.maxReadBufferBytes = 0xFA0000;
        }
        this.workers = context.getInteger("workerThreads", Integer.valueOf(5));
        if (this.workers <= 0) {
            this.workers = 5;
        }
        if (this.sourceCounter == null) {
            this.sourceCounter = new SourceCounter(this.getName());
        }
    }

    public void start() {
        Startup startupThread = new Startup();
        startupThread.start();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.server.isServing()) {
            throw new IllegalStateException("Failed initialization of ScribeSource");
        }
        this.sourceCounter.start();
        super.start();
    }

    public void stop() {
        LOG.info("Scribe source stopping");
        if (this.server != null) {
            this.server.stop();
        }
        this.sourceCounter.stop();
        super.stop();
        LOG.info("Scribe source stopped. Metrics:{}", (Object)this.sourceCounter);
    }

    class Receiver
    implements Scribe.Iface {
        Receiver() {
        }

        @Override
        public ResultCode Log(List<LogEntry> list) throws TException {
            if (list != null) {
                ScribeSource.this.sourceCounter.addToEventReceivedCount((long)list.size());
                try {
                    ArrayList<Event> events = new ArrayList<Event>(list.size());
                    for (LogEntry entry : list) {
                        HashMap<String, String> headers = new HashMap<String, String>(1, 1.0f);
                        String category = entry.getCategory();
                        if (category != null) {
                            headers.put(ScribeSource.SCRIBE_CATEGORY, category);
                        }
                        Event event = EventBuilder.withBody((byte[])entry.getMessage().getBytes(), headers);
                        events.add(event);
                    }
                    if (events.size() > 0) {
                        ScribeSource.this.getChannelProcessor().processEventBatch(events);
                    }
                    ScribeSource.this.sourceCounter.addToEventAcceptedCount((long)list.size());
                    return ResultCode.OK;
                }
                catch (Exception e) {
                    LOG.warn("Scribe source handling failure", (Throwable)e);
                }
            }
            return ResultCode.TRY_LATER;
        }
    }

    private class Startup
    extends Thread {
        private Startup() {
        }

        @Override
        public void run() {
            try {
                Scribe.Processor<Receiver> processor = new Scribe.Processor<Receiver>(new Receiver());
                TNonblockingServerSocket transport = new TNonblockingServerSocket(ScribeSource.this.port);
                THsHaServer.Args args = new THsHaServer.Args((TNonblockingServerTransport)transport);
                args.minWorkerThreads(ScribeSource.this.workers);
                args.maxWorkerThreads(ScribeSource.this.workers);
                args.processor(processor);
                args.transportFactory((TTransportFactory)new TFramedTransport.Factory(ScribeSource.this.maxReadBufferBytes));
                args.protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory(false, false));
                args.maxReadBufferBytes = ScribeSource.this.maxReadBufferBytes;
                ScribeSource.this.server = (TServer)new THsHaServer(args);
                LOG.info("Starting Scribe Source on port " + ScribeSource.this.port);
                ScribeSource.this.server.serve();
            }
            catch (Exception e) {
                LOG.warn("Scribe failed", (Throwable)e);
            }
        }
    }
}

