/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest.util;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.rest.errors.SSLConfigException;
import org.apache.kafka.connect.tools.KafkaSSLPropertiesReader;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SSLUtils {
    public static SslContextFactory createSslContextFactory(WorkerConfig config) {
        return SSLUtils.createSslContextFactory(config, false);
    }

    public static SslContextFactory createSslContextFactory(WorkerConfig config, boolean client) {
        Map sslConfigValues = config.valuesWithPrefixAllOrNothing("listeners.https.");
        SslContextFactory ssl = new SslContextFactory();
        SSLUtils.configureSslContextFactoryKeyStore(ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryTrustStore(ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryAlgorithms(ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryAuthentication(ssl, sslConfigValues);
        if (client) {
            SSLUtils.configureSslContextFactoryEndpointIdentification(ssl, sslConfigValues);
        }
        return ssl;
    }

    private static void configureSslContextFactoryKeyStore(SslContextFactory ssl, Map<String, Object> sslConfigValues) {
        ssl.setKeyStoreType((String)SSLUtils.getOrDefault(sslConfigValues, "ssl.keystore.type", "JKS"));
        String sslKeystoreLocation = (String)sslConfigValues.get("ssl.keystore.location");
        if (sslKeystoreLocation != null) {
            ssl.setKeyStorePath(sslKeystoreLocation);
        } else {
            sslKeystoreLocation = KafkaSSLPropertiesReader.getClientKeystoreLocation();
            if (sslKeystoreLocation == null) {
                throw new SSLConfigException("ssl.keystore.location");
            }
            ssl.setKeyStorePath(sslKeystoreLocation);
        }
        Password sslKeystorePassword = (Password)sslConfigValues.get("ssl.keystore.password");
        if (sslKeystorePassword != null && !Objects.equals(sslKeystorePassword.value(), "")) {
            ssl.setKeyStorePassword(sslKeystorePassword.value());
        } else {
            String tmpSslKeystorePassword = KafkaSSLPropertiesReader.getClientKeystorePassword();
            if (Objects.equals(tmpSslKeystorePassword, "")) {
                throw new SSLConfigException("ssl.keystore.password");
            }
            ssl.setKeyStorePassword(tmpSslKeystorePassword);
        }
        Password sslKeyPassword = (Password)sslConfigValues.get("ssl.key.password");
        if (sslKeyPassword != null && !Objects.equals(sslKeyPassword.value(), "")) {
            ssl.setKeyManagerPassword(sslKeyPassword.value());
        } else {
            String tmpSslKeyPassword = KafkaSSLPropertiesReader.getClientKeyPassword();
            if (Objects.equals(tmpSslKeyPassword, "")) {
                throw new SSLConfigException("ssl.key.password");
            }
            ssl.setKeyManagerPassword(tmpSslKeyPassword);
        }
    }

    protected static Object getOrDefault(Map<String, Object> configMap, String key, Object defaultValue) {
        if (configMap.containsKey(key)) {
            return configMap.get(key);
        }
        return defaultValue;
    }

    protected static void configureSslContextFactoryTrustStore(SslContextFactory ssl, Map<String, Object> sslConfigValues) {
        Password sslTruststorePassword;
        ssl.setTrustStoreType((String)SSLUtils.getOrDefault(sslConfigValues, "ssl.truststore.type", "JKS"));
        String sslTruststoreLocation = (String)sslConfigValues.get("ssl.truststore.location");
        if (sslTruststoreLocation != null) {
            ssl.setTrustStorePath(sslTruststoreLocation);
        }
        if ((sslTruststorePassword = (Password)sslConfigValues.get("ssl.truststore.password")) != null) {
            ssl.setTrustStorePassword(sslTruststorePassword.value());
        }
    }

    protected static void configureSslContextFactoryAlgorithms(SslContextFactory ssl, Map<String, Object> sslConfigValues) {
        List sslEnabledProtocols = (List)SSLUtils.getOrDefault(sslConfigValues, "ssl.enabled.protocols", Arrays.asList("TLSv1.2,TLSv1.1".split("\\s*,\\s*")));
        ssl.setIncludeProtocols(sslEnabledProtocols.toArray(new String[sslEnabledProtocols.size()]));
        String sslProvider = (String)sslConfigValues.get("ssl.provider");
        if (sslProvider != null) {
            ssl.setProvider(sslProvider);
        }
        ssl.setProtocol((String)SSLUtils.getOrDefault(sslConfigValues, "ssl.protocol", "TLSv1.2"));
        List sslCipherSuites = (List)sslConfigValues.get("ssl.cipher.suites");
        if (sslCipherSuites != null) {
            ssl.setIncludeCipherSuites(sslCipherSuites.toArray(new String[sslCipherSuites.size()]));
        }
        ssl.setSslKeyManagerFactoryAlgorithm((String)SSLUtils.getOrDefault(sslConfigValues, "ssl.keymanager.algorithm", SslConfigs.DEFAULT_SSL_KEYMANGER_ALGORITHM));
        String sslSecureRandomImpl = (String)sslConfigValues.get("ssl.secure.random.implementation");
        if (sslSecureRandomImpl != null) {
            ssl.setSecureRandomAlgorithm(sslSecureRandomImpl);
        }
        ssl.setTrustManagerFactoryAlgorithm((String)SSLUtils.getOrDefault(sslConfigValues, "ssl.trustmanager.algorithm", SslConfigs.DEFAULT_SSL_TRUSTMANAGER_ALGORITHM));
    }

    protected static void configureSslContextFactoryEndpointIdentification(SslContextFactory ssl, Map<String, Object> sslConfigValues) {
        String sslEndpointIdentificationAlg = (String)sslConfigValues.get("ssl.endpoint.identification.algorithm");
        if (sslEndpointIdentificationAlg != null) {
            ssl.setEndpointIdentificationAlgorithm(sslEndpointIdentificationAlg);
        }
    }

    protected static void configureSslContextFactoryAuthentication(SslContextFactory ssl, Map<String, Object> sslConfigValues) {
        String sslClientAuth;
        switch (sslClientAuth = (String)SSLUtils.getOrDefault(sslConfigValues, "ssl.client.auth", "none")) {
            case "requested": {
                ssl.setWantClientAuth(true);
                break;
            }
            case "required": {
                ssl.setNeedClientAuth(true);
                break;
            }
            default: {
                ssl.setNeedClientAuth(false);
                ssl.setWantClientAuth(false);
            }
        }
    }
}

